/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.commons.database.accessor;

import java.sql.ResultSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.phosphoresce.commons.database.accessor.RecordBufferedAccessor;
import org.phosphoresce.commons.database.accessor.ResultAccessorState;
import org.phosphoresce.commons.database.accessor.ResultColumn;
import org.phosphoresce.commons.database.accessor.ResultRow;
import org.phosphoresce.commons.database.accessor.ResultTemplateColumn;
import org.phosphoresce.commons.database.accessor.ResultTemplateRow;
import org.phosphoresce.commons.database.exception.IllegalOperateRuntimeException;
import org.phosphoresce.commons.database.exception.IllegalResultSetAdjustmentException;
import org.phosphoresce.commons.database.exception.IllegalResultSetLocationIndexException;
import org.phosphoresce.commons.database.exception.IllegalResultTypeException;
import org.phosphoresce.commons.database.exception.IllegalTemplateException;
import org.phosphoresce.commons.database.exception.ResultSetAccessException;

public class RecordListBufferedAccessor
extends RecordBufferedAccessor
implements List {
    public RecordListBufferedAccessor(ResultSet resultSet) throws ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException {
        super(resultSet);
    }

    public boolean add(Object object) {
        if (object == null || !(object instanceof ResultTemplateRow)) {
            throw new IllegalArgumentException("is not instancedof template row object");
        }
        try {
            this.insertRow((ResultTemplateRow)object);
        }
        catch (ResultSetAccessException e) {
            throw new IllegalOperateRuntimeException("failed to insert row", e);
        }
        catch (IllegalResultSetLocationIndexException e) {
            throw new IllegalOperateRuntimeException("failed to insert row", e);
        }
        catch (IllegalResultSetAdjustmentException e) {
            throw new IllegalOperateRuntimeException("failed to insert row", e);
        }
        catch (IllegalResultTypeException e) {
            throw new IllegalOperateRuntimeException("failed to insert row", e);
        }
        catch (IllegalTemplateException e) {
            throw new IllegalOperateRuntimeException("failed to insert row", e);
        }
        return true;
    }

    public void add(int index, Object element) {
        if (element == null) {
            throw new IllegalOperateRuntimeException("null 'element' argument");
        }
        if (!(element instanceof ResultTemplateRow)) {
            throw new IllegalOperateRuntimeException("object is not ResultTemplateRow class");
        }
        this.add(element);
    }

    public boolean addAll(Collection collection) {
        if (collection == null) {
            return false;
        }
        boolean update = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (object == null) continue;
            this.add(object);
            update = true;
        }
        return update;
    }

    public boolean addAll(int index, Collection collection) {
        return this.addAll(collection);
    }

    public void clear() {
        while (this.fetchBuffer.size() > 0) {
            this.remove(0);
        }
    }

    public boolean contains(Object object) {
        if (!(object instanceof ResultRow)) {
            throw new IllegalOperateRuntimeException("object is not ResultRow class");
        }
        return this.fetchBuffer.contains(object);
    }

    public boolean containsAll(Collection collection) {
        return this.fetchBuffer.containsAll(collection);
    }

    public Object get(int index) {
        return this.fetchBuffer.get(index);
    }

    public int indexOf(Object object) {
        if (!(object instanceof ResultRow)) {
            throw new IllegalOperateRuntimeException("object is not ResultRow class");
        }
        return this.fetchBuffer.indexOf(object);
    }

    public boolean isEmpty() {
        return this.fetchBuffer.isEmpty();
    }

    public Iterator iterator() {
        return this.fetchBuffer.iterator();
    }

    public int lastIndexOf(Object object) {
        if (!(object instanceof ResultRow)) {
            throw new IllegalOperateRuntimeException("object is not ResultRow class");
        }
        return this.fetchBuffer.lastIndexOf(object);
    }

    public ListIterator listIterator() {
        return this.fetchBuffer.listIterator();
    }

    public ListIterator listIterator(int index) {
        return this.fetchBuffer.listIterator(index);
    }

    public Object remove(int index) {
        try {
            ResultRow row = (ResultRow)this.fetchBuffer.get(index);
            if (row.state != ResultAccessorState.INSERT) {
                this.deleteRow(index);
                row.updateResult();
            }
            this.fetchBuffer.remove(index);
            return row;
        }
        catch (ResultSetAccessException e) {
            throw new IllegalOperateRuntimeException("failed to delete row", e);
        }
        catch (IllegalResultSetLocationIndexException e) {
            throw new IllegalOperateRuntimeException("failed to delete row", e);
        }
        catch (IllegalResultSetAdjustmentException e) {
            throw new IllegalOperateRuntimeException("failed to delete row", e);
        }
    }

    public boolean remove(Object object) {
        if (!(object instanceof ResultRow)) {
            throw new IllegalOperateRuntimeException("object is not ResultRow class");
        }
        try {
            int index = this.fetchBuffer.indexOf(object);
            if (index < 0) {
                return false;
            }
            ResultRow row = (ResultRow)this.fetchBuffer.get(index);
            if (row.state != ResultAccessorState.INSERT) {
                this.deleteRow(index);
                row.updateResult();
            }
            this.fetchBuffer.remove(index);
            return true;
        }
        catch (ResultSetAccessException e) {
            throw new IllegalOperateRuntimeException("failed to delete row", e);
        }
        catch (IllegalResultSetLocationIndexException e) {
            throw new IllegalOperateRuntimeException("failed to delete row", e);
        }
        catch (IllegalResultSetAdjustmentException e) {
            throw new IllegalOperateRuntimeException("failed to delete row", e);
        }
    }

    public boolean removeAll(Collection collection) {
        if (collection == null) {
            return false;
        }
        boolean update = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (object == null) continue;
            update = this.remove(object);
        }
        return update;
    }

    public boolean retainAll(Collection collection) {
        if (collection == null) {
            return false;
        }
        boolean update = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (object == null || this.fetchBuffer.contains(object)) continue;
            update = this.remove(object);
        }
        return update;
    }

    public Object set(int index, Object element) {
        try {
            if (element == null || !(element instanceof ResultTemplateRow) && !(element instanceof ResultRow)) {
                throw new IllegalArgumentException("is not instancedof template row or row object");
            }
            ResultRow row = (ResultRow)this.fetchBuffer.get(index);
            if (element instanceof ResultTemplateRow) {
                ResultTemplateRow elementRow = (ResultTemplateRow)element;
                if (!row.getDefinition().equals(elementRow.getDefinition())) {
                    throw new IllegalTemplateException("illegal different template information was specified");
                }
                for (int i = 0; i <= row.getDefinition().getColumnCount() - 1; ++i) {
                    ResultTemplateColumn elementColumn = elementRow.getColumn(i);
                    ResultColumn column = row.getColumn(i);
                    if (!column.getDefinition().equals(elementColumn.getDefinition())) {
                        throw new IllegalTemplateException("illegal different template information was specified");
                    }
                    column.setValue(elementColumn.getValue());
                }
            } else if (element instanceof ResultRow) {
                ResultRow elementRow = (ResultRow)element;
                if (!row.getDefinition().equals(elementRow.getDefinition())) {
                    throw new IllegalTemplateException("illegal different template information was specified");
                }
                for (int i = 0; i <= row.getDefinition().getColumnCount() - 1; ++i) {
                    ResultColumn elementColumn = elementRow.getColumn(i);
                    ResultColumn column = row.getColumn(i);
                    if (!column.getDefinition().equals(elementColumn.getDefinition())) {
                        throw new IllegalTemplateException("illegal different template information was specified");
                    }
                    column.setValue(elementColumn.getValue());
                }
            }
            return row;
        }
        catch (IllegalTemplateException e) {
            throw new IllegalOperateRuntimeException("failed to set row", e);
        }
        catch (IllegalResultSetLocationIndexException e) {
            throw new IllegalOperateRuntimeException("failed to set row", e);
        }
    }

    public int size() {
        return this.fetchBuffer.size();
    }

    public List subList(int fromIndex, int toIndex) {
        return this.fetchBuffer.subList(fromIndex, toIndex);
    }

    public Object[] toArray() {
        return this.fetchBuffer.toArray();
    }

    public Object[] toArray(Object[] objects) {
        return this.fetchBuffer.toArray(objects);
    }
}

