/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.commons.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public final class ZipUtil {
    public static int BYTE_LENGTH = 1024;
    public static final String DEFAULT_CHARSET = "MS932";
    private static final String KEY_ENTRY_NAME = ZipContainer.class.getName() + ".KEY_ENTRY_NAME";
    private static final String KEY_ENTRY_FILE = ZipContainer.class.getName() + ".KEY_ENTRY_FILE";

    private ZipUtil() {
    }

    public static void create(File file, ZipContainer container) throws IOException {
        ZipUtil.create(file, container, DEFAULT_CHARSET);
    }

    public static void create(File file, ZipContainer container, String charset) throws IOException {
        ZipOutputStream os = new ZipOutputStream(new FileOutputStream(file));
        Iterator iterator = container.iterator();
        while (iterator.hasNext()) {
            int count;
            Map map = (Map)iterator.next();
            String name = (String)map.get(KEY_ENTRY_NAME);
            File resource = (File)map.get(KEY_ENTRY_FILE);
            ZipEntry entry = new ZipEntry(name);
            os.putNextEntry(entry);
            byte[] bytes = new byte[BYTE_LENGTH];
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(resource));
            while ((count = is.read(bytes, 0, BYTE_LENGTH)) != -1) {
                os.write(bytes, 0, count);
            }
            is.close();
            os.closeEntry();
        }
        os.close();
    }

    public static void unzip(File file, File directory) throws IOException {
        String target = directory == null ? "" : (directory.getAbsolutePath().endsWith(File.separator) ? directory.getAbsolutePath() : directory.getAbsolutePath() + File.separator);
        ZipFile zipFile = new ZipFile(file);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry entry = enumeration.nextElement();
            if (entry.isDirectory()) {
                new File(target + entry.getName()).mkdirs();
                continue;
            }
            File parent = new File(target + entry.getName()).getParentFile();
            parent.mkdirs();
            FileOutputStream out = new FileOutputStream(target + entry.getName());
            InputStream in = zipFile.getInputStream(entry);
            byte[] buf = new byte[1024];
            int size = 0;
            while ((size = in.read(buf)) != -1) {
                out.write(buf, 0, size);
            }
            out.close();
        }
    }

    public static void unzip(File file) throws IOException {
        ZipUtil.unzip(file, null);
    }

    public static final class ZipContainer {
        private List list = new LinkedList();

        public void add(String name, File file) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(KEY_ENTRY_NAME, name);
            map.put(KEY_ENTRY_FILE, file);
            this.list.add(map);
        }

        private Iterator iterator() {
            return this.list.iterator();
        }
    }
}

