/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.dbbrowser.gui.panel.querymanage;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.DefaultListModel;
import javax.swing.border.EmptyBorder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.phosphoresce.commons.database.core.DatabaseError;
import org.phosphoresce.commons.eswing.EList;
import org.phosphoresce.commons.eswing.EScrollPane;
import org.phosphoresce.dbbrowser.gui.RefreshableComponent;

public final class QueryManageErrorListPane
extends EScrollPane
implements RefreshableComponent {
    private Log log = LogFactory.getLog(this.getClass());
    private static QueryManageErrorListPane instance = null;
    private EList errorList = null;

    public QueryManageErrorListPane() {
        this.initialize();
    }

    public static QueryManageErrorListPane instance() {
        if (instance == null) {
            instance = new QueryManageErrorListPane();
        }
        return instance;
    }

    public void refresh() throws Throwable {
        this.clearError();
    }

    private void initialize() {
        this.setHorizontalScrollBarPolicy(31);
        this.setViewportView((Component)this.getErrorList());
        this.setSize(new Dimension(600, 400));
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
    }

    private EList getErrorList() {
        if (this.errorList == null) {
            this.errorList = new EList();
            this.errorList.setModel(new DefaultListModel());
        }
        return this.errorList;
    }

    public void clearError() {
        DefaultListModel model = (DefaultListModel)this.getErrorList().getModel();
        model.removeAllElements();
    }

    public void addError(DatabaseError error) {
        if (error == null) {
            return;
        }
        DefaultListModel model = (DefaultListModel)this.getErrorList().getModel();
        if (error.isSQLException()) {
            model.addElement(error.getErrorMessage() + " (errorCode=" + error.getErrorCode() + ")");
        } else {
            model.addElement(error.getErrorMessage());
        }
    }

    public void addError(DatabaseError[] errors) {
        if (errors == null) {
            return;
        }
        for (int i = 0; i <= errors.length - 1; ++i) {
            this.addError(errors[i]);
        }
    }
}

