/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.commons.eswing.core;

import java.awt.Component;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import org.phosphoresce.commons.eswing.core.ESwingConfig;
import org.phosphoresce.commons.eswing.exception.ESwingComponentIllegalStateException;

public final class ESwingConfigManager {
    private ESwingConfigManager() {
    }

    public static void configure() {
        ESwingConfigManager.configureLookAndFeel();
        ESwingConfigManager.configureFont();
        ESwingConfigManager.configureIcons();
    }

    public static void configureIcons() {
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        defaults.put("FileChooser.detailsViewIcon", ESwingConfig.getFilechooserDetailsViewIcon());
        defaults.put("FileChooser.listViewIcon", ESwingConfig.getFilechooserListViewIcon());
        defaults.put("FileChooser.newFolderIcon", ESwingConfig.getFilechooserNewFolderIcon());
        defaults.put("FileChooser.upFolderIcon", ESwingConfig.getFilechooserUpFolderIcon());
    }

    public static void configureFont() {
        FontUIResource containerFont = new FontUIResource(ESwingConfig.getContainerFont());
        FontUIResource passwordFont = new FontUIResource(ESwingConfig.getPasswordFont());
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        Iterator iterator = defaults.keySet().iterator();
        while (iterator.hasNext()) {
            Object key = iterator.next();
            if (!key.toString().toLowerCase().endsWith("font")) continue;
            if (key.toString().toLowerCase().indexOf("password") >= 0) {
                UIManager.put(key, passwordFont);
                continue;
            }
            UIManager.put(key, containerFont);
        }
    }

    public static void configureLookAndFeel() {
        try {
            UIManager.setLookAndFeel(ESwingConfig.getLookAndFeelName());
        }
        catch (Exception e1) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception e2) {
                throw new ESwingComponentIllegalStateException("failed to apply look and feel", e1);
            }
        }
    }

    public static void updateLookAndFeel(Component component) {
        ESwingConfigManager.configureLookAndFeel();
        SwingUtilities.updateComponentTreeUI(component);
    }

    public static void updateFont(Component component) {
        ESwingConfigManager.configureFont();
        SwingUtilities.updateComponentTreeUI(component);
    }
}

