package org.phosphoresce.dbbrowser.gui.common;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;

import javax.swing.BorderFactory;
import javax.swing.ImageIcon;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.phosphoresce.commons.eswing.ELabel;
import org.phosphoresce.commons.eswing.EPanel;
import org.phosphoresce.dbbrowser.resource.image.DatabaseBrowserImages;

/**
 * _CAOwb_pl<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/17	Kitagawa		VK쐬
 *-->
 */
public final class DialogHeaderPanel extends EPanel {

	/** K[IuWFNg */
	private Log log = LogFactory.getLog(this.getClass());

	/** AvP[VSC[Wx */
	private ELabel applicationLogoImage = null;

	/** wb_bZ[W */
	private ELabel headerMessage = null;

	/**
	 * RXgN^<br>
	 */
	public DialogHeaderPanel() {
		super();
		initialize();
	}

	/**
	 * R|[lgs܂B<br>
	 */
	private void initialize() {
		this.setLayout(null);
		this.setBackground(Color.white);
		this.setBorder(BorderFactory.createMatteBorder(0, 0, 2, 0, Color.black));
		this.setSize(new Dimension(400, 62));
		this.setPreferredSize(new Dimension(400, 62));
		this.setMinimumSize(new Dimension(1, 62));
		this.setMaximumSize(new Dimension(32767, 62));
		this.add(getApplicationLogoImage(), null);
		this.add(getHeaderMessage(), null);
	}

	/**
	 * AvP[VSC[Wx擾܂B<br>
	 * @return AvP[VSC[Wx
	 */
	private ELabel getApplicationLogoImage() {
		if (applicationLogoImage == null) {
			applicationLogoImage = new ELabel();
			applicationLogoImage.setBounds(new Rectangle(10, 10, 161, 24));
			applicationLogoImage.setIcon(new ImageIcon(DatabaseBrowserImages.IMAGE_APP_LOGO_24));
		}
		return applicationLogoImage;
	}

	/**
	 * wb_bZ[W擾܂B<br>
	 * @return wb_bZ[W	
	 */
	private ELabel getHeaderMessage() {
		if (headerMessage == null) {
			headerMessage = new ELabel();
			headerMessage.setText("");
			headerMessage.setBounds(new Rectangle(15, 35, 51, 22));
		}
		return headerMessage;
	}

	/**
	 * R|[lg̓K؂ȃTCY̐ݒ^C~OŃwb_bZ[WR|[lgTCYύX܂B<br>
	 * @param preferredSize DimensionIuWFNg
	 * @see javax.swing.JComponent#setPreferredSize(java.awt.Dimension)
	 */
	public void setPreferredSize(Dimension preferredSize) {
		super.setPreferredSize(preferredSize);
		Rectangle rectangle = getHeaderMessage().getBounds();
		rectangle.width = getPreferredSize().width - 30;
		getHeaderMessage().setBounds(rectangle);
	}

	/**
	 * R|[lgTCY̐ݒ^C~OŃwb_bZ[WR|[lgTCYύX܂B<br>
	 * @param dimension DimensionIuWFNg
	 * @see java.awt.Component#setSize(java.awt.Dimension)
	 */
	public void setSize(Dimension dimension) {
		super.setSize(dimension);
		Rectangle rectangle = getHeaderMessage().getBounds();
		rectangle.width = getSize().width - 30;
		getHeaderMessage().setBounds(rectangle);
	}

	/**
	 * wb_bZ[WeLXgݒ肵܂B<br>
	 * @param message bZ[W
	 */
	public void setText(String message) {
		if (message == null) {
			getHeaderMessage().setText("");
		} else {
			getHeaderMessage().setText(message);
		}
	}

	/**
	 * wb_bZ[WeLXg擾܂B<br>
	 * @return wb_bZ[WeLXg
	 */
	public String getText() {
		return getHeaderMessage().getText();
	}
}
