package org.phosphoresce.dbbrowser.gui.panel.dbinformation;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;

import javax.swing.table.DefaultTableModel;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.phosphoresce.commons.database.DatabaseSpecification;
import org.phosphoresce.commons.eswing.EFieldSet;
import org.phosphoresce.commons.eswing.EScrollPane;
import org.phosphoresce.commons.eswing.ETable;
import org.phosphoresce.dbbrowser.DatabaseBrowserSession;
import org.phosphoresce.dbbrowser.gui.RefreshableComponent;

/**
 * f[^x[XplR|[lgNX<br>
 * f[^x[XdltB[hZbg<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/17	Kitagawa		VK쐬
 *-->
 */
public class DatabaseSpecificationFieldSet extends EFieldSet implements RefreshableComponent {

	/** K[IuWFNg */
	private Log log = LogFactory.getLog(getClass());

	/** VOgZtCX^X */
	private static DatabaseSpecificationFieldSet instance = null;

	/** f[^x[Xdle[uXN[yC */
	private EScrollPane databaseSpecificationTableScrollPane = null;

	/** f[^x[Xdle[u */
	private ETable databaseSpecificationTable = null;

	/**
	 * RXgN^<br>
	 */
	private DatabaseSpecificationFieldSet() {
		super();
		initialize();
	}

	/**
	 * VOgZtCX^X擾܂B<br>
	 * @return VOgZtCX^X
	 */
	public static DatabaseSpecificationFieldSet instance() {
		if (instance == null) {
			instance = new DatabaseSpecificationFieldSet();
		}
		return instance;
	}

	/**
	 * XV܂B<br>
	 * @throws Throwable ɏ̍XVsȂꍇɔ
	 * @see org.phosphoresce.dbbrowser.gui.RefreshableComponent#refresh()
	 */
	public void refresh() throws Throwable {
		DatabaseSpecification specification = new DatabaseSpecification(DatabaseBrowserSession.instance().getCommonDatabaseSession());
		DefaultTableModel model = new DefaultTableModel();
		model.addColumn("name", new String[] { //
				//
						"MaxConnections", //
						"MaxRowSize", //
						"MaxStatements", //
						"MaxStatementLength", //
						"MaxUserNameLength", //
						"MaxCatalogNameLength", //
						"MaxSchemaNameLength", //
						"MaxTableNameLength", //
						"MaxColumnNameLength", //
						"MaxCursorNameLength", //
						"MaxProcedureNameLength", //
						"MaxIndexLength", //
						"MaxTablesInSelect", //
						"MaxBinaryLiteralLength", //
						"MaxCharLiteralLength", //
						"MaxColumnsInGroupBy", //
						"MaxColumnsInIndex", //
						"MaxColumnsInOrderBy", //
						"MaxColumnsInSelect", //
						"MaxColumnsInTable", //
						"DefaultTransactionIsolationName", //
						"ResultSetHoldabilityName", //
						"SQLStateTypeName", //
				});
		model.addColumn("value", new String[] {
		//
				String.valueOf(specification.getMaxConnections()), //
				String.valueOf(specification.getMaxRowSize()), //
				String.valueOf(specification.getMaxStatements()), //
				String.valueOf(specification.getMaxStatementLength()), //
				String.valueOf(specification.getMaxUserNameLength()), //
				String.valueOf(specification.getMaxCatalogNameLength()), //
				String.valueOf(specification.getMaxSchemaNameLength()), //
				String.valueOf(specification.getMaxTableNameLength()), //
				String.valueOf(specification.getMaxColumnNameLength()), //
				String.valueOf(specification.getMaxCursorNameLength()), //
				String.valueOf(specification.getMaxProcedureNameLength()), //
				String.valueOf(specification.getMaxIndexLength()), //
				String.valueOf(specification.getMaxTablesInSelect()), //
				String.valueOf(specification.getMaxBinaryLiteralLength()), //
				String.valueOf(specification.getMaxCharLiteralLength()), //
				String.valueOf(specification.getMaxColumnsInGroupBy()), //
				String.valueOf(specification.getMaxColumnsInIndex()), //
				String.valueOf(specification.getMaxColumnsInOrderBy()), //
				String.valueOf(specification.getMaxColumnsInSelect()), //
				String.valueOf(specification.getMaxColumnsInTable()), //
				specification.getDefaultTransactionIsolationName(), //
				specification.getResultSetHoldabilityName(), //
				specification.getSQLStateTypeName(), //
		});
		getDatabaseSpecificationTable().setModel(model);
		getDatabaseSpecificationTable().getColumnModel().getColumn(0).setMaxWidth(200);
		getDatabaseSpecificationTable().getColumnModel().getColumn(0).setMinWidth(200);
		getDatabaseSpecificationTable().setEnabled(false);
	}

	/**
	 * R|[lgs܂B<br>
	 */
	private void initialize() {
		GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
		gridBagConstraints1.fill = GridBagConstraints.BOTH;
		gridBagConstraints1.weightx = 1.0;
		gridBagConstraints1.weighty = 1.0;
		gridBagConstraints1.gridx = 0;
		gridBagConstraints1.gridy = 0;
		this.setLayout(new GridBagLayout());
		this.setSize(new Dimension(500, 200));
		this.setPreferredSize(new Dimension(500, 200));
		this.setMaximumSize(new Dimension(500, 200));
		this.setMinimumSize(new Dimension(500, 200));
		this.setText("Database Specification");
		this.add(getDatabaseSpecificationTableScrollPane(), gridBagConstraints1);
	}

	/**
	 * f[^x[Xdle[uXN[yC擾܂B<br>
	 * @return f[^x[Xdle[uXN[yC
	 */
	private EScrollPane getDatabaseSpecificationTableScrollPane() {
		if (databaseSpecificationTableScrollPane == null) {
			databaseSpecificationTableScrollPane = new EScrollPane();
			databaseSpecificationTableScrollPane.setViewportView(getDatabaseSpecificationTable());
		}
		return databaseSpecificationTableScrollPane;
	}

	/**
	 * f[^x[Xdle[u擾܂B<br>
	 * @return f[^x[Xdle[u
	 */
	private ETable getDatabaseSpecificationTable() {
		if (databaseSpecificationTable == null) {
			databaseSpecificationTable = new ETable();
		}
		return databaseSpecificationTable;
	}
}
