package org.phosphoresce.dbbrowser.gui.panel.dbinformation;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.phosphoresce.commons.database.DatabaseInformation;
import org.phosphoresce.commons.eswing.EFieldSet;
import org.phosphoresce.commons.eswing.ELabel;
import org.phosphoresce.dbbrowser.DatabaseBrowserSession;
import org.phosphoresce.dbbrowser.gui.RefreshableComponent;

/**
 * f[^x[XplR|[lgNX<br>
 * JDBCڑtB[hZbg<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/17	Kitagawa		VK쐬
 *-->
 */
public class JdbcConnectionInformationFieldSet extends EFieldSet implements RefreshableComponent {

	/** K[IuWFNg */
	private Log log = LogFactory.getLog(getClass());

	/** VOgZtCX^X */
	private static JdbcConnectionInformationFieldSet instance = null;

	/** hCoNXx */
	private ELabel driverClassNameLabel = null;

	/** hCoNX */
	private ELabel driverClassName = null;

	/** hCoo[Wx */
	private ELabel driverVersionLabel = null;

	/** hCoo[W */
	private ELabel driverVersion = null;

	/** ڑ[U[x */
	private ELabel connectionUserLabel = null;

	/** ڑ[U[ */
	private ELabel connectionUser = null;

	/** JDBCAhXx */
	private ELabel jdbcUrlLabel = null;

	/** JDBCAhX */
	private ELabel jdbcUrl = null;

	/**
	 * RXgN^<br>
	 */
	private JdbcConnectionInformationFieldSet() {
		super();
		initialize();
	}

	/**
	 * VOgZtCX^X擾܂B<br>
	 * @return VOgZtCX^X
	 */
	public static JdbcConnectionInformationFieldSet instance() {
		if (instance == null) {
			instance = new JdbcConnectionInformationFieldSet();
		}
		return instance;
	}

	/**
	 * XV܂B<br>
	 * @throws Throwable ɏ̍XVsȂꍇɔ
	 * @see org.phosphoresce.dbbrowser.gui.RefreshableComponent#refresh()
	 */
	public void refresh() throws Throwable {
		DatabaseInformation information = new DatabaseInformation(DatabaseBrowserSession.instance().getCommonDatabaseSession());
		getDriverClassName().setText(information.getDriverName());
		getDriverVersion().setText(information.getDriverVersion());
		getConnectionUser().setText(information.getUserName());
		getJdbcUrl().setText(information.getURL());
	}

	/**
	 * R|[lgs܂B<br>
	 */
	private void initialize() {
		GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
		gridBagConstraints8.insets = new Insets(0, 0, 0, 0);
		gridBagConstraints8.fill = GridBagConstraints.BOTH;
		gridBagConstraints8.weightx = 1.0D;
		gridBagConstraints8.weighty = 0.0D;
		gridBagConstraints8.gridx = 1;
		gridBagConstraints8.gridy = 3;
		GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
		gridBagConstraints7.insets = new Insets(0, 5, 0, 0);
		gridBagConstraints7.fill = GridBagConstraints.BOTH;
		gridBagConstraints7.weightx = 0.0D;
		gridBagConstraints7.weighty = 0.0D;
		gridBagConstraints7.gridx = 0;
		gridBagConstraints7.gridy = 3;
		GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
		gridBagConstraints6.insets = new Insets(0, 0, 0, 0);
		gridBagConstraints6.fill = GridBagConstraints.BOTH;
		gridBagConstraints6.weightx = 1.0D;
		gridBagConstraints6.weighty = 0.0D;
		gridBagConstraints6.gridx = 1;
		gridBagConstraints6.gridy = 2;
		GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
		gridBagConstraints5.insets = new Insets(0, 5, 0, 0);
		gridBagConstraints5.fill = GridBagConstraints.BOTH;
		gridBagConstraints5.weightx = 0.0D;
		gridBagConstraints5.weighty = 0.0D;
		gridBagConstraints5.gridx = 0;
		gridBagConstraints5.gridy = 2;
		GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
		gridBagConstraints4.insets = new Insets(0, 0, 0, 0);
		gridBagConstraints4.fill = GridBagConstraints.BOTH;
		gridBagConstraints4.weightx = 1.0D;
		gridBagConstraints4.weighty = 0.0D;
		gridBagConstraints4.gridx = 1;
		gridBagConstraints4.gridy = 1;
		GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
		gridBagConstraints3.insets = new Insets(0, 5, 0, 0);
		gridBagConstraints3.fill = GridBagConstraints.BOTH;
		gridBagConstraints3.weightx = 0.0D;
		gridBagConstraints3.weighty = 0.0D;
		gridBagConstraints3.gridx = 0;
		gridBagConstraints3.gridy = 1;
		GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
		gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
		gridBagConstraints2.fill = GridBagConstraints.BOTH;
		gridBagConstraints2.weightx = 1.0D;
		gridBagConstraints2.weighty = 0.0D;
		gridBagConstraints2.gridx = 1;
		gridBagConstraints2.gridy = 0;
		GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
		gridBagConstraints1.insets = new Insets(0, 5, 0, 0);
		gridBagConstraints1.fill = GridBagConstraints.BOTH;
		gridBagConstraints1.weightx = 0.0D;
		gridBagConstraints1.weighty = 0.0D;
		gridBagConstraints1.gridx = 0;
		gridBagConstraints1.gridy = 0;
		this.setLayout(new GridBagLayout());
		this.setSize(new Dimension(500, 128));
		this.setPreferredSize(new Dimension(500, 128));
		this.setMaximumSize(new Dimension(500, 128));
		this.setMinimumSize(new Dimension(500, 128));
		this.setText("JDBC Connection Information");
		this.add(getDriverClassNameLabel(), gridBagConstraints1);
		this.add(getDriverClassName(), gridBagConstraints2);
		this.add(getDriverVersionLabel(), gridBagConstraints3);
		this.add(getDriverVersion(), gridBagConstraints4);
		this.add(getConnectionUserLabel(), gridBagConstraints5);
		this.add(getConnectionUser(), gridBagConstraints6);
		this.add(getJdbcUrlLabel(), gridBagConstraints7);
		this.add(getJdbcUrl(), gridBagConstraints8);
	}

	/**
	 * hCoNXx擾܂B<br>
	 * @return hCoNXx
	 */
	private ELabel getDriverClassNameLabel() {
		if (driverClassNameLabel == null) {
			driverClassNameLabel = new ELabel();
			driverClassNameLabel.setPreferredSize(new Dimension(150, 22));
			driverClassNameLabel.setText("Driver Class Name :");
		}
		return driverClassNameLabel;
	}

	/**
	 * hCoNX擾܂B<br>
	 * @return hCoNX
	 */
	private ELabel getDriverClassName() {
		if (driverClassName == null) {
			driverClassName = new ELabel();
			driverClassName.setPreferredSize(new Dimension(150, 22));
		}
		return driverClassName;
	}

	/**
	 * hCoo[Wx擾܂B<br>
	 * @return hCoo[Wx
	 */
	private ELabel getDriverVersionLabel() {
		if (driverVersionLabel == null) {
			driverVersionLabel = new ELabel();
			driverVersionLabel.setPreferredSize(new Dimension(150, 22));
			driverVersionLabel.setText("Drive Version :");
		}
		return driverVersionLabel;
	}

	/**
	 * hCoo[W擾܂B<br>
	 * @return hCoo[W
	 */
	private ELabel getDriverVersion() {
		if (driverVersion == null) {
			driverVersion = new ELabel();
			driverVersion.setPreferredSize(new Dimension(150, 22));
		}
		return driverVersion;
	}

	/**
	 * ڑ[U[x擾܂B<br>
	 * @return ڑ[U[x
	 */
	private ELabel getConnectionUserLabel() {
		if (connectionUserLabel == null) {
			connectionUserLabel = new ELabel();
			connectionUserLabel.setPreferredSize(new Dimension(150, 22));
			connectionUserLabel.setText("Connection User :");
		}
		return connectionUserLabel;
	}

	/**
	 * ڑ[U[擾܂B<br>
	 * @return ڑ[U[
	 */
	private ELabel getConnectionUser() {
		if (connectionUser == null) {
			connectionUser = new ELabel();
			connectionUser.setPreferredSize(new Dimension(150, 22));
		}
		return connectionUser;
	}

	/**
	 * JDBCAhXx擾܂B<br>
	 * @return JDBCAhXx
	 */
	private ELabel getJdbcUrlLabel() {
		if (jdbcUrlLabel == null) {
			jdbcUrlLabel = new ELabel();
			jdbcUrlLabel.setPreferredSize(new Dimension(150, 22));
			jdbcUrlLabel.setText("JDBC URL :");
		}
		return jdbcUrlLabel;
	}

	/**
	 * JDBCAhX擾܂B<br>
	 * @return JDBCAhX
	 */
	private ELabel getJdbcUrl() {
		if (jdbcUrl == null) {
			jdbcUrl = new ELabel();
			jdbcUrl.setPreferredSize(new Dimension(150, 22));
		}
		return jdbcUrl;
	}
}
