package org.phosphoresce.dbbrowser.gui.window.main;

import java.awt.Component;

import javax.swing.ImageIcon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.phosphoresce.commons.eswing.EMessageDialog;
import org.phosphoresce.commons.eswing.ETabbedPane;
import org.phosphoresce.dbbrowser.DatabaseBrowserSession;
import org.phosphoresce.dbbrowser.gui.RefreshableComponent;
import org.phosphoresce.dbbrowser.gui.panel.dbinformation.DatabaseInformationPanel;
import org.phosphoresce.dbbrowser.gui.panel.pcinformation.ClientPCInformationPanel;
import org.phosphoresce.dbbrowser.gui.panel.querymanage.QueryManagePanel;
import org.phosphoresce.dbbrowser.resource.image.DatabaseBrowserImages;

/**
 * DatabaseBrowserAvP[V^uyCNX<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/27	Kitagawa		VK쐬
 *-->
 */
public final class DatabaseBrowserTabbedPane extends ETabbedPane implements RefreshableComponent {

	/** K[IuWFNg */
	private Log log = LogFactory.getLog(getClass());

	/** VOgZtCX^X */
	private static DatabaseBrowserTabbedPane instance = null;

	/**
	 * RXgN^<br>
	 */
	private DatabaseBrowserTabbedPane() {
		super();
		initialize();
	}

	/**
	 * VOgZtCX^X擾܂B<br>
	 * @return VOgZtCX^X
	 */
	public static DatabaseBrowserTabbedPane instance() {
		if (instance == null) {
			instance = new DatabaseBrowserTabbedPane();
		}
		return instance;
	}

	/**
	 * XV܂B<br>
	 * @throws Throwable ɏ̍XVsȂꍇɔ
	 * @see org.phosphoresce.dbbrowser.gui.RefreshableComponent#refresh()
	 */
	public void refresh() throws Throwable {
		for (int i = 0; i <= getTabCount() - 1; i++) {
			Component component = getComponentAt(i);
			if (component instanceof RefreshableComponent) {
				((RefreshableComponent) component).refresh();
			}
		}
	}

	/**
	 * R|[lgs܂B<br>
	 */
	private void initialize() {
		this.addTab("Client Information", new ImageIcon(DatabaseBrowserImages.IMAGE_ICON_CLIENTPC_20), ClientPCInformationPanel.instance(), "Client PC Information");
		this.addTab("Database Information", new ImageIcon(DatabaseBrowserImages.IMAGE_ICON_DATABASE_20), DatabaseInformationPanel.instance(), "Database Information");
		this.addTab("Query Manager", new ImageIcon(DatabaseBrowserImages.IMAGE_ICON_QUERY_20), QueryManagePanel.instance(), "Query Manager");
		this.addChangeListener(new ChangeListener() {
			public void stateChanged(ChangeEvent e) {
				if (getSelectedComponent() instanceof RefreshableComponent) {
					try {
						((RefreshableComponent) getSelectedComponent()).refresh();
					} catch (Throwable throwable) {
						String errorMessage = "failed to refresh browser panel.";
						log.error(errorMessage, throwable);
						EMessageDialog.showError(DatabaseBrowserSession.instance().getBrowserFrame(), errorMessage, throwable);
					}
				}
			}
		});
		// \plXV
		try {
			ClientPCInformationPanel.instance().refresh();
		} catch (Throwable throwable) {
			String errorMessage = "failed to refresh client pc information panel.";
			log.error(errorMessage, throwable);
			EMessageDialog.showError(DatabaseBrowserSession.instance().getBrowserFrame(), errorMessage, throwable);
		}
	}
}
