package org.phosphoresce.commons.wpoi.adapter;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.phosphoresce.commons.wpoi.exception.PoiIOException;

/**
 * POIZNXB<br>
 * org.apache.poi.hssf.usermodel.HSSFWorkbook̐ƎȃC^tF[XyсA
 * sێA񋟂邱ƂړIƂNXB<br>
 * HSSFWorkbookɑ΂SĂ̐C^tF[X͎ȂׁAg
 * HSSFWorkbookIuWFNg̎擾\bh͓NXɎB<br>
 * 
 * @author last modified by: Kitagawa<br>
 * LastUpdate: 2005/11/21
 * 
 *<!--
 * XV       XV          XVe
 * 2005/11/21	Kitagawa		VK쐬
 * 2006/03/09	Kitagawa		IO֘A̗OPoiIOExceptionɕύX
 *-->
 */
public final class PoiWorkbook {

	/** MOIuWFNg */
	private Log log = LogFactory.getLog(this.getClass());

	/** gHSSFWorkbookIuWFNg */
	private HSSFWorkbook hssfWorkbook;

	/**
	 * RXgN^<br>
	 */
	public PoiWorkbook() {
		this.hssfWorkbook = new HSSFWorkbook();
		log.trace("******** [NubNCX^X𐶐܂[" + "VK쐬" + "]");
	}

	/**
	 * RXgN^<br>
	 * @param hssfWorkbook HSSFWorkbookIuWFNg
	 */
	public PoiWorkbook(HSSFWorkbook hssfWorkbook) {
		this.hssfWorkbook = hssfWorkbook;
		log.trace("******** [NubNCX^X𐶐܂[" + hssfWorkbook + "]");
	}

	/**
	 * RXgN^<br>
	 * w肳ꂽExcelt@CpXNX܂B<br>
	 * @param path Excelt@CpX
	 * @throws PoiIOException Excelt@CI[vłȂꍇɔ
	 */
	public PoiWorkbook(String path) throws PoiIOException {
		try {
			this.hssfWorkbook = new HSSFWorkbook(new POIFSFileSystem(new FileInputStream(new File(path))));

			log.trace("******** [NubNCX^X𐶐܂[" + path + "]");
		} catch (FileNotFoundException e) {
			throw new PoiIOException("w肳ꂽt@C[" + path + "]ȂÃvZXŃbNĂ܂", e);
		} catch (IOException e) {
			throw new PoiIOException("w肳ꂽt@C[" + path + "]J܂ł", e);
		}
	}

	/**
	 * gHSSFWorkbookIuWFNg擾܂B<br>
	 * @return HSSFWorkbookIuWFNg
	 */
	protected HSSFWorkbook getHssfWorkbook() {
		return hssfWorkbook;
	}

	/**
	 * w肳ꂽV[gCfbNXPoiSheetIuWFNg擾܂B<br>
	 * @param index V[gCfbNX
	 * @return w肳ꂽV[gCfbNXPoiSheetIuWFNg
	 */
	public PoiSheet getPoiSheet(int index) {
		return new PoiSheet(this, hssfWorkbook.getSheetAt(index));
	}

	/**
	 * V[g擾܂B<br>
	 * @return SV[g
	 */
	public int getNumberOfSheets() {
		return hssfWorkbook.getNumberOfSheets();
	}

	/**
	 * w肳ꂽCfbNX̃V[gANeBuɂ܂B<br>
	 * @param index V[gCfbNX(0`)
	 */
	public void setSelectedSheet(int index) {
		for (int i = 0; i <= hssfWorkbook.getNumberOfSheets() - 1; i++) {
			hssfWorkbook.getSheetAt(i).setSelected(false);
		}
		hssfWorkbook.getSheetAt(index).setSelected(true);
	}

	/**
	 * w肳ꂽExcelt@CpXɌ݂HSSFWorkbookIuWFNgۑ܂B<br>
	 * @param path ۑExcelt@CpX
	 * @throws PoiIOException Ƀt@C̕ۑoȂꍇɔ
	 */
	public void save(String path) throws PoiIOException {
		try {
			FileOutputStream os = new FileOutputStream(new File(path));
			save(os);
			os.close();
		} catch (FileNotFoundException e) {
			throw new PoiIOException("w肳ꂽt@C[" + path + "]ȂÃvZXŃbNĂ܂", e);
		} catch (IOException e) {
			throw new PoiIOException("w肳ꂽt@C[" + path + "]ۑɓo͗O܂", e);
		}
	}

	/**
	 * w肳ꂽOutputStreamIuWFNgɑ΂Č݂HSSFWorkbookIuWFNgo͂܂B<br>
	 * @param os o͑Ώ OutputStreamIuWFNg
	 * @throws PoiIOException Ƀt@C̏o͂oȂꍇɔ
	 */
	public void save(OutputStream os) throws PoiIOException {
		try {
			hssfWorkbook.write(os);
		} catch (IOException e) {
			throw new PoiIOException("w肳ꂽOutputStreamIuWFNgɑ΂ďo͂邱Ƃo܂ł", e);
		}
	}
}
