package org.phosphoresce.commons.csv;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Iterator;

/**
 * CSV֘ÅǗC^tF[X񋟂NXB<br>
 * NX͎w肳ꂽCSV͂ACSVRecordListIuWFNgƂĒ񋟂C^tF[XA
 * yсACSVRecordListw肳ꂽIuWFNgɑ΂CSVo͂C^tF[X񋟂܂B<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/02/16	Kitagawa		VK쐬
 *-->
 */
public final class CSVManager implements Serializable {

	/** ͑Ώە */
	private String value = null;

	/** NH[gg[N͒tO */
	private boolean inQuote = false;

	/**
	 * RXgN^<br>
	 * @param value ͑Ώە
	 */
	private CSVManager(String value) {
		super();
		this.value = value;
	}

	/**
	 * w肳ꂽCSV`̕CSVR[hXgIuWFNgƂĒ񋟂܂B<br>
	 * @param value ϊΏCSV`
	 * @return CSVR[hXgIuWFNg
	 */
	public static CSVRecordList createRecordList(String value) {
		return new CSVManager(value).execute();
	}

	/**
	 * w肳ꂽFileIuWFNgCSV`̕ǂݍCSVR[hXgIuWFNgƂĒ񋟂܂B<br>
	 * @param file CSVt@CIuWFNg
	 * @return CSVR[hXgIuWFNg
	 * @throws IOException t@CIuWFNg̓ǂݍݒɓo͗OX[ꂽꍇɔ
	 */
	public static CSVRecordList createRecordList(File file) throws IOException {
		FileInputStream is = new FileInputStream(file);
		CSVRecordList list = createRecordList(is);
		is.close();
		return list;
	}

	/**
	 * w肳ꂽInputStreamIuWFNgCSV`̕ǂݍCSVR[hXgIuWFNgƂĒ񋟂܂B<br>
	 * @param is InputStreamIuWFNg
	 * @return CSVR[hXgIuWFNg
	 * @throws IOException InputStreamIuWFNg̓ǂݍݒɓo͗OX[ꂽꍇɔ
	 */
	public static CSVRecordList createRecordList(InputStream is) throws IOException {
		StringBuffer buffer = new StringBuffer();
		BufferedReader reader = new BufferedReader(new InputStreamReader(is));
		while (reader.ready()) {
			buffer.append(reader.readLine());
			buffer.append(CSVToken.NEWLINE);
		}
		return createRecordList(buffer.toString());
	}

	/**
	 * w肳ꂽt@CpXɑ΂CSVRecordListIuWFNg̓eo͂܂B<br>
	 * @param list CSVRecordListIuWFNg
	 * @param path t@CpX
	 * @throws IOException w肳ꂽt@Cɑ΂Ă̏o͎ɓo͗OX[ꂽꍇɔ
	 */
	public static void save(CSVRecordList list, String path) throws IOException {
		save(list, new File(path));
	}

	/**
	 * w肳ꂽFileIuWFNgɑ΂CSVRecordListIuWFNg̓eo͂܂B<br>
	 * @param list CSVRecordListIuWFNg
	 * @param file t@CIuWFNg
	 * @throws IOException w肳ꂽt@Cɑ΂Ă̏o͎ɓo͗OX[ꂽꍇɔ
	 */
	public static void save(CSVRecordList list, File file) throws IOException {
		FileOutputStream os = new FileOutputStream(file);
		save(list, os);
		os.close();
	}

	/**
	 * w肳ꂽOutputStreamIuWFNgɑ΂CSVRecordListIuWFNg̓eo͂܂B<br>
	 * @param list CSVRecordListIuWFNg
	 * @param os OutputStreamIuWFNg
	 */
	public static void save(CSVRecordList list, OutputStream os) {
		PrintWriter writer = new PrintWriter(new OutputStreamWriter(os));
		for (Iterator iterator = list.iterator(); iterator.hasNext();) {
			CSVRecord tokens = (CSVRecord) iterator.next();
			writer.println(tokens.getRecordValue());
			writer.flush();
		}
		writer.flush();
	}

	/**
	 * NXێĂCSV`͂CSVR[hXg񋟂܂B<br>
	 * @return CSVR[hXg
	 */
	private CSVRecordList execute() {

		CSVRecordList recordList = new CSVRecordList();
		CSVRecord tokenList = new CSVRecord();

		StringBuffer token = new StringBuffer();

		for (int i = 0; i <= value.length() - 1; i++) {
			String s1 = String.valueOf(value.charAt(i));
			String s2 = i < value.length() - 1 ? String.valueOf(value.charAt(i + 1)) : "";

			if (!inQuote) {
				/*
				 * NH[gg[N͒ł͂Ȃꍇ
				 */
				if (CSVToken.SEPARATOR.equals(s1)) {
					// ͕J}łꍇ̓g[N͂I
					tokenList.add(new CSVToken(CSVToken.decode(token.toString())));
					token = new StringBuffer();
				} else if (CSVToken.NEWLINE.equals(s1)) {
					// ͕słꍇ̓R[h͂I
					tokenList.add(new CSVToken(CSVToken.decode(token.toString())));
					recordList.add(tokenList);
					token = new StringBuffer();
					tokenList = new CSVRecord();
				} else if (CSVToken.QUOTE.equals(s1)) {
					// ͕NH[głꍇ̓NH[g̓tO𗧂Ă
					token.append(s1);
					inQuote = true;
				} else {
					// ʏ핶̏ꍇ̓obt@ɕǉ
					token.append(s1);
				}
			} else {
				/*
				 * NH[gg[N͒ł̏ꍇ
				 */
				if (CSVToken.SEPARATOR.equals(s1)) {
					// ͕J}ƂĂƂĒǉ
					token.append(s1);
				} else if (CSVToken.NEWLINE.equals(s1)) {
					// ͕sƂĂƂĒǉ
					token.append(s1);
				} else if (CSVToken.QUOTE.equals(s1) && CSVToken.QUOTE.equals(s2)) {
					// ͕ɂăNH[gAő݂ꍇ͕ǉēYCNg
					token.append(s1);
					token.append(s2);
					i++;
				} else if (CSVToken.QUOTE.equals(s1) && !CSVToken.QUOTE.equals(s2)) {
					// ͕ɂăNH[gPƂő݂ꍇ͕ǉăNH[g̓tO
					token.append(s1);
					inQuote = false;
				} else {
					// ʏ핶̏ꍇ̓obt@ɕǉ
					token.append(s1);
				}
			}
		}

		return recordList;
	}
}
