package org.phosphoresce.commons.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * t@C֌W[eBeBNXB<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2005/05/24	Kitagawa		VK쐬
 * 2007/07/14	Kitagawa		copy(File, File)\bhǉ
 * 2007/10/17	Kitagawa		replacaInvalidateChar(String)\bhǉ
 *-->
 */
public final class FileUtil {

	/**
	 * RXgN^<br>
	 */
	private FileUtil() {
		//
	}

	/**
	 * w肳ꂽt@CIuWFNg폜܂B<br>
	 * t@CIuWFNgێz̃\[Xɑ΂ĂċAIɍ폜܂B<br>
	 * @param file 폜Ώۃt@CIuWFNg
	 */
	public static void delete(File file) {
		if (file != null) {
			if (file.isDirectory()) {
				if (file.listFiles().length > 0) {
					for (int i = 0; file != null && i <= file.listFiles().length - 1; i++) {
						delete(file.listFiles()[i--]);
					}
					file.delete();
				} else {
					file.delete();
				}
			} else {
				file.delete();
			}
		}
	}

	/**
	 * w肳ꂽt@Cw肳ꂽt@CɃRs[܂B<br>
	 * @param source Rs[t@CIuWFNg
	 * @param destination Rs[t@CIuWFNg
	 * @throws IOException Rs[ɓo͗OꍇɃX[܂
	 */
	public static void copy(File source, File destination) throws IOException {
		FileChannel src = new FileInputStream(source).getChannel();
		FileChannel dst = new FileOutputStream(destination).getChannel();
		dst.transferFrom(src, 0, src.size());
	}

	public static File getDirectory(File file) {
		if (file.isDirectory()) {
			return new File(file.getAbsolutePath());
		} else {
			String path = file.getAbsolutePath();
			path = path.substring(0, path.lastIndexOf(File.separator));
			return new File(path);
		}
	}

	/**
	 * w肳ꂽt@C[x]tăt@C̃CNgs܂B<br>
	 * w肳ꂽt@C݂Ȃꍇ͂̂܂ܕԋp܂B<br>
	 * @param filename t@C
	 * @return CNgt@C
	 */
	public static String getAutoIncrementFilename(String filename) {
		File file = new File(filename);
		String incrementedFilename = filename;

		if (file.exists()) {
			if (file.isDirectory()) {
				int counter = 1;
				for (File check = new File(filename + " [" + counter + "]"); check.exists(); counter++)
					;
				incrementedFilename = filename + " [" + counter + "]";
			} else {
				String basename = filename;
				String extension = "";

				if (filename.lastIndexOf('.') > 0) {
					basename = filename.substring(0, filename.lastIndexOf('.'));
					extension = filename.substring(filename.lastIndexOf('.'));
				}

				int counter = 1;
				for (File check = new File(filename + " [" + counter + "]" + extension); check.exists(); counter++)
					;
				incrementedFilename = filename + " [" + counter + "]" + extension;
			}
		}

		return incrementedFilename;
	}

	/**
	 * w肳ꂽt@C݂ꍇAt|XgtBNXƂĕtޔ܂B<br>
	 * @param filename ޔΏۃt@C
	 */
	public static void renameWithDatePostfix(String filename) {
		File file = new File(filename);

		if (file.exists()) {
			if (file.isDirectory()) {
				int counter = 1;
				String rename = filename + new SimpleDateFormat(".yyyyMMdd.hhmmss").format(new Date());
				for (File check = new File(rename); check.exists(); counter++) {
					rename = rename + " [" + counter + "]";
					check = new File(rename);
				}

				file.renameTo(new File(rename));
			} else {
				String basename = filename;
				String extension = "";

				if (filename.lastIndexOf('.') > 0) {
					basename = filename.substring(0, filename.lastIndexOf('.'));
					extension = filename.substring(filename.lastIndexOf('.'));
				}

				int counter = 1;
				String head = basename + new SimpleDateFormat(".yyyyMMdd.hhmmss").format(new Date());
				String rename = head;
				for (File check = new File(rename + extension); check.exists(); counter++) {
					rename = head + " [" + counter + "]";
					check = new File(rename + extension);
				}

				file.renameTo(new File(rename + extension));
			}
		}
	}

	/**
	 * w肳ꂽt@Csȕĕԋp܂B<br>
	 * @param filename ␳Ώۃt@C
	 * @return ␳t@C
	 */
	public static String replacaInvalidateChar(String filename) {
		String buffer = filename;
		buffer = buffer.replaceAll("[\"]", "");
		//buffer = buffer.replaceAll("[=]", "");
		buffer = buffer.replaceAll("[|]", "");
		buffer = buffer.replaceAll("[\\]", "");
		//buffer = buffer.replaceAll("[;]", "");
		buffer = buffer.replaceAll("[:]", "");
		//buffer = buffer.replaceAll("[+]", "");
		buffer = buffer.replaceAll("[*]", "");
		buffer = buffer.replaceAll("[<]", "");
		buffer = buffer.replaceAll("[>]", "");
		//buffer = buffer.replaceAll("[.]", "");
		//buffer = buffer.replaceAll("[,]", "");
		buffer = buffer.replaceAll("[/]", "");
		buffer = buffer.replaceAll("[?]", "");
		return buffer;
	}
}
