package org.phosphoresce.commons.database;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;

import org.phosphoresce.commons.database.core.DatabaseSession;
import org.phosphoresce.commons.database.exception.DatabaseSessionException;
import org.phosphoresce.commons.database.exception.IllegalResultSetAdjustmentException;
import org.phosphoresce.commons.database.exception.IllegalResultSetLocationIndexException;
import org.phosphoresce.commons.database.exception.ResultSetAccessException;
import org.phosphoresce.commons.database.util.ResultSetUtil;

/**
 * f[^x[XێIuWFNg<br>
 * IuWFNgDatabaseMetaData񋟂̂f[^x[XɊւ݂̂񋟂܂B<br>
 * {IɂDatabaseMetaData񋟂C^tF[XɏϏ܂B<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/08/31	Kitagawa		VK쐬
 *-->
 */
public class DatabaseInformation {

	/** f[^x[XZbVIuWFNg */
	private DatabaseSession session;

	/**
	 * RXgN^<br>
	 * @param session f[^x[XZbVIuWFNg
	 */
	public DatabaseInformation(DatabaseSession session) {
		super();
		this.session = session;
	}

	/**
	 * RXgN^<br>
	 */
	private DatabaseInformation() {
		this(null);
	}

	/**
	 * f[^x[X^f[^擾܂B<br>
	 * @return f[^x[X^f[^
	 * @throws DatabaseSessionException f[^x[XڑOꍇɃX[܂
	 * @throws ResultSetAccessException ResultSetIuWFNgɑ΂ĐɃANZXłȂꍇɔ
	 */
	private DatabaseMetaData getDatabaseMetaData() throws DatabaseSessionException, ResultSetAccessException {
		try {
			return session.getConnection().getMetaData();
		} catch (SQLException e) {
			throw new ResultSetAccessException("failed to get database meta data.", e);
		}
	}

	/**
	 * ̃f[^x[Xi擾܂B<br>
	 * @return ̃f[^x[Xi
	 * @throws DatabaseSessionException f[^x[XڑOꍇɃX[܂
	 * @throws ResultSetAccessException ResultSetIuWFNgɑ΂ĐɃANZXłȂꍇɔ
	 */
	public String getProductName() throws DatabaseSessionException, ResultSetAccessException {
		try {
			return session.getConnection().getMetaData().getDatabaseProductName();
		} catch (AbstractMethodError e) {
			return "";
		} catch (SQLException e) {
			throw new ResultSetAccessException("failed to get product name.", e);
		}
	}

	/**
	 * ̃f[^x[Xĩo[W擾܂B<br>
	 * @return f[^x[Xĩo[W
	 * @throws DatabaseSessionException f[^x[XڑOꍇɃX[܂
	 * @throws ResultSetAccessException ResultSetIuWFNgɑ΂ĐɃANZXłȂꍇɔ
	 */
	public String getProductVersion() throws DatabaseSessionException, ResultSetAccessException {
		try {
			return session.getConnection().getMetaData().getDatabaseProductVersion();
		} catch (AbstractMethodError e) {
			return "";
		} catch (SQLException e) {
			throw new ResultSetAccessException("failed to get product version.", e);
		}
	}

	/**
	 * JDBChCo擾܂B<br>
	 * @return JDBChCo
	 * @throws DatabaseSessionException f[^x[XڑOꍇɃX[܂
	 * @throws ResultSetAccessException ResultSetIuWFNgɑ΂ĐɃANZXłȂꍇɔ
	 */
	public String getDriverName() throws DatabaseSessionException, ResultSetAccessException {
		try {
			return session.getConnection().getMetaData().getDriverName();
		} catch (AbstractMethodError e) {
			return "";
		} catch (SQLException e) {
			throw new ResultSetAccessException("failed to get driver name.", e);
		}
	}

	/**
	 * JDBChCoo[W𕶎ƂĎ擾܂B<br>
	 * @return JDBChCoo[W
	 * @throws DatabaseSessionException f[^x[XڑOꍇɃX[܂
	 * @throws ResultSetAccessException ResultSetIuWFNgɑ΂ĐɃANZXłȂꍇɔ
	 */
	public String getDriverVersion() throws DatabaseSessionException, ResultSetAccessException {
		try {
			return session.getConnection().getMetaData().getDriverVersion();
		} catch (AbstractMethodError e) {
			return "";
		} catch (SQLException e) {
			throw new ResultSetAccessException("failed to get driver version.", e);
		}
	}

	/**
	 * f[^x[X񋟂ڑ[U[擾܂B<br>
	 * @return f[^x[X񋟂ڑ[U[
	 * @throws DatabaseSessionException f[^x[XڑOꍇɃX[܂
	 * @throws ResultSetAccessException ResultSetIuWFNgɑ΂ĐɃANZXłȂꍇɔ
	 */
	public String getUserName() throws DatabaseSessionException, ResultSetAccessException {
		try {
			return session.getConnection().getMetaData().getUserName();
		} catch (AbstractMethodError e) {
			return "";
		} catch (SQLException e) {
			throw new ResultSetAccessException("failed to get user name.", e);
		}
	}

	/**
	 * f[^x[X񋟂ڑURL擾܂B<br>
	 * @return f[^x[X񋟂ڑURL
	 * @throws DatabaseSessionException f[^x[XڑOꍇɃX[܂
	 * @throws ResultSetAccessException ResultSetIuWFNgɑ΂ĐɃANZXłȂꍇɔ
	 */
	public String getURL() throws DatabaseSessionException, ResultSetAccessException {
		try {
			return session.getConnection().getMetaData().getURL();
		} catch (AbstractMethodError e) {
			return "";
		} catch (SQLException e) {
			throw new ResultSetAccessException("failed to get url.", e);
		}
	}

	/**
	 * Catalogɑ΂f[^x[Xx_[̐p擾܂B<br>
	 * @return Catalogɑ΂f[^x[Xx_[̐p
	 * @throws DatabaseSessionException f[^x[XڑOꍇɃX[܂
	 * @throws ResultSetAccessException ResultSetIuWFNgɑ΂ĐɃANZXłȂꍇɔ
	 */
	public String getCatalogTerm() throws DatabaseSessionException, ResultSetAccessException {
		try {
			return session.getConnection().getMetaData().getCatalogTerm();
		} catch (AbstractMethodError e) {
			return "";
		} catch (SQLException e) {
			throw new ResultSetAccessException("failed to get catalog term.", e);
		}
	}

	/**
	 * Procedureɑ΂f[^x[Xx_[̐p擾܂B<br>
	 * @return Procedureɑ΂f[^x[Xx_[̐p
	 * @throws DatabaseSessionException f[^x[XڑOꍇɃX[܂
	 * @throws ResultSetAccessException ResultSetIuWFNgɑ΂ĐɃANZXłȂꍇɔ
	 */
	public String getProcedureTerm() throws DatabaseSessionException, ResultSetAccessException {
		try {
			return session.getConnection().getMetaData().getProcedureTerm();
		} catch (AbstractMethodError e) {
			return "";
		} catch (SQLException e) {
			throw new ResultSetAccessException("faied to get procedure term.", e);
		}
	}

	/**
	 * Schemaɑ΂f[^x[Xx_[̐p擾܂B<br>
	 * @return Schemaɑ΂f[^x[Xx_[̐p
	 * @throws DatabaseSessionException f[^x[XڑOꍇɃX[܂
	 * @throws ResultSetAccessException ResultSetIuWFNgɑ΂ĐɃANZXłȂꍇɔ
	 */
	public String getSchemaTerm() throws DatabaseSessionException, ResultSetAccessException {
		try {
			return session.getConnection().getMetaData().getSchemaTerm();
		} catch (AbstractMethodError e) {
			return "";
		} catch (SQLException e) {
			throw new ResultSetAccessException("failed to get schema term.", e);
		}
	}

	/**
	 * ̃f[^x[XJ^Oƃe[ũZp[^ƂĎgp镶擾܂B<br>
	 * @return f[^x[XJ^Oƃe[ũZp[^ƂĎgp镶
	 * @throws DatabaseSessionException f[^x[XڑOꍇɃX[܂
	 * @throws ResultSetAccessException ResultSetIuWFNgɑ΂ĐɃANZXłȂꍇɔ
	 */
	public String getCatalogSeparator() throws DatabaseSessionException, ResultSetAccessException {
		try {
			return session.getConnection().getMetaData().getCatalogSeparator();
		} catch (AbstractMethodError e) {
			return "";
		} catch (SQLException e) {
			throw new ResultSetAccessException("failed to get catalog separator.", e);
		}
	}

	/**
	 * J^OXg擾܂B<br>
	 * @return J^OXg
	 * @throws DatabaseSessionException f[^x[XڑOꍇɃX[܂
	 * @throws ResultSetAccessException ResultSetIuWFNgɑ΂ĐɃANZXłȂꍇɔ
	 * @throws IllegalResultSetLocationIndexException ResultSetIuWFNg쎞ɕsȈʒuւ̃ANZXsꂽꍇɔ
	 * @throws IllegalResultSetAdjustmentException ResultSetIuWFNgɑ΂ĊOsȕύXꍇɔ
	 */
	public List getCatalogNameList() throws DatabaseSessionException, ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException {
		try {
			List list = new LinkedList();
			ResultSet resultSet = getDatabaseMetaData().getCatalogs();
			while (resultSet.next()) {
				list.add(resultSet.getObject("TABLE_CAT"));
			}
			return list;
		} catch (AbstractMethodError e) {
			return new LinkedList();
		} catch (SQLException e) {
			throw new ResultSetAccessException("failed to get catalog list.", e);
		}
	}

	/**
	 * XL[}Xg擾܂B<br>
	 * @return XL[}Xg
	 * @throws DatabaseSessionException f[^x[XڑOꍇɃX[܂
	 * @throws ResultSetAccessException ResultSetIuWFNgɑ΂ĐɃANZXłȂꍇɔ
	 * @throws IllegalResultSetLocationIndexException ResultSetIuWFNg쎞ɕsȈʒuւ̃ANZXsꂽꍇɔ
	 * @throws IllegalResultSetAdjustmentException ResultSetIuWFNgɑ΂ĊOsȕύXꍇɔ
	 */
	public List getSchemaNameList() throws DatabaseSessionException, ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException {
		try {
			List list = new LinkedList();
			ResultSet resultSet = getDatabaseMetaData().getSchemas();
			while (resultSet.next()) {
				list.add(resultSet.getObject("TABLE_SCHEM"));
			}
			return list;
		} catch (AbstractMethodError e) {
			return new LinkedList();
		} catch (SQLException e) {
			throw new ResultSetAccessException("failed to get schema list.", e);
		}
	}

	/**
	 * XL[}Xg擾܂B<br>
	 * @param catalog J^O
	 * @return XL[}Xg
	 * @throws DatabaseSessionException f[^x[XڑOꍇɃX[܂
	 * @throws ResultSetAccessException ResultSetIuWFNgɑ΂ĐɃANZXłȂꍇɔ
	 * @throws IllegalResultSetLocationIndexException ResultSetIuWFNg쎞ɕsȈʒuւ̃ANZXsꂽꍇɔ
	 * @throws IllegalResultSetAdjustmentException ResultSetIuWFNgɑ΂ĊOsȕύXꍇɔ
	 */
	public List getSchemaNameList(String catalog) throws DatabaseSessionException, ResultSetAccessException, IllegalResultSetLocationIndexException,
			IllegalResultSetAdjustmentException {
		try {
			List list = new LinkedList();
			ResultSet resultSet = getDatabaseMetaData().getSchemas();
			while (resultSet.next()) {
				if (ResultSetUtil.containsColumn(resultSet, "TABLE_CATALOG")) {
					String tableCat = resultSet.getObject("TABLE_CATALOG") == null ? "" : resultSet.getObject("TABLE_CATALOG").toString();
					if (catalog == null || catalog.equals(tableCat)) {
						list.add(resultSet.getObject("TABLE_SCHEM"));
					}
				} else {
					list.add(resultSet.getObject("TABLE_SCHEM"));
				}
			}
			return list;
		} catch (AbstractMethodError e) {
			return new LinkedList();
		} catch (SQLException e) {
			throw new ResultSetAccessException("failed to get schema list of '" + catalog + "'.", e);
		}
	}

	/**
	 * e[u^CvXg擾܂B<br>
	 * @return e[u^CvXg
	 * @throws DatabaseSessionException f[^x[XڑOꍇɃX[܂
	 * @throws ResultSetAccessException ResultSetIuWFNgɑ΂ĐɃANZXłȂꍇɔ
	 * @throws IllegalResultSetLocationIndexException ResultSetIuWFNg쎞ɕsȈʒuւ̃ANZXsꂽꍇɔ
	 * @throws IllegalResultSetAdjustmentException ResultSetIuWFNgɑ΂ĊOsȕύXꍇɔ
	 */
	public List getTableTypeNameList() throws DatabaseSessionException, ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException {
		try {
			List list = new LinkedList();
			ResultSet resultSet = getDatabaseMetaData().getTableTypes();
			while (resultSet.next()) {
				list.add(resultSet.getObject("TABLE_TYPE"));
			}
			return list;
		} catch (AbstractMethodError e) {
			return new LinkedList();
		} catch (SQLException e) {
			throw new ResultSetAccessException("failed to get table type list.", e);
		}
	}

	/**
	 * e[u񖼃Xg擾܂B<br>
	 * @return e[u񖼃Xg
	 * @throws DatabaseSessionException f[^x[XڑOꍇɃX[܂
	 * @throws ResultSetAccessException ResultSetIuWFNgɑ΂ĐɃANZXłȂꍇɔ
	 * @throws IllegalResultSetLocationIndexException ResultSetIuWFNg쎞ɕsȈʒuւ̃ANZXsꂽꍇɔ
	 * @throws IllegalResultSetAdjustmentException ResultSetIuWFNgɑ΂ĊOsȕύXꍇɔ
	 */
	public List getTypeInfoNameList() throws DatabaseSessionException, ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException {
		try {
			List list = new LinkedList();
			ResultSet resultSet = getDatabaseMetaData().getTypeInfo();
			while (resultSet.next()) {
				list.add(resultSet.getObject("TYPE_NAME"));
			}
			return list;
		} catch (AbstractMethodError e) {
			return new LinkedList();
		} catch (SQLException e) {
			throw new ResultSetAccessException("failed to get type name list.", e);
		}
	}

	/**
	 * w肳ꂽJ^OAXL[}̃e[uXg擾܂B<br>
	 * @param catalog J^O(null)
	 * @param schema XL[}(null)
	 * @return e[uXg
	 * @throws DatabaseSessionException f[^x[XڑOꍇɃX[܂
	 * @throws ResultSetAccessException ResultSetIuWFNgɑ΂ĐɃANZXłȂꍇɔ
	 * @throws IllegalResultSetLocationIndexException ResultSetIuWFNg쎞ɕsȈʒuւ̃ANZXsꂽꍇɔ
	 * @throws IllegalResultSetAdjustmentException ResultSetIuWFNgɑ΂ĊOsȕύXꍇɔ
	 */
	public List getTableList(String catalog, String schema) throws DatabaseSessionException, ResultSetAccessException, IllegalResultSetLocationIndexException,
			IllegalResultSetAdjustmentException {
		try {
			List list = new LinkedList();
			ResultSet resultSet = getDatabaseMetaData().getTables(catalog == null ? "%" : catalog, schema == null ? "%" : schema, "%", new String[] { "TABLE" });
			while (resultSet.next()) {
				list.add(resultSet.getObject("TABLE_NAME"));
			}
			return list;
		} catch (AbstractMethodError e) {
			return new LinkedList();
		} catch (SQLException e) {
			throw new ResultSetAccessException("failed to get table list.", e);
		}
	}
}
