package org.phosphoresce.commons.database;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;

import org.phosphoresce.commons.database.core.DatabaseSession;
import org.phosphoresce.commons.database.exception.DatabaseSessionException;
import org.phosphoresce.commons.database.exception.ResultSetAccessException;

/**
 * f[^x[XdlێIuWFNg<br>
 * IuWFNgDatabaseMetaData񋟂̂f[^x[XdlɊւ݂̂񋟂܂B<br>
 * {IɂDatabaseMetaData񋟂C^tF[XɏϏ܂B<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/08/31	Kitagawa		VK쐬
 *-->
 */
public class DatabaseSpecification {

	/** f[^x[XZbVIuWFNg */
	private DatabaseSession session;

	/**
	 * RXgN^<br>
	 * @param session f[^x[XZbVIuWFNg
	 */
	public DatabaseSpecification(DatabaseSession session) {
		super();
		this.session = session;
	}

	/**
	 * RXgN^<br>
	 */
	private DatabaseSpecification() {
		this(null);
	}

	/**
	 * f[^x[X^f[^擾܂B<br>
	 * @return f[^x[X^f[^
	 * @throws DatabaseSessionException f[^x[XڑOꍇɃX[܂
	 * @throws ResultSetAccessException ResultSetIuWFNgɑ΂ĐɃANZXłȂꍇɔ
	 */
	private DatabaseMetaData getDatabaseMetaData() throws DatabaseSessionException, ResultSetAccessException {
		try {
			return session.getConnection().getMetaData();
		} catch (SQLException e) {
			throw new ResultSetAccessException("failed to get database meta data.", e);
		}
	}

	/**
	 * ̃f[^x[X̃ftHg̃gUNVՒfx擾܂B<br>
	 * 蓾ljava.sql.ConnectionŒ`Ă܂B
	 * @return ̃f[^x[X̃ftHg̃gUNVՒfx
	 * @throws DatabaseSessionException f[^x[XڑOꍇɃX[܂
	 * @throws ResultSetAccessException ResultSetIuWFNgɑ΂ĐɃANZXłȂꍇɔ
	 */
	public int getDefaultTransactionIsolation() throws DatabaseSessionException, ResultSetAccessException {
		try {
			return session.getConnection().getMetaData().getDefaultTransactionIsolation();
		} catch (AbstractMethodError e) {
			return -1;
		} catch (SQLException e) {
			throw new ResultSetAccessException("failed to get default transaction isolation.", e);
		}
	}

	/**
	 * ̃f[^x[X̃ftHg̃gUNVՒfx𕶎\Ŏ擾܂B<br>
	 * @return ̃f[^x[X̃ftHg̃gUNVՒfx
	 * @throws DatabaseSessionException f[^x[XڑOꍇɃX[܂
	 * @throws ResultSetAccessException ResultSetIuWFNgɑ΂ĐɃANZXłȂꍇɔ
	 */
	public String getDefaultTransactionIsolationName() throws DatabaseSessionException, ResultSetAccessException {
		int type = getDefaultTransactionIsolation();
		if (type == Connection.TRANSACTION_NONE) {
			return "Connection.TRANSACTION_NONE";
		} else if (type == Connection.TRANSACTION_READ_COMMITTED) {
			return "Connection.TRANSACTION_READ_COMMITTED";
		} else if (type == Connection.TRANSACTION_READ_UNCOMMITTED) {
			return "Connection.TRANSACTION_READ_UNCOMMITTED";
		} else if (type == Connection.TRANSACTION_REPEATABLE_READ) {
			return "Connection.TRANSACTION_REPEATABLE_READ";
		} else if (type == Connection.TRANSACTION_SERIALIZABLE) {
			return "Connection.TRANSACTION_SERIALIZABLE";
		} else {
			return "Unkown";
		}
	}

	/**
	 * ̃f[^x[XŁACCoCieɓ16i̍ő啶擾܂B<br>
	 * @return ̃f[^x[XŁACCoCieɓ16i̍ő啶
	 * @throws DatabaseSessionException f[^x[XڑOꍇɃX[܂
	 * @throws ResultSetAccessException ResultSetIuWFNgɑ΂ĐɃANZXłȂꍇɔ
	 */
	public int getMaxBinaryLiteralLength() throws DatabaseSessionException, ResultSetAccessException {
		try {
			return session.getConnection().getMetaData().getMaxBinaryLiteralLength();
		} catch (AbstractMethodError e) {
			return -1;
		} catch (SQLException e) {
			throw new ResultSetAccessException("failed to get database specification.", e);
		}
	}

	/**
	 * ̃f[^x[Xł́AJ^O̍ő啶擾܂B<br>
	 * @return ̃f[^x[Xł́AJ^O̍ő啶
	 * @throws DatabaseSessionException f[^x[XڑOꍇɃX[܂
	 * @throws ResultSetAccessException ResultSetIuWFNgɑ΂ĐɃANZXłȂꍇɔ
	 */
	public int getMaxCatalogNameLength() throws DatabaseSessionException, ResultSetAccessException {
		try {
			return session.getConnection().getMetaData().getMaxCatalogNameLength();
		} catch (AbstractMethodError e) {
			return -1;
		} catch (SQLException e) {
			throw new ResultSetAccessException("failed to get database specification.", e);
		}
	}

	/**
	 * ̃f[^x[Xł́ALN^e̍ő啶擾܂B<br>
	 * @return ̃f[^x[Xł́ALN^e̍ő啶
	 * @throws DatabaseSessionException f[^x[XڑOꍇɃX[܂
	 * @throws ResultSetAccessException ResultSetIuWFNgɑ΂ĐɃANZXłȂꍇɔ
	 */
	public int getMaxCharLiteralLength() throws DatabaseSessionException, ResultSetAccessException {
		try {
			return session.getConnection().getMetaData().getMaxCharLiteralLength();
		} catch (AbstractMethodError e) {
			return -1;
		} catch (SQLException e) {
			throw new ResultSetAccessException("failed to get database specification.", e);
		}
	}

	/**
	 * ̃f[^x[Xł́A񖼂̍ő啶擾܂B<br>
	 * @return ̃f[^x[Xł́A񖼂̍ő啶
	 * @throws DatabaseSessionException f[^x[XڑOꍇɃX[܂
	 * @throws ResultSetAccessException ResultSetIuWFNgɑ΂ĐɃANZXłȂꍇɔ
	 */
	public int getMaxColumnNameLength() throws DatabaseSessionException, ResultSetAccessException {
		try {
			return session.getConnection().getMetaData().getMaxColumnNameLength();
		} catch (AbstractMethodError e) {
			return -1;
		} catch (SQLException e) {
			throw new ResultSetAccessException("failed to get database specification.", e);
		}
	}

	/**
	 * ̃f[^x[Xł́AGROUP BY ߒ̗񐔂̍ől擾܂B<br>
	 * @return ̃f[^x[Xł́AGROUP BY ߒ̗񐔂̍ől
	 * @throws DatabaseSessionException f[^x[XڑOꍇɃX[܂
	 * @throws ResultSetAccessException ResultSetIuWFNgɑ΂ĐɃANZXłȂꍇɔ
	 */
	public int getMaxColumnsInGroupBy() throws DatabaseSessionException, ResultSetAccessException {
		try {
			return session.getConnection().getMetaData().getMaxColumnsInGroupBy();
		} catch (AbstractMethodError e) {
			return -1;
		} catch (SQLException e) {
			throw new ResultSetAccessException("failed to get database specification.", e);
		}
	}

	/**
	 * ̃f[^x[Xł́ACfbNX̗񐔂̍ől擾܂B<br>
	 * @return ̃f[^x[Xł́ACfbNX̗񐔂̍ől
	 * @throws DatabaseSessionException f[^x[XڑOꍇɃX[܂
	 * @throws ResultSetAccessException ResultSetIuWFNgɑ΂ĐɃANZXłȂꍇɔ
	 */
	public int getMaxColumnsInIndex() throws DatabaseSessionException, ResultSetAccessException {
		try {
			return session.getConnection().getMetaData().getMaxColumnsInIndex();
		} catch (AbstractMethodError e) {
			return -1;
		} catch (SQLException e) {
			throw new ResultSetAccessException("failed to get database specification.", e);
		}
	}

	/**
	 * ̃f[^x[Xł́AORDER BY ߒ̗񐔂̍ől擾܂B<br>
	 * @return ̃f[^x[Xł́AORDER BY ߒ̗񐔂̍ől
	 * @throws DatabaseSessionException f[^x[XڑOꍇɃX[܂
	 * @throws ResultSetAccessException ResultSetIuWFNgɑ΂ĐɃANZXłȂꍇɔ
	 */
	public int getMaxColumnsInOrderBy() throws DatabaseSessionException, ResultSetAccessException {
		try {
			return session.getConnection().getMetaData().getMaxColumnsInOrderBy();
		} catch (AbstractMethodError e) {
			return -1;
		} catch (SQLException e) {
			throw new ResultSetAccessException("failed to get database specification.", e);
		}
	}

	/**
	 * ̃f[^x[Xł́ASELECT Xg̗񐔂̍ől擾܂B<br>
	 * @return ̃f[^x[Xł́ASELECT Xg̗񐔂̍ől
	 * @throws DatabaseSessionException f[^x[XڑOꍇɃX[܂
	 * @throws ResultSetAccessException ResultSetIuWFNgɑ΂ĐɃANZXłȂꍇɔ
	 */
	public int getMaxColumnsInSelect() throws DatabaseSessionException, ResultSetAccessException {
		try {
			return session.getConnection().getMetaData().getMaxColumnsInSelect();
		} catch (AbstractMethodError e) {
			return -1;
		} catch (SQLException e) {
			throw new ResultSetAccessException("failed to get database specification.", e);
		}
	}

	/**
	 * ̃f[^x[Xł́Ae[u̗񐔂̍ől擾܂B<br>
	 * @return ̃f[^x[Xł́Ae[u̗񐔂̍ől
	 * @throws DatabaseSessionException f[^x[XڑOꍇɃX[܂
	 * @throws ResultSetAccessException ResultSetIuWFNgɑ΂ĐɃANZXłȂꍇɔ
	 */
	public int getMaxColumnsInTable() throws DatabaseSessionException, ResultSetAccessException {
		try {
			return session.getConnection().getMetaData().getMaxColumnsInTable();
		} catch (AbstractMethodError e) {
			return -1;
		} catch (SQLException e) {
			throw new ResultSetAccessException("failed to get database specification.", e);
		}
	}

	/**
	 * ̃f[^x[Xւ̉\Ȍ݂̐ڑ̍ő吔擾܂B<br>
	 * @return ̃f[^x[Xւ̉\Ȍ݂̐ڑ̍ő吔
	 * @throws DatabaseSessionException f[^x[XڑOꍇɃX[܂
	 * @throws ResultSetAccessException ResultSetIuWFNgɑ΂ĐɃANZXłȂꍇɔ
	 */
	public int getMaxConnections() throws DatabaseSessionException, ResultSetAccessException {
		try {
			return session.getConnection().getMetaData().getMaxConnections();
		} catch (AbstractMethodError e) {
			return -1;
		} catch (SQLException e) {
			throw new ResultSetAccessException("failed to get database specification.", e);
		}
	}

	/**
	 * ̃f[^x[Xł́AJ[\̍ő啶擾܂B<br>
	 * @return ̃f[^x[Xł́AJ[\̍ő啶
	 * @throws DatabaseSessionException f[^x[XڑOꍇɃX[܂
	 * @throws ResultSetAccessException ResultSetIuWFNgɑ΂ĐɃANZXłȂꍇɔ
	 */
	public int getMaxCursorNameLength() throws DatabaseSessionException, ResultSetAccessException {
		try {
			return session.getConnection().getMetaData().getMaxCursorNameLength();
		} catch (AbstractMethodError e) {
			return -1;
		} catch (SQLException e) {
			throw new ResultSetAccessException("failed to get database specification.", e);
		}
	}

	/**
	 * ̃f[^x[Xł́ACfbNX̑S܂ށACfbNX̍őoCg擾܂B<br>
	 * @return ̃f[^x[Xł́ACfbNX̑S܂ށACfbNX̍őoCg
	 * @throws DatabaseSessionException f[^x[XڑOꍇɃX[܂
	 * @throws ResultSetAccessException ResultSetIuWFNgɑ΂ĐɃANZXłȂꍇɔ
	 */
	public int getMaxIndexLength() throws DatabaseSessionException, ResultSetAccessException {
		try {
			return session.getConnection().getMetaData().getMaxIndexLength();
		} catch (AbstractMethodError e) {
			return -1;
		} catch (SQLException e) {
			throw new ResultSetAccessException("failed to get database specification.", e);
		}
	}

	/**
	 * ̃f[^x[Xł́AvV[W̍ő啶擾܂B<br>
	 * @return ̃f[^x[Xł́AvV[W̍ő啶
	 * @throws DatabaseSessionException f[^x[XڑOꍇɃX[܂
	 * @throws ResultSetAccessException ResultSetIuWFNgɑ΂ĐɃANZXłȂꍇɔ
	 */
	public int getMaxProcedureNameLength() throws DatabaseSessionException, ResultSetAccessException {
		try {
			return session.getConnection().getMetaData().getMaxProcedureNameLength();
		} catch (AbstractMethodError e) {
			return -1;
		} catch (SQLException e) {
			throw new ResultSetAccessException("failed to get database specification.", e);
		}
	}

	/**
	 * ̃f[^x[Xł́A1s̍őoCg擾܂B<br>
	 * @return ̃f[^x[Xł́A1s̍őoCg
	 * @throws DatabaseSessionException f[^x[XڑOꍇɃX[܂
	 * @throws ResultSetAccessException ResultSetIuWFNgɑ΂ĐɃANZXłȂꍇɔ
	 */
	public int getMaxRowSize() throws DatabaseSessionException, ResultSetAccessException {
		try {
			return session.getConnection().getMetaData().getMaxRowSize();
		} catch (AbstractMethodError e) {
			return -1;
		} catch (SQLException e) {
			throw new ResultSetAccessException("failed to get database specification.", e);
		}
	}

	/**
	 * ̃f[^x[Xł́AXL[}̍ő啶擾܂B<br>
	 * @return ̃f[^x[Xł́AXL[}̍ő啶
	 * @throws DatabaseSessionException f[^x[XڑOꍇɃX[܂
	 * @throws ResultSetAccessException ResultSetIuWFNgɑ΂ĐɃANZXłȂꍇɔ
	 */
	public int getMaxSchemaNameLength() throws DatabaseSessionException, ResultSetAccessException {
		try {
			return session.getConnection().getMetaData().getMaxSchemaNameLength();
		} catch (AbstractMethodError e) {
			return -1;
		} catch (SQLException e) {
			throw new ResultSetAccessException("failed to get database specification.", e);
		}
	}

	/**
	 * ̃f[^x[Xł́ASQL̍ő啶擾܂B<br>
	 * @return ̃f[^x[Xł́ASQL̍ő啶
	 * @throws DatabaseSessionException f[^x[XڑOꍇɃX[܂
	 * @throws ResultSetAccessException ResultSetIuWFNgɑ΂ĐɃANZXłȂꍇɔ
	 */
	public int getMaxStatementLength() throws DatabaseSessionException, ResultSetAccessException {
		try {
			return session.getConnection().getMetaData().getMaxStatementLength();
		} catch (AbstractMethodError e) {
			return -1;
		} catch (SQLException e) {
			throw new ResultSetAccessException("failed to get database specification.", e);
		}
	}

	/**
	 * ̃f[^x[X̓ɃI[vłANeBuȕ̍ő吔擾܂B<br>
	 * @return ̃f[^x[X̓ɃI[vłANeBuȕ̍ő吔
	 * @throws DatabaseSessionException f[^x[XڑOꍇɃX[܂
	 * @throws ResultSetAccessException ResultSetIuWFNgɑ΂ĐɃANZXłȂꍇɔ
	 */
	public int getMaxStatements() throws DatabaseSessionException, ResultSetAccessException {
		try {
			return session.getConnection().getMetaData().getMaxStatements();
		} catch (AbstractMethodError e) {
			return -1;
		} catch (SQLException e) {
			throw new ResultSetAccessException("failed to get database specification.", e);
		}
	}

	/**
	 * ̃f[^x[Xł́Ae[u̍ő啶擾܂B<br>
	 * @return ̃f[^x[Xł́Ae[u̍ő啶
	 * @throws DatabaseSessionException f[^x[XڑOꍇɃX[܂
	 * @throws ResultSetAccessException ResultSetIuWFNgɑ΂ĐɃANZXłȂꍇɔ
	 */
	public int getMaxTableNameLength() throws DatabaseSessionException, ResultSetAccessException {
		try {
			return session.getConnection().getMetaData().getMaxTableNameLength();
		} catch (AbstractMethodError e) {
			return -1;
		} catch (SQLException e) {
			throw new ResultSetAccessException("failed to get database specification.", e);
		}
	}

	/**
	 * ̃f[^x[Xł́ASELECT ̍őe[u擾܂B<br>
	 * @return ̃f[^x[Xł́ASELECT ̍őe[u
	 * @throws DatabaseSessionException f[^x[XڑOꍇɃX[܂
	 * @throws ResultSetAccessException ResultSetIuWFNgɑ΂ĐɃANZXłȂꍇɔ
	 */
	public int getMaxTablesInSelect() throws DatabaseSessionException, ResultSetAccessException {
		try {
			return session.getConnection().getMetaData().getMaxTablesInSelect();
		} catch (AbstractMethodError e) {
			return -1;
		} catch (SQLException e) {
			throw new ResultSetAccessException("failed to get database specification.", e);
		}
	}

	/**
	 * ̃f[^x[Xł́A[U̍ő啶擾܂B<br>
	 * @return ̃f[^x[Xł́A[U̍ő啶
	 * @throws DatabaseSessionException f[^x[XڑOꍇɃX[܂
	 * @throws ResultSetAccessException ResultSetIuWFNgɑ΂ĐɃANZXłȂꍇɔ
	 */
	public int getMaxUserNameLength() throws DatabaseSessionException, ResultSetAccessException {
		try {
			return session.getConnection().getMetaData().getMaxUserNameLength();
		} catch (AbstractMethodError e) {
			return -1;
		} catch (SQLException e) {
			throw new ResultSetAccessException("failed to get database specification.", e);
		}
	}

	/**
	 *  ResultSet IuWFNg̃ftHg̕ێ@\擾܂B<br>
	 * 蓾ljava.sql.ResultSetŒ`Ă܂B
	 * @return  ResultSet IuWFNg̃ftHg̕ێ@\
	 * @throws DatabaseSessionException f[^x[XڑOꍇɃX[܂
	 * @throws ResultSetAccessException ResultSetIuWFNgɑ΂ĐɃANZXłȂꍇɔ
	 */
	public int getResultSetHoldability() throws DatabaseSessionException, ResultSetAccessException {
		try {
			return session.getConnection().getMetaData().getResultSetHoldability();
		} catch (AbstractMethodError e) {
			return -1;
		} catch (SQLException e) {
			throw new ResultSetAccessException("failed to get database specification.", e);
		}
	}

	/**
	 *  ResultSet IuWFNg̃ftHg̕ێ@\𕶎\ƂĎ擾܂B<br>
	 * 蓾ljava.sql.ResultSetŒ`Ă܂B
	 * @return  ResultSet IuWFNg̃ftHg̕ێ@\
	 * @throws DatabaseSessionException f[^x[XڑOꍇɃX[܂
	 * @throws ResultSetAccessException ResultSetIuWFNgɑ΂ĐɃANZXłȂꍇɔ
	 */
	public String getResultSetHoldabilityName() throws DatabaseSessionException, ResultSetAccessException {
		int type = getResultSetHoldability();
		if (type == ResultSet.HOLD_CURSORS_OVER_COMMIT) {
			return "ResultSet.HOLD_CURSORS_OVER_COMMIT";
		} else if (type == ResultSet.CLOSE_CURSORS_AT_COMMIT) {
			return "ResultSet.CLOSE_CURSORS_AT_COMMIT";
		} else {
			return "Unkown";
		}
	}

	/**
	 * SQLException.getSQLState ɂĕԂ SQLSTATE  X/Open (݂ Open Group)  SQL CLI ł邩 SQL99 ł邩܂B<br>
	 * @return SQLSTATE ̌^BsqlStateXOpen ܂ sqlStateSQL99
	 * @throws DatabaseSessionException f[^x[XڑOꍇɃX[܂
	 * @throws ResultSetAccessException ResultSetIuWFNgɑ΂ĐɃANZXłȂꍇɔ
	 */
	public int getSQLStateType() throws DatabaseSessionException, ResultSetAccessException {
		try {
			return session.getConnection().getMetaData().getSQLStateType();
		} catch (AbstractMethodError e) {
			return -1;
		} catch (SQLException e) {
			throw new ResultSetAccessException("failed to get database specification.", e);
		}
	}

	/**
	 * SQLException.getSQLState ɂĕԂ SQLSTATE𕶎\ƂĎ擾܂B<br>
	 * @return SQLSTATĚ^
	 * @throws DatabaseSessionException f[^x[XڑOꍇɃX[܂
	 * @throws ResultSetAccessException ResultSetIuWFNgɑ΂ĐɃANZXłȂꍇɔ
	 */
	public String getSQLStateTypeName() throws DatabaseSessionException, ResultSetAccessException {
		int type = getSQLStateType();
		if (type == 1) {
			return "sqlStateXOpen";
		} else if (type == 2) {
			return "sqlStateSQL99";
		} else {
			return "Unkown";
		}
	}
}
