package org.phosphoresce.commons.database.accessor;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.Map.Entry;

/**
 * tFb`obt@Xg<br>
 * ʏ̃XgIuWFNgƂ͈قȂAtFb`̃^C~OŃXgGgێ
 * XgTCYׂĂێȂXgIuWFNgƂċ@\܂B<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/10/20	Kitagawa		VK쐬
 *-->
 */
public class FetchingList implements List {

	/** obt@O}bvIuWFNg */
	private Map map = new TreeMap();

	/** XgJEg */
	private int count = 0;

	/**
	 * RXgN^<br>
	 */
	public FetchingList() {
		super();
	}

	/**
	 * RXgN^<br>
	 * @param count \̈
	 */
	public FetchingList(int count) {
		this.count = count;
	}

	/**
	 * w肳ꂽCfbNXȍ~̕ێXgCfbNXɃCNg܂B<br>
	 * @param index CNgJnCfbNX
	 */
	private void incrementIndex(int index) {
		for (int i = count - 1; i >= index; i--) {
			Integer key = new Integer(i);
			if (map.containsKey(key)) {
				Object object = map.get(key);
				map.remove(key);
				map.put(new Integer(key.intValue() + 1), object);
			}
		}
	}

	/**
	 * w肳ꂽCfbNXȍ~̕ێXgCfbNXOɃfNg܂B<br>
	 * @param index fNgJnCfbNX
	 */
	private void decrementIndex(int index) {
		for (int i = index; i <= count - 1; i++) {
			Integer key = new Integer(i);
			if (map.containsKey(key)) {
				Object object = map.get(key);
				map.remove(key);
				map.put(new Integer(key.intValue() - 1), object);
			}
		}
	}

	/**
	 * ƂĂÓIȃR[hׂč폜܂B<br>
	 */
	public void clearStaticRecords() {
		for (Iterator iterator = iterator(); iterator.hasNext();) {
			ResultRow resultRow = (ResultRow) iterator.next();
			if (resultRow != null && resultRow.getState().equals(ResultAccessorState.STATIC)) {
				remove(resultRow);
			}
		}
	}

	/**
	 * w肳ꂽIuWFNgǉ܂B<br>
	 * @param o IuWFNg
	 * @return XgύXꂽꍇAȂ킿trueԋp
	 * @see java.util.List#add(java.lang.Object)
	 */
	public boolean add(Object o) {
		map.put(new Integer(++count - 1), o);
		return true;
	}

	/**
	 * w肳ꂽCfbNXɃIuWFNgǉ܂B<br>
	 * @param index CfbNX
	 * @param element IuWFNg
	 * @see java.util.List#add(int, java.lang.Object)
	 */
	public void add(int index, Object element) {
		if (count - 1 < index) {
			count = index;
			add(element);
		} else {
			incrementIndex(index);
			map.put(new Integer(index), element);
		}
	}

	/**
	 * w肳ꂽRNV̓eׂĒǉ܂B<br>
	 * @param c RNVIuWFNg
	 * @return XgύXꂽꍇtrueԋp
	 * @see java.util.List#addAll(java.util.Collection)
	 */
	public boolean addAll(Collection c) {
		if (c == null || c.size() == 0) {
			return false;
		}
		for (Iterator iterator = c.iterator(); iterator.hasNext();) {
			add(iterator.next());
		}
		return true;
	}

	/**
	 * w肳ꂽRNV̓eׂĒǉ܂B<br>
	 * @param index ǉʒu
	 * @param c RNVIuWFNg
	 * @return XgύXꂽꍇtrueԋp
	 * @see java.util.List#addAll(int, java.util.Collection)
	 */
	public boolean addAll(int index, Collection c) {
		if (c == null || c.size() == 0) {
			return false;
		}
		int count = 0;
		for (Iterator iterator = c.iterator(); iterator.hasNext();) {
			add(index + count++, iterator.next());
		}
		return true;
	}

	/**
	 * Xg̓eׂăNA܂B<br>
	 * @see java.util.List#clear()
	 */
	public void clear() {
		map.clear();
		count = 0;
	}

	/**
	 * w肳ꂽIuWFNgێĂ邩肵܂B<br>
	 * @param o IuWFNg
	 * @return IuWFNgێĂꍇtrueԋp
	 * @see java.util.List#contains(java.lang.Object)
	 */
	public boolean contains(Object o) {
		return map.containsValue(o);
	}

	/**
	 * w肳ꂽRNV̓eׂĕێĂ邩肵܂B<br>
	 * @param c RNVIuWFNg
	 * @return RNV̓eׂĕێĂꍇtrueԋp
	 * @see java.util.List#containsAll(java.util.Collection)
	 */
	public boolean containsAll(Collection c) {
		if (c == null || c.size() == 0) {
			return true;
		}
		for (Iterator iterator = c.iterator(); iterator.hasNext();) {
			if (!contains(iterator.next())) {
				return false;
			}
		}
		return true;
	}

	/**
	 * w肳ꂽCfbNX̃IuWFNg擾܂B<br>
	 * @param index CfbNX
	 * @return IuWFNg
	 * @see java.util.List#get(int)
	 */
	public Object get(int index) {
		return map.get(new Integer(index));
	}

	/**
	 * w肳ꂽIuWFNg̃CfbNX擾܂B<br>
	 * @param o IuWFNg
	 * @return w肳ꂽIuWFNg̃CfbNX
	 * @see java.util.List#indexOf(java.lang.Object)
	 */
	public int indexOf(Object o) {
		if (!map.containsValue(o)) {
			return -1;
		}
		for (Iterator iterator = map.entrySet().iterator(); iterator.hasNext();) {
			Entry entry = (Entry) iterator.next();
			if (o == null && entry.getValue() == null) {
				Integer key = (Integer) entry.getKey();
				return key.intValue();
			} else if (o != null && o.equals(entry.getValue())) {
				Integer key = (Integer) entry.getKey();
				return key.intValue();
			}
		}
		return -1;
	}

	/**
	 * ێĂeł邩肵܂B<br>
	 * @return ێĂełꍇtrueԋp
	 * @see java.util.List#isEmpty()
	 */
	public boolean isEmpty() {
		return count == 0;
	}

	/**
	 * ێ郊Xg̃Ce[^IuWFNg擾܂B<br>
	 * @return Ce[^IuWFNg
	 * @see java.util.List#iterator()
	 */
	public Iterator iterator() {
		return new FetchingListIterator();
	}

	/**
	 * w肳ꂽIuWFNg̍ŏICfbNX擾܂B<br>
	 * @param o IuWFNg
	 * @return w肳ꂽIuWFNg̍ŏICfbNX
	 * @see java.util.List#lastIndexOf(java.lang.Object)
	 */
	public int lastIndexOf(Object o) {
		if (!map.containsValue(o)) {
			return -1;
		}
		int result = -1;
		for (Iterator iterator = map.entrySet().iterator(); iterator.hasNext();) {
			Entry entry = (Entry) iterator.next();
			if (o == null && entry.getValue() == null) {
				Integer key = (Integer) entry.getKey();
				result = key.intValue();
			} else if (o != null && o.equals(entry.getValue())) {
				Integer key = (Integer) entry.getKey();
				result = key.intValue();
			}
		}
		return result;
	}

	/**
	 * ێ郊Xg̃Ce[^IuWFNg擾܂B<br>
	 * @return Ce[^IuWFNg
	 * @see java.util.List#listIterator()
	 */
	public ListIterator listIterator() {
		return new FetchingListListIterator();
	}

	/**
	 * ێ郊Xg̃Ce[^IuWFNg擾܂B<br>
	 * @param index JnCfbNX
	 * @return Ce[^IuWFNg
	 * @see java.util.List#listIterator(int)
	 */
	public ListIterator listIterator(int index) {
		return new FetchingListListIterator(index);
	}

	/**
	 * w肳ꂽCfbNX̃IuWFNg폜܂B<br>
	 * @param index CfbNX
	 * @return ێĂIuWFNg
	 * @see java.util.List#remove(int)
	 */
	public Object remove(int index) {
		Object object = get(index);
		decrementIndex(index);
		return object;
	}

	/**
	 * w肳ꂽIuWFNgXg폜܂B<br>
	 * @param o 폜ΏۃIuWFNg
	 * @return ɂăXgeύXꂽꍇtrueԋp
	 * @see java.util.List#remove(java.lang.Object)
	 */
	public boolean remove(Object o) {
		if (!contains(o)) {
			return false;
		}
		int index = indexOf(o);
		Object object = remove(index);
		return true;
	}

	/**
	 * w肳ꂽRNVێIuWFNgׂč폜܂B<br>
	 * @param c RNVIuWFNg
	 * @return ɂăXgeύXꂽꍇtrueԋp
	 * @see java.util.List#removeAll(java.util.Collection)
	 */
	public boolean removeAll(Collection c) {
		if (c == null || c.size() == 0) {
			return false;
		}
		boolean result = false;
		for (Iterator iterator = c.iterator(); iterator.hasNext();) {
			Object object = iterator.next();
			if (contains(object)) {
				result = true;
			}
			remove(object);
		}
		return result;
	}

	/**
	 * w肳ꂽRNVIuWFNg̃IuWFNĝ݂ێ悤ɃXgύX܂B<br>
	 * @param c RNVIuWFNg
	 * @return ɂăXgeύXꂽꍇtrueԋp
	 * @see java.util.List#retainAll(java.util.Collection)
	 */
	public boolean retainAll(Collection c) {
		if (c == null || c.size() == 0) {
			return false;
		}
		boolean result = false;
		for (Iterator iterator = c.iterator(); iterator.hasNext();) {
			Object object = iterator.next();
			if (!contains(object)) {
				result = true;
				remove(object);
			}
		}
		return result;
	}

	/**
	 * w肳ꂽCfbNXɃIuWFNgݒ肵܂B<br>
	 * @param index CfbNX
	 * @param element IuWFNg
	 * @return w肳ꂽCfbNXɕێẴIuWFNg
	 * @see java.util.List#set(int, java.lang.Object)
	 */
	public Object set(int index, Object element) {
		Object object = get(index);
		if (count - 1 < index) {
			count = index + 1;
		}
		map.put(new Integer(index), element);
		return object;
	}

	/**
	 * ݃XgŜ̃TCY擾܂B<br>
	 * @return XgTCY
	 * @see java.util.List#size()
	 */
	public int size() {
		return count;
	}

	/**
	 * w肳ꂽ͈͂̃XgIuWFNg擾܂B<br>
	 * @param fromIndex ͈͊Jnʒu
	 * @param toIndex ͈͏Iʒu
	 * @return XgIuWFNg
	 * @see java.util.List#subList(int, int)
	 */
	public List subList(int fromIndex, int toIndex) {
		List list = new LinkedList();
		for (int i = fromIndex; i <= toIndex; i++) {
			list.add(get(i));
		}
		return list;
	}

	/**
	 * ێĂ郊XgeIuWFNgzƂĎ擾܂B<br>
	 * @return IuWFNgz
	 * @see java.util.List#toArray()
	 */
	public Object[] toArray() {
		Object[] objects = new Object[count];
		for (int i = 0; i <= count - 1; i++) {
			objects[i] = get(i);
		}
		return objects;
	}

	/**
	 * w肳ꂽIuWFNgzɑ΂ăXg̓eݒ肵ĕԋp܂B<br>
	 * @param a IuWFNgz
	 * @return IuWFNgz
	 * @see java.util.List#toArray(java.lang.Object[])
	 */
	public Object[] toArray(Object[] a) {
		for (int i = 0; i <= count - 1; i++) {
			a[i] = get(i);
		}
		return a;
	}

	/**
	 * tFb`obt@XgCe[^IuWFNg<br>
	 * 
	 * @author Kitagawa<br>
	 * 
	 *<!--
	 * XV		XV			XVe
	 * 2007/10/20	Kitagawa		VK쐬
	 *-->
	 */
	private class FetchingListIterator implements Iterator {

		/** Ce[^CfbNX */
		private int index = 0;

		/**
		 * RXgN^<br>
		 */
		public FetchingListIterator() {
			super();
		}

		/**
		 * Ce[^IuWFNg̗vf񋟂ł邩肵܂B<br>
		 * @return Ce[^IuWFNg̗vf񋟂łꍇtrueԋp
		 * @see java.util.Iterator#hasNext()
		 */
		public boolean hasNext() {
			return index <= FetchingList.this.count - 1;
		}

		/**
		 * ̃Xgvf擾܂B<br>
		 * @return ̃Xgvf
		 * @see java.util.Iterator#next()
		 */
		public Object next() {
			return FetchingList.this.get(index++);
		}

		/**
		 * ݂̃Xgvf폜܂B<br>
		 * @see java.util.Iterator#remove()
		 */
		public void remove() {
			FetchingList.this.remove(index);
		}
	}

	/**
	 * tFb`obt@XgCe[^IuWFNg<br>
	 * 
	 * @author Kitagawa<br>
	 * 
	 *<!--
	 * XV		XV			XVe
	 * 2007/10/20	Kitagawa		VK쐬
	 *-->
	 */
	private class FetchingListListIterator implements ListIterator {

		/** Ce[^CfbNX */
		private int index = 0;

		/**
		 * RXgN^<br>
		 */
		public FetchingListListIterator() {
			super();
		}

		/**
		 * RXgN^<br>
		 * @param index CfbNX
		 */
		public FetchingListListIterator(int index) {
			super();
			this.index = index;
		}

		/**
		 * ݂̃CfbNXɃIuWFNgǉ܂B<br>
		 * @param o IuWFNg
		 * @see java.util.ListIterator#add(java.lang.Object)
		 */
		public void add(Object o) {
			FetchingList.this.add(o);
		}

		/**
		 * Ce[^IuWFNg̗vf񋟂ł邩肵܂B<br>
		 * @return Ce[^IuWFNg̗vf񋟂łꍇtrueԋp
		 * @see java.util.ListIterator#hasNext()
		 */
		public boolean hasNext() {
			return index < count - 1;
		}

		/**
		 * Ce[^IuWFNgO̗vf񋟂ł邩肵܂B<br>
		 * @return Ce[^IuWFNg̗vf񋟂łꍇtrueԋp
		 * @see java.util.ListIterator#hasPrevious()
		 */
		public boolean hasPrevious() {
			return index > 0;
		}

		/**
		 * ̃Xgvf擾܂B<br>
		 * @return ̃Xgvf
		 * @see java.util.ListIterator#next()
		 */
		public Object next() {
			return FetchingList.this.get(index++);
		}

		/**
		 * next\bhŎ擾vf̃CfbNX擾܂B<br>
		 * @return Ɏ擾vf̃CfbNX
		 * @see java.util.ListIterator#nextIndex()
		 */
		public int nextIndex() {
			return index;
		}

		/**
		 * ÕXgvf擾܂B<br>
		 * @return ÕXgvf
		 * @see java.util.ListIterator#previous()
		 */
		public Object previous() {
			return FetchingList.this.get(--index);
		}

		/**
		 * previous\bhŎ擾vf̃CfbNX擾܂B<br>
		 * @return Ɏ擾vf̃CfbNX
		 * @see java.util.ListIterator#previousIndex()
		 */
		public int previousIndex() {
			return index - 1;
		}

		/**
		 * ݂̃Xgvf폜܂B<br>
		 * @see java.util.ListIterator#remove()
		 */
		public void remove() {
			FetchingList.this.remove(index);
		}

		/**
		 * ݂̈ʒuɃIuWFNgݒ肵܂B<br>
		 * @param o IuWFNg
		 * @see java.util.ListIterator#set(java.lang.Object)
		 */
		public void set(Object o) {
			FetchingList.this.set(index, o);
		}
	}
}
