package org.phosphoresce.commons.database.accessor;

import java.sql.ResultSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

import org.phosphoresce.commons.database.exception.DatabaseConnectionException;
import org.phosphoresce.commons.database.exception.IllegalOperateRuntimeException;
import org.phosphoresce.commons.database.exception.IllegalResultSetAdjustmentException;
import org.phosphoresce.commons.database.exception.IllegalResultSetLocationIndexException;
import org.phosphoresce.commons.database.exception.IllegalResultTypeException;
import org.phosphoresce.commons.database.exception.IllegalTemplateException;
import org.phosphoresce.commons.database.exception.ResultSetAccessException;

/**
 * R[hf[^Xgobt@ANZXIuWFNg<br>
 * <br>
 * {@link java.util.List}C^tF[X郌R[hANZX@\񋟂܂B<br>
 * obt@Odl{@link RecordBufferedAccessor}ɂׂĈϏ܂B<br>
 * 
 * @see RecordAccessorAbstract
 * @see RecordBufferedAccessor
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/08/31	Kitagawa		VK쐬
 *-->
 */
public class RecordListBufferedAccessor extends RecordBufferedAccessor implements List {

	/**
	 * RXgN^<br>
	 * @param resultSet ResultSetIuWFNg
	 * @throws ResultSetAccessException ResultSetւ̑삪sȂꍇɔ
	 * @throws IllegalResultSetLocationIndexException sȈʒu𑀍삵ꍇɔ
	 * @throws IllegalResultSetAdjustmentException w肳ꂽReusltSetIuWFNg̃J[\ʒu擪OɂȂĂȂꍇɔ 
	 * @throws DatabaseConnectionException f[^x[XRlNVIuWFNgR[hANZXs\ȃIuWFNg̏ꍇɔ
	 */
	public RecordListBufferedAccessor(ResultSet resultSet) throws ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException {
		super(resultSet);
	}

	/**
	 * w肳ꂽvfXg̍Ōɒǉ܂B<br>
	 * \bhp[^ɎwłIuWFNg{@link ResultTemplateRow}Ɍ܂B<br>
	 * ȊÕIuWFNgw肳ꂽꍇ͕sȃp[^ƂėO({@link IllegalArgumentException})X[܂B<br>
	 * ܂As}ɂĉ炩̗OX[ꂽꍇ{@link IllegalOperateRuntimeException}ɃbvėOX[܂B<br>
	 * RuntimeExceptionł͂ȂAIɗOʂŃLb`ꍇ{@link RecordBufferedAccessor#insertRow(ResultTemplateRow)}
	 * gp邱Ƃ܂B<br>
	 * @param object Xgɒǉvf
	 * @return trueԋp(Collection.add\bḧʋKɏ])
	 * @see java.util.List#add(java.lang.Object)
	 */
	public boolean add(Object object) {
		if (object == null || !(object instanceof ResultTemplateRow)) {
			throw new IllegalArgumentException("is not instancedof template row object");
		}
		try {
			insertRow((ResultTemplateRow) object);
		} catch (ResultSetAccessException e) {
			throw new IllegalOperateRuntimeException("failed to insert row", e);
		} catch (IllegalResultSetLocationIndexException e) {
			throw new IllegalOperateRuntimeException("failed to insert row", e);
		} catch (IllegalResultSetAdjustmentException e) {
			throw new IllegalOperateRuntimeException("failed to insert row", e);
		} catch (IllegalResultTypeException e) {
			throw new IllegalOperateRuntimeException("failed to insert row", e);
		} catch (IllegalTemplateException e) {
			throw new IllegalOperateRuntimeException("failed to insert row", e);
		}
		return true;
	}

	/**
	 * Xg̎w肳ꂽʒuɁAw肳ꂽvf}܂B<br>
	 * w肳GgIuWFNg{@link org.phosphoresce.commons.database.accessor.ResultTemplateRow}NXłKv܂B<br>
	 * \bhgp邱ƂŃR[h̑}͊܂Aǉʒu͖Ɍ肳܂B<br>
	 * Ȃ킿A{@link List#add(int, Object)}񋟂CfbNX͖{@link List#add(Object)}Ɠl̓ƂȂ܂B<br>
	 * @param index w̗vf}CfbNX
	 * @param element }vf
	 * @see java.util.List#add(int, java.lang.Object)
	 * @see RecordListBufferedAccessor#add(Object)
	 */
	public void add(int index, Object element) {
		if (element == null) {
			throw new IllegalOperateRuntimeException("null 'element' argument");
		}
		if (!(element instanceof ResultTemplateRow)) {
			throw new IllegalOperateRuntimeException("object is not ResultTemplateRow class");
		}
		add(element);
	}

	/**
	 * w肳ꂽRNVׂ̂Ă̗vfAw肳ꂽRNV
	 * qɂĕԂ鏇ŃXg̍Ōɒǉ܂B<br>
	 * ARNVɊ܂܂vf͑S{@link ResultTemplateRow}łKv܂B<br>
	 * @param collection vfXgɒǉRNV
	 * @return ̌ĂяǒʁÃXgύXꂽꍇtrueԋp
	 * @see java.util.List#addAll(java.util.Collection)
	 */
	public boolean addAll(Collection collection) {
		if (collection == null) {
			return false;
		}
		boolean update = false;
		for (Iterator iterator = collection.iterator(); iterator.hasNext();) {
			Object object = iterator.next();
			if (object == null) {
				continue;
			} else {
				add(object);
				update = true;
			}
		}
		return update;
	}

	/**
	 * w肳ꂽRNVׂ̂Ă̗vfAXg̎w肳ꂽʒuɑ}܂B<br>
	 * \bhgp邱ƂŃR[h̑}͊܂Aǉʒu͖Ɍ肳܂B<br>
	 * Ȃ킿A<code>List#addAll(int, Collection))</code>񋟂CfbNX͖<code>List#addAll(Collection)</code>Ɠl̓ƂȂ܂B<br>
	 * ARNVɊ܂܂vf͑S{@link ResultTemplateRow}łKv܂B<br>
	 * @param index w肳ꂽRNVŏ̗vf}ʒũCfbNX
	 * @param collection Xgɑ}vf
	 * @return ̌ĂяǒʁÃXgύXꂽꍇtrueԋp
	 * @see java.util.List#addAll(int, java.util.Collection)
	 */
	public boolean addAll(int index, Collection collection) {
		return addAll(collection);
	}

	/**
	 * ׂĂ̗vfXg폜܂B<br>
	 * <br>
	 * ̃tFb`obt@폜^C~OResultSetւ̔fɍs܂B<br>
	 * 폜ŵ݂s{@link org.phosphoresce.commons.database.accessor.RecordListBufferedAccessor#deleteRow(int)}Ƃ͓삪قȂ܂B<br>
	 * AResultSet̃R[hSĂΏۂɍ폜s邱ƂɂȂ܂B<br>
	 * @see java.util.List#clear()
	 */
	public void clear() {
		while (fetchBuffer.size() > 0) {
			remove(0);
		}
	}

	/**
	 * XgɎw肳ꂽvf܂܂Ă邩肵܂B<br>
	 * w肳GgIuWFNg{@link org.phosphoresce.commons.database.accessor.ResultRow}NXłKv܂B<br>
	 * @param object vf
	 * @return XgAw肳ꂽvfێĂꍇtrueԋp
	 * @see java.util.List#contains(java.lang.Object)
	 */
	public boolean contains(Object object) {
		if (!(object instanceof ResultRow)) {
			throw new IllegalOperateRuntimeException("object is not ResultRow class");
		}
		return fetchBuffer.contains(object);
	}

	/**
	 * w肳ꂽRNVׂ̂Ă̗vfXgɊ܂܂Ă邩肵܂B<br>
	 * @param collection ̃Xgɂ邩ǂ𒲂ׂRNV
	 * @return w肳ꂽRNVׂ̂Ă̗vfXgɊ܂܂Ăꍇtrueԋp
	 * @see java.util.List#containsAll(java.util.Collection)
	 */
	public boolean containsAll(Collection collection) {
		return fetchBuffer.containsAll(collection);
	}

	/**
	 * Xg̎w肳ꂽʒuɂvf擾܂B<br>
	 * @param index CfbNX
	 * @return w肳ꂽʒuɂvf
	 * @see java.util.List#get(int)
	 */
	public Object get(int index) {
		return fetchBuffer.get(index);
	}

	/**
	 * w肳ꂽvfXgōŏɌoꂽʒũCfbNX񋟂܂B<br>
	 * w肳GgIuWFNg{@link org.phosphoresce.commons.database.accessor.ResultRow}NXłKv܂B<br>
	 * @param object vf
	 * @return w肳ꂽvfXgōŏɌoꂽʒũCfbNX(݂Ȃꍇ-1)
	 * @see java.util.List#indexOf(java.lang.Object)
	 */
	public int indexOf(Object object) {
		if (!(object instanceof ResultRow)) {
			throw new IllegalOperateRuntimeException("object is not ResultRow class");
		}
		return fetchBuffer.indexOf(object);
	}

	/**
	 * Xgł邩肵܂B<br>
	 * @return Xgłꍇtrueԋp
	 * @see java.util.List#isEmpty()
	 */
	public boolean isEmpty() {
		return fetchBuffer.isEmpty();
	}

	/**
	 * Xg̗vfK؂ȏŌJԂCe[^IuWFNg񋟂܂B<br>
	 * @return Ce[^IuWFNg
	 * @see java.util.List#iterator()
	 */
	public Iterator iterator() {
		return fetchBuffer.iterator();
	}

	/**
	 * w肳ꂽvfXgōŌɌoꂽʒũCfbNX񋟂܂B
	 * w肳GgIuWFNg{@link org.phosphoresce.commons.database.accessor.ResultRow}NXłKv܂B<br>
	 * @param object vf
	 * @return w肳ꂽvfXgōŌɌoꂽʒu̗vf̃CfbNX(݂Ȃꍇ-1)
	 * @see java.util.List#lastIndexOf(java.lang.Object)
	 */
	public int lastIndexOf(Object object) {
		if (!(object instanceof ResultRow)) {
			throw new IllegalOperateRuntimeException("object is not ResultRow class");
		}
		return fetchBuffer.lastIndexOf(object);
	}

	/**
	 * Xg̗vfK؂ȏŌJԂCe[^IuWFNg񋟂܂B<br>
	 * @return Ce[^IuWFNg
	 * @see java.util.List#listIterator()
	 */
	public ListIterator listIterator() {
		return fetchBuffer.listIterator();
	}

	/**
	 * Xg̗vfK؂ȏŌJԂCe[^IuWFNg񋟂܂B<br>
	 * @param index ŏ̗vf̃CfbNX
	 * @return Ce[^IuWFNg
	 * @see java.util.List#listIterator(int)
	 */
	public ListIterator listIterator(int index) {
		return fetchBuffer.listIterator(index);
	}

	/**
	 * Xg̎w肳ꂽʒuɂvf폜܂B<br>
	 * s폜ɂĉ炩̗OX[ꂽꍇ{@link IllegalOperateRuntimeException}ɃbvėOX[܂B<br>
	 * RuntimeExceptionł͂ȂAIɗOʂŃLb`ꍇ{@link org.phosphoresce.commons.database.accessor.RecordBufferedAccessor#deleteRow(int)}
	 * gp邱Ƃ܂B<br>
	 * <br>
	 * ̃tFb`obt@폜^C~OResultSetւ̔fɍs܂B<br>
	 * 폜ŵ݂s{@link RecordListBufferedAccessor#deleteRow(int)}Ƃ͓삪قȂ܂B<br>
	 * @param index 폜vf̃CfbNX
	 * @return w肳ꂽʒuɈȑOvf
	 * @see java.util.List#remove(int)
	 */
	public Object remove(int index) {
		try {
			ResultRow row = (ResultRow) fetchBuffer.get(index);
			if (row.state != ResultAccessorState.INSERT) {
				deleteRow(index);
				row.updateResult();
			}
			fetchBuffer.remove(index);
			return row;
		} catch (ResultSetAccessException e) {
			throw new IllegalOperateRuntimeException("failed to delete row", e);
		} catch (IllegalResultSetLocationIndexException e) {
			throw new IllegalOperateRuntimeException("failed to delete row", e);
		} catch (IllegalResultSetAdjustmentException e) {
			throw new IllegalOperateRuntimeException("failed to delete row", e);
		}
	}

	/**
	 * XgŎw肳ꂽvfŏɌoꂽƂA̗vf폜܂B<br>
	 * w肳GgIuWFNg{@link org.phosphoresce.commons.database.accessor.ResultRow}NXłKv܂B<br>
	 * <br>
	 * ̃tFb`obt@폜^C~OResultSetւ̔fɍs܂B<br>
	 * 폜ŵ݂s{@link org.phosphoresce.commons.database.accessor.RecordListBufferedAccessor#deleteRow(int)}Ƃ͓삪قȂ܂B<br>
	 * @param object Xg폜vf
	 * @return XgAw肳ꂽvfێĂꍇtrueԋp
	 * @see java.util.List#remove(java.lang.Object)
	 */
	public boolean remove(Object object) {
		if (!(object instanceof ResultRow)) {
			throw new IllegalOperateRuntimeException("object is not ResultRow class");
		}
		try {
			int index = fetchBuffer.indexOf(object);
			if (index < 0) {
				return false;
			}
			ResultRow row = (ResultRow) fetchBuffer.get(index);
			if (row.state != ResultAccessorState.INSERT) {
				deleteRow(index);
				row.updateResult();
			}
			fetchBuffer.remove(index);
			return true;
		} catch (ResultSetAccessException e) {
			throw new IllegalOperateRuntimeException("failed to delete row", e);
		} catch (IllegalResultSetLocationIndexException e) {
			throw new IllegalOperateRuntimeException("failed to delete row", e);
		} catch (IllegalResultSetAdjustmentException e) {
			throw new IllegalOperateRuntimeException("failed to delete row", e);
		}
	}

	/**
	 * w肳ꂽRNVɊi[Ă邷ׂĂ̗vfXg폜܂B<br>
	 * ARNVɊ܂܂vf͑S{@link org.phosphoresce.commons.database.accessor.ResultTemplateRow}łKv܂B<br>
	 * <br>
	 * ̃tFb`obt@폜^C~OResultSetւ̔fɍs܂B<br>
	 * 폜ŵ݂s{@link org.phosphoresce.commons.database.accessor.RecordListBufferedAccessor#deleteRow(int)}Ƃ͓삪قȂ܂B<br>
	 * @param collection ǂ̗vfXg폜邩`RNV
	 * @return ̌ĂяǒʁÃXgύXꂽꍇtrueԋp
	 * @see java.util.List#removeAll(java.util.Collection)
	 */
	public boolean removeAll(Collection collection) {
		if (collection == null) {
			return false;
		}
		boolean update = false;
		for (Iterator iterator = collection.iterator(); iterator.hasNext();) {
			Object object = iterator.next();
			if (object == null) {
				continue;
			} else {
				update = remove(object);
			}
		}
		return update;
	}

	/**
	 * w肳ꂽRNVɊi[ĂvfXgɊ܂܂悤ɂ܂B<br>
	 * ܂Aw肳ꂽRNVɊ܂܂ĂȂvfXg炷ׂč폜܂B<br>
	 * ARNVɊ܂܂vf͑S{@link org.phosphoresce.commons.database.accessor.ResultTemplateRow}łKv܂B<br>
	 * <br>
	 * ̃tFb`obt@폜^C~OResultSetւ̔fɍs܂B<br>
	 * 폜ŵ݂s{@link org.phosphoresce.commons.database.accessor.RecordListBufferedAccessor#deleteRow(int)}Ƃ͓삪قȂ܂B<br>
	 * @param collection Zbgێvf`RNV
	 * @return ̌ĂяǒʁÃXgύXꂽꍇtrueԋp
	 * @see java.util.List#retainAll(java.util.Collection)
	 */
	public boolean retainAll(Collection collection) {
		if (collection == null) {
			return false;
		}
		boolean update = false;
		for (Iterator iterator = collection.iterator(); iterator.hasNext();) {
			Object object = iterator.next();
			if (object == null) {
				continue;
			} else {
				if (!fetchBuffer.contains(object)) {
					update = remove(object);
				}
			}
		}
		return update;
	}

	/**
	 * Xg̎w肳ꂽʒuɂvfAw肳ꂽvfɒu܂B<br>
	 * 񋟂vf̒u͗vf̂̒uƂ͈قȂ邱Ƃ𒍈ӂĉB<br>
	 * w肳ꂽvfێs̓ew肳ꂽCfbNXɑ݂sɑ΂ĕʂsƂuƕ\܂B<br>
	 * Aw肵vf̎QƂw肵CfbNẌʒu̗vfɐݒ肳킯ł͂܂B<br>
	 * \bhp[^ɎwłIuWFNg{@link ResultTemplateRow}܂{@link ResultRow}Ɍ܂B<br>
	 * @param index uvf̃CfbNX
	 * @param element w肳ꂽʒuɊi[vf
	 * @return w肳ꂽʒuɈȑOvfAύXfꂽvf̂
	 * @see java.util.List#set(int, java.lang.Object)
	 */
	public Object set(int index, Object element) {
		try {
			if (element == null || (!(element instanceof ResultTemplateRow) && !(element instanceof ResultRow))) {
				throw new IllegalArgumentException("is not instancedof template row or row object");
			}
			ResultRow row = (ResultRow) fetchBuffer.get(index);
			if (element instanceof ResultTemplateRow) {
				ResultTemplateRow elementRow = (ResultTemplateRow) element;
				if (!row.getDefinition().equals(elementRow.getDefinition())) {
					throw new IllegalTemplateException("illegal different template information was specified");
				}
				for (int i = 0; i <= row.getDefinition().getColumnCount() - 1; i++) {
					ResultTemplateColumn elementColumn = elementRow.getColumn(i);
					ResultColumn column = row.getColumn(i);
					if (!column.getDefinition().equals(elementColumn.getDefinition())) {
						throw new IllegalTemplateException("illegal different template information was specified");
					}
					column.setValue(elementColumn.getValue());
				}
			} else if (element instanceof ResultRow) {
				ResultRow elementRow = (ResultRow) element;
				if (!row.getDefinition().equals(elementRow.getDefinition())) {
					throw new IllegalTemplateException("illegal different template information was specified");
				}
				for (int i = 0; i <= row.getDefinition().getColumnCount() - 1; i++) {
					ResultColumn elementColumn = elementRow.getColumn(i);
					ResultColumn column = row.getColumn(i);
					if (!column.getDefinition().equals(elementColumn.getDefinition())) {
						throw new IllegalTemplateException("illegal different template information was specified");
					}
					column.setValue(elementColumn.getValue());
				}
			}
			return row;
		} catch (IllegalTemplateException e) {
			throw new IllegalOperateRuntimeException("failed to set row", e);
		} catch (IllegalResultSetLocationIndexException e) {
			throw new IllegalOperateRuntimeException("failed to set row", e);
		}
	}

	/**
	 * R[hXgTCY񋟂܂B<br>
	 * Œ񋟂TCY̓tFb`ς݂̃R[hXgłAResultSetێTCYƂ͈قȂ܂B<br>
	 * ܂AR[h̒ǉsĂꍇ́ÃTCY̑ʂɔf܂B<br>
	 * A폜wsĂAR~bgsĂȂR[hɊւĂ͌ʂ猸Z邱Ƃ͂܂B<br>
	 * @return R[hXgTCY
	 * @see java.util.List#size()
	 */
	public int size() {
		return fetchBuffer.size();
	}

	/**
	 * w肳ꂽ͈͂̃Xgr[񋟂܂B<br>
	 * @param fromIndex ͈͉[_(܂)
	 * @param toIndex ͈͏[_(܂܂Ȃ)
	 * @return ̃Xg̎w肳ꂽ͈͂̃r[
	 * @see java.util.List#subList(int, int)
	 */
	public List subList(int fromIndex, int toIndex) {
		return fetchBuffer.subList(fromIndex, toIndex);
	}

	/**
	 * XgێeObjectzƂĒ񋟂܂B<br>
	 * @return Xg̗vfi[Ăz
	 * @see java.util.List#toArray()
	 */
	public Object[] toArray() {
		return fetchBuffer.toArray();
	}

	/**
	 * XgێeObjectzƂĒ񋟂܂B<br>
	 * @param objects Xg̗vf̊i[̔z
	 * @return Xg̗vfi[Ăz
	 * @see java.util.List#toArray(java.lang.Object[])
	 */
	public Object[] toArray(Object[] objects) {
		return fetchBuffer.toArray(objects);
	}
}
