package org.phosphoresce.commons.database.accessor;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import org.phosphoresce.commons.database.exception.IllegalResultSetAdjustmentException;
import org.phosphoresce.commons.database.exception.IllegalResultSetLocationIndexException;
import org.phosphoresce.commons.database.exception.ResultSetAccessException;

/**
 * s`ێNX<br>
 * <br>
 * NX͍s`ɕꂽNXłȀXVŗLrefreshResultC^tF[X
 * RXgN^ɂČĂ΂邽߁ÃNXp邱Ƃ܂B<br>
 * ܂ANX͊ƂȂResultSetɂāAsʒȕ͕svł邽߁Asʒu͕ێA񋟂܂B<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/08/31	Kitagawa		VK쐬
 *-->
 */
public final class ResultRowDefinition extends ResultAccessorAbstract {

	/** J`IuWFNgXg */
	private List columnDefinitions = new LinkedList();

	/** JCfbNX/̃}bsOIuWFNg */
	private Map columnIndexMap = new LinkedHashMap();

	// Constructor

	/**
	 * RXgN^<br>
	 * @param resultSet ResultSetIuWFNg
	 * @throws ResultSetAccessException ResultSetւ̑삪sȂꍇɔ
	 * @throws IllegalResultSetLocationIndexException sȈʒu𑀍삵ꍇɔ
	 * @throws IllegalResultSetAdjustmentException ResultSetƂ̐ĂȂꍇɔ
	 */
	ResultRowDefinition(ResultSet resultSet) throws ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException {
		super(resultSet, ResultAccessorState.STATIC, null);
		refreshResult();
	}

	// Accessor Interface Method

	/**
	 * ResultSetݒ񋟂eŎg̃IuWFNgtB[h̍XVs܂B<br>
	 * @param force `݂̂̌gł邽߁AtOɊ֌WȂKXVs܂
	 * @throws ResultSetAccessException ResultSetւ̑삪sȂꍇɔ
	 * @throws IllegalResultSetLocationIndexException sȈʒu𑀍삵ꍇɔ
	 * @throws IllegalResultSetAdjustmentException ResultSetƂ̐ĂȂꍇɔ
	 * @see org.phosphoresce.commons.database.accessor.ResultAccessorAbstract#refreshResult(boolean)
	 */
	protected void refreshResult(boolean force) throws ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException {
		int currentRow = getResultSetRowIndex();
		try {
			int columnCount = resultSet.getMetaData().getColumnCount();
			this.columnIndexMap.clear();
			for (int i = 0; i <= columnCount - 1; i++) {
				ResultColumnDefinition definition = null;
				if (i <= columnDefinitions.size() - 1) {
					definition = (ResultColumnDefinition) columnDefinitions.get(i);
					definition.setIndex(i);
					definition.refreshResult();
				} else {
					definition = new ResultColumnDefinition(resultSet, i);
					columnDefinitions.add(definition);
				}
				columnIndexMap.put(definition.getName(), new Integer(i));
			}
			if (columnDefinitions.size() > columnCount) {
				for (int i = 0; i <= columnDefinitions.size() - columnCount - 1; i++) {
					columnDefinitions.remove(columnDefinitions.size() - 1);
				}
			}
		} catch (SQLException e) {
			throw new ResultSetAccessException("failed to refresh result.", e);
		} finally {
			moveCurser(currentRow);
		}
	}

	/**
	 * gێeResultSetɑ΂Ĕf܂B<br>
	 * IuWFNg͒`݂̂{pƂĒ񋟂ׁA͉s܂B<br>
	 * @throws ResultSetAccessException ResultSetւ̑삪sȂꍇɔ
	 * @throws IllegalResultSetLocationIndexException sȈʒu𑀍삵ꍇɔ
	 * @throws IllegalResultSetAdjustmentException ResultSetƂ̐ĂȂꍇɔ
	 * @see org.phosphoresce.commons.database.accessor.ResultAccessorAbstract#updateResult()
	 */
	protected void updateResult() throws ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException {
	}

	// Public Method

	/**
	 * JIteratorIuWFNg擾܂B<br>
	 * @return JIteratorIuWFNg
	 */
	public Iterator getColumnNameIterator() {
		return columnIndexMap.keySet().iterator();
	}

	/**
	 * Jz擾܂B<br>
	 * @return Jz
	 */
	public String[] getColumnNames() {
		List list = new LinkedList();
		for (Iterator iterator = getColumnNameIterator(); iterator.hasNext();) {
			list.add(iterator.next());
		}
		return (String[]) list.toArray(new String[list.size()]);
	}

	/**
	 * sێJ擾܂B<br>
	 * @return sێJ
	 */
	public int getColumnCount() {
		return columnDefinitions.size();
	}

	/**
	 * w肳ꂽJ̃JCfbNX擾܂B<br>
	 * @param name J
	 * @return w肳ꂽJ̃JCfbNX(0`)
	 * @throws IllegalResultSetLocationIndexException w肳ꂽJsɑ݂Ȃꍇɔ
	 */
	public int getColumnIndex(String name) throws IllegalResultSetLocationIndexException {
		if (!columnIndexMap.containsKey(name)) {
			throw new IllegalResultSetLocationIndexException("'" + name + "' column not exist.");
		}
		return ((Integer) columnIndexMap.get(name)).intValue();
	}

	/**
	 * w肳ꂽJCfbNX̃J擾܂B<br>
	 * @param resultColumnsIndex JCfbNX(0`)
	 * @return w肳ꂽJCfbNX̃J
	 * @throws IllegalResultSetLocationIndexException sȃJCfbNXw肳ꂽꍇɔ
	 */
	public String getColumnName(int resultColumnsIndex) throws IllegalResultSetLocationIndexException {
		return getColumnDefinition(resultColumnsIndex).getName();
	}

	/**
	 * w肳ꂽJCfbNX̃J`IuWFNg擾܂B<br>
	 * @param columnIndex JCfbNX(0`)
	 * @return J`IuWFNg
	 * @throws IllegalResultSetLocationIndexException sȃJCfbNXw肳ꂽꍇɔ
	 */
	public ResultColumnDefinition getColumnDefinition(int columnIndex) throws IllegalResultSetLocationIndexException {
		if (columnDefinitions.size() - 1 < columnIndex || columnIndex < 0) {
			throw new IllegalResultSetLocationIndexException("illegal column index. [" + columnIndex + "]");
		}
		return (ResultColumnDefinition) columnDefinitions.get(columnIndex);
	}

	/**
	 * w肳ꂽJ̃J`IuWFNg擾܂B<br>
	 * @param name J
	 * @return J`IuWFNg
	 * @throws IllegalResultSetLocationIndexException w肳ꂽJsɑ݂Ȃꍇɔ
	 */
	public ResultColumnDefinition getColumnDefinition(String name) throws IllegalResultSetLocationIndexException {
		return getColumnDefinition(getColumnIndex(name));
	}

	// Override Method

	/**
	 * NX𕶎ƂĒ񋟂܂B<br>
	 * @return NX񕶎
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		StringBuffer buffer = new StringBuffer();
		buffer.append("[");
		for (Iterator iterator = columnDefinitions.iterator(); iterator.hasNext();) {
			buffer.append(iterator.next());
			if (iterator.hasNext()) {
				buffer.append(", ");
			}
		}
		buffer.append("]");
		return buffer.toString();
	}
}
