package org.phosphoresce.commons.database.test;

import java.util.Iterator;

import org.phosphoresce.commons.database.container.DatabaseCatalog;
import org.phosphoresce.commons.database.container.DatabaseContainer;
import org.phosphoresce.commons.database.container.DatabaseSchema;
import org.phosphoresce.commons.database.container.DatabaseTable;
import org.phosphoresce.commons.database.core.DatabaseConfig;
import org.phosphoresce.commons.database.core.DatabaseSession;

/**
 * eXgNX<br>
 * f[^x[XReieXgs܂B<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/09	Kitagawa		VK쐬
 *-->
 */
public class TestDatabaseContainer implements TestInterface {

	/**
	 * C\bh<br>
	 * @param args R}hC
	 * @throws ɗ\ʗOꍇɃX[܂
	 */
	public static void main(String[] args) throws Exception {
		System.out.println("start...");

		DatabaseConfig config = new DatabaseConfig(JDBC_DRIVER, JDBC_URL, JDBC_USER, JDBC_PASSWORD);
		DatabaseSession session = new DatabaseSession(config);

		DatabaseContainer container = DatabaseContainer.createDatabaseContainer(session);

		System.out.println("***********************************************************************");
		for (Iterator catalogIterator = container.getCatalogListIterator(); catalogIterator.hasNext();) {
			DatabaseCatalog catalog = (DatabaseCatalog) catalogIterator.next();
			System.out.println("Catalog:" + catalog.getName());
			for (Iterator schemaIterator = catalog.getSchemaListIterator(); schemaIterator.hasNext();) {
				DatabaseSchema schema = (DatabaseSchema) schemaIterator.next();
				System.out.println("  Schema:" + schema.getName());
				for (Iterator tableIterator = schema.getTableListIterator(); tableIterator.hasNext();) {
					DatabaseTable table = (DatabaseTable) tableIterator.next();
					System.out.println("    Table:" + table.getName());
				}
			}
			for (Iterator tableIterator = catalog.getTableListIterator(); tableIterator.hasNext();) {
				DatabaseTable table = (DatabaseTable) tableIterator.next();
				System.out.println("  Table:" + table.getName());
			}
		}
		System.out.println("***********************************************************************");
		for (Iterator schemaIterator = container.getSchemaListIterator(); schemaIterator.hasNext();) {
			DatabaseSchema schema = (DatabaseSchema) schemaIterator.next();
			System.out.println("Schema:" + schema.getName());
			for (Iterator tableIterator = schema.getTableListIterator(); tableIterator.hasNext();) {
				DatabaseTable table = (DatabaseTable) tableIterator.next();
				System.out.println("  Table:" + table.getName());
			}
		}
		System.out.println("***********************************************************************");
		for (Iterator tableIterator = container.getTableListIterator(); tableIterator.hasNext();) {
			DatabaseTable table = (DatabaseTable) tableIterator.next();
			System.out.println("Table:" + table.getName());
		}
		System.out.println("***********************************************************************");

		session.getConnection().close();

		System.out.println("finished...");
	}
}
