package org.phosphoresce.commons.database.test;

import java.text.SimpleDateFormat;
import java.util.Date;

import org.phosphoresce.commons.database.accessor.RecordListBufferedAccessor;
import org.phosphoresce.commons.database.accessor.ResultRow;
import org.phosphoresce.commons.database.core.DatabaseConfig;
import org.phosphoresce.commons.database.core.DatabaseQueryManager;
import org.phosphoresce.commons.database.core.DatabaseSession;

/**
 * eXgNX<br>
 * R[hANZXNXeXg<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/10/20	Kitagawa		VK쐬
 *-->
 */
public class TestRecordInserter implements TestInterface {

	/**
	 * C\bh<br>
	 * @param args R}hC
	 * @throws ɗ\ʗOꍇɃX[܂
	 */
	public static void main(String[] args) throws Exception {
		System.out.println("start...");

		DatabaseConfig config = new DatabaseConfig(JDBC_DRIVER, JDBC_URL, JDBC_USER, JDBC_PASSWORD);
		DatabaseSession session = new DatabaseSession(config);
		DatabaseQueryManager manager = new DatabaseQueryManager(session);

		final int INSERT_ROW_COUNT = Integer.MAX_VALUE;
		final int COMMIT_TIMING = 1000;

		int insertCount = 0;

		manager.setQuery("select * from test");
		manager.execute();
		RecordListBufferedAccessor accessor = new RecordListBufferedAccessor(manager.getResultSet());

		System.out.println("--------------------------------------------------------------------------------");
		System.out.println("insert row...");
		for (int i = 0; i <= INSERT_ROW_COUNT; i++) {
			ResultRow row = accessor.insertRow();
			row.getColumn(0).setValue("" + i);
			row.getColumn(1).setValue("row" + i + "_" + new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date()));

			if (insertCount > COMMIT_TIMING) {
				accessor.updateResult();
				session.commit();
				insertCount = 0;
				System.out.println("commited... " + i);
				accessor.clearStaticRecords();
			}

			insertCount++;
		}

		session.getConnection().close();

		System.out.println("finished...");
	}
}
