package org.phosphoresce.commons.database.test;

import java.text.SimpleDateFormat;
import java.util.Date;

import org.phosphoresce.commons.database.accessor.RecordListBufferedAccessor;
import org.phosphoresce.commons.database.accessor.ResultRow;
import org.phosphoresce.commons.database.accessor.ResultTemplateRow;
import org.phosphoresce.commons.database.core.DatabaseConfig;
import org.phosphoresce.commons.database.core.DatabaseSession;
import org.phosphoresce.commons.database.core.DatabaseQueryManager;

/**
 * eXgNX<br>
 * R[hANZXNXeXg<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/09	Kitagawa		VK쐬
 *-->
 */
public class TestRecordListBufferedAccessor implements TestInterface {

	/**
	 * C\bh<br>
	 * @param args R}hC
	 * @throws ɗ\ʗOꍇɃX[܂
	 */
	public static void main(String[] args) throws Exception {
		System.out.println("start...");

		DatabaseConfig config = new DatabaseConfig(JDBC_DRIVER, JDBC_URL, JDBC_USER, JDBC_PASSWORD);
		DatabaseSession session = new DatabaseSession(config);
		DatabaseQueryManager manager = new DatabaseQueryManager(session);

		manager.setQuery("select * from test");
		manager.execute();

		RecordListBufferedAccessor accessor = new RecordListBufferedAccessor(manager.getResultSet());

		{
			System.out.println("--------------------------------------------------------------------------------");
			System.out.println("initialize...");
			System.out.println("buffered row count : " + accessor.getResultRowCount());
			System.out.println("result row count : " + accessor.getResultRowCount());
			for (int i = 0; i <= accessor.getResultRowCount() - 1; i++) {
				System.out.println("row " + i + "[" + accessor.getResultRow(i).getState() + "] : " + accessor.getResultRow(i));
			}
		}
		{
			System.out.println("--------------------------------------------------------------------------------");
			System.out.println("insert row...");
			for (int i = 0; i <= 1000 - 1; i++) {
				ResultRow row = accessor.insertRow();
				row.getColumn(0).setValue("" + i);
				row.getColumn(1).setValue("row" + i + "_" + new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date()));
			}
			System.out.println("buffered row count : " + accessor.getResultRowCount());
			System.out.println("result row count : " + accessor.getResultRowCount());
			for (int i = 0; i <= accessor.getResultRowCount() - 1; i++) {
				System.out.println("row " + i + " [" + accessor.getResultRow(i).getState() + "] : " + accessor.getResultRow(i));
			}
		}
		{
			System.out.println("--------------------------------------------------------------------------------");
			System.out.println("update row...");
			accessor.getResultRow(0).getColumn(1).setValue("update!!!");
			System.out.println("buffered row count : " + accessor.getResultRowCount());
			System.out.println("result row count : " + accessor.getResultRowCount());
			for (int i = 0; i <= accessor.getResultRowCount() - 1; i++) {
				System.out.println("row " + i + " [" + accessor.getResultRow(i).getState() + "] : " + accessor.getResultRow(i));
			}
		}
		{
			System.out.println("--------------------------------------------------------------------------------");
			System.out.println("delete row...");
			accessor.remove(1);
			System.out.println("buffered row count : " + accessor.getResultRowCount());
			System.out.println("result row count : " + accessor.getResultRowCount());
			for (int i = 0; i <= accessor.getResultRowCount() - 1; i++) {
				System.out.println("row " + i + " [" + accessor.getResultRow(i).getState() + "] : " + accessor.getResultRow(i));
			}
		}
		//		{
		//			System.out.println("--------------------------------------------------------------------------------");
		//			System.out.println("clear result !!!!!!");
		//			accessor.clear();
		//		}
		{
			System.out.println("--------------------------------------------------------------------------------");
			System.out.println("after update result...");
			System.out.println("buffered row count : " + accessor.getResultRowCount());
			System.out.println("result row count : " + accessor.getResultRowCount());
			for (int i = 0; i <= accessor.getResultRowCount() - 1; i++) {
				System.out.println("row " + i + " [" + accessor.getResultRow(i).getState() + "] : " + accessor.getResultRow(i));
			}
		}

		accessor.updateResult();
		session.commit();
		session.getConnection().close();

		System.out.println("finished...");
	}
}
