<?php
/* vim: set tabstop=4 shiftwidth=4: */

/*
 * Identity Predicate
 * (based on org.apache.commons.collections.functors.IdentityPredicate)
 *
 *
 * PHP version 5
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   PHP
 * @package    Commons
 * @author     Yomei Komiya
 * @copyright  2008 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    SVN: $Id: IdentityPredicate.php 276 2008-03-30 08:49:34Z whitestar $
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      File available since Release 1.0.1
 */

//namespace Commons::Cols::Functors;

require_once 'Commons/Lang/Object.php';
require_once 'Commons/Cols/Predicate.php';
require_once 'Commons/Cols/Functors/NullPredicate.php';
require_once 'Commons/IO/Serializable.php';
/*
use Commons::Lang::Object;
use Commons::Cols::Predicate;
use Commons::Cols::Functors/NullPredicate;
use Commons::IO::Serializable;
*/

/**
 * IdentityPredicate
 *
 *
 * @category   PHP
 * @package    Commons.Cols.Functors
 * @author     Yomei Komiya
 * @copyright  2008 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    Release: 1.0.1.1
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      Class available since Release 1.0.1
 */
final class Commons_Cols_Functors_IdentityPredicate
	extends Commons_Lang_Object
	implements Commons_Cols_Predicate, Commons_IO_Serializable {

	/**
	 * The value to compare to
	 *
	 * @var object
	 */
	private $iValue = null;
	
	
	/**
	 * Factory method to create the identity predicate.
	 *
	 * @param object $object
	 * @return Commons_Cols_Predicate
	 */
	public static function getInstance($object) {
		if (is_null($object)) {
			return Commons_Cols_Functors_NullPredicate::$INSTANCE;
		}
		return new self($object);
	}
	
	
	/**
	 * Constructor
	 *
	 * @param object $object
	 */
	public function Commons_Cols_Functors_IdentityPredicate($object) {
		parent::__construct();
		$this->iValue = $object;
	}
	
	
	public function __destruct() {
	}
	
	
	/**
	 * Evaluates the predicate.
	 *
	 * @param object $object
	 * @return bool
	 */
	public function evaluate($object) {
		return ($this->iValue === $object);
	}

	
	/**
	 * Gets the value.
	 *
	 * @return object the stored predicate.
	 */
	public function getValue() {
		return $this->iValue;
	}
	
}

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * c-hanging-comment-ender-p: nil
 * End:
 */
?>