<?php
/* vim: set tabstop=4 shiftwidth=4: */

/*
 * Equals Builder
 * (based on org.apache.commons.lang.builder.EqualsBuilder)
 *
 *
 * PHP version 5
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   PHP
 * @package    Commons
 * @author     Yomei Komiya
 * @copyright  2007 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    SVN: $Id: EqualsBuilder.php 75 2008-01-01 13:37:23Z whitestar $
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      File available since Release 0.8.0
 */

//namespace Commons::Lang::Builder;

require_once 'Commons/Lang/Object.php';
require_once 'Commons/Lang/TypeUtils.php';
/*
use Commons::Lang::Object;
use Commons::Lang::TypeUtils;
*/

/**
 * EqualsBuilder
 *
 *
 * @category   PHP
 * @package    Commons.Lang.Builder
 * @author     Yomei Komiya
 * @copyright  2007 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    Release: 1.0.1.1
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      Class available since Release 0.8.0
 */
class Commons_Lang_Builder_EqualsBuilder extends Commons_Lang_Object {
//class EqualsBuilder extends Object {
	
	/**
	 * Equality
	 *
	 * @var bool
	 */
	private $_isEquals = true;
	
	
	/**
	 * Constructor
	 */
	public function Commons_Lang_Builder_EqualsBuilder() {
		parent::__construct();
		// do nothing.
	}

	
	/**
	 * Appends super class equality
	 *
	 * @param bool $superEquals
	 * @return self
	 */
	public function appendSuper($superEquals) {
		if ($this->_isEquals === false) {
			return $this;
		}
		$this->_isEquals = $superEquals;
		return $this;
	}
	
	
	/**
	 * Test if two variables are equal.
	 *
	 * @param mixed $lhs the left hand side parameter
	 * @param mixed $rhs the right hand side parameter
	 * @return self this builder
	 */
	public function append($lhs, $rhs) {
		if ($this->_isEquals === false) {
			return $this;
		}
		// non-object's equality test, object's identity test
		if ($lhs === $rhs) {
			return $this;
		}
		if (is_null($lhs) || is_null($rhs)) {
			$this->setEquals(false);
			return $this;
		}
		if (!Commons_Lang_TypeUtils::isSameType($lhs, $rhs)) {
			$this->setEquals(false);
			return $this;
		}
		
		if (is_array($lhs)) {
			// use PHP comparative operator(===)'s rule.
			$this->_isEquals = ($lhs === $rhs);
		}
		elseif (is_object($lhs)) {
			// object's equality test
			$this->_isEquals = $lhs->equals($rhs);
		}
		else {
			// non-object's equality test
			$this->_isEquals = ($lhs === $rhs);
		}
		
		return $this;
	}
	
	
	public function isEquals() {
		return $this->_isEquals;
	}
	
	
	protected function setEquals($isEquals) {
		$this->_isEquals = $isEquals;
	}
	
}

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * c-hanging-comment-ender-p: nil
 * End:
 */
?>