<?php
/* vim: set tabstop=4 shiftwidth=4: */

/*
 * And Predicate
 *
 *
 * PHP version 5
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   PHP
 * @package    Commons
 * @author     Yomei Komiya
 * @copyright  2008 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    SVN: $Id: AndPredicate.php 280 2008-04-01 13:45:57Z whitestar $
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      File available since Release 1.0.1
 */

//namespace Commons::Cols::Functors;

require_once 'Commons/Lang/Object.php';
require_once 'Commons/Lang/IllegalArgumentException.php';
require_once 'Commons/Cols/Predicate.php';
require_once 'Commons/IO/Serializable.php';
/*
use Commons::Lang::Object;
use Commons::Lang::IllegalArgumentException';
use Commons::Cols::Predicate;
use Commons::IO::Serializable;
*/

/**
 * AndPredicate
 *
 *
 * @category   PHP
 * @package    Commons.Cols.Functors
 * @author     Yomei Komiya
 * @copyright  2008 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    Release: 1.0.1
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      Class available since Release 1.0.1
 */
class Commons_Cols_Functors_AndPredicate
	extends Commons_Lang_Object
	implements Commons_Cols_Predicate, Commons_IO_Serializable {

	private $iPredicate1 = null;
	
	private $iPredicate2 = null;
	
	
	/**
	 * Factory to create the predicate.
	 *
	 * @param Commons_Cols_Predicate $predicate1
	 * @param Commons_Cols_Predicate $predicate2
	 * @return Commons_Cols_Predicate
	 * @throws Commons_Lang_IllegalArgumentException if either predicate is null
	 */
	public static function getInstance(
		Commons_Cols_Predicate $predicate1, Commons_Cols_Predicate $predicate2) {
		
		if (is_null($predicate1) || is_null($predicate2)) {
			throw new Commons_Lang_IllegalArgumentException('Predicate must not be null');
		}
		
		return new self($predicate1, $predicate2);
	}


	/**
	 * Constructor
	 *
	 * @param Commons_Cols_Predicate $predicate1
	 * @param Commons_Cols_Predicate $predicate2
	 */
	public function Commons_Cols_Functors_AndPredicate(
		Commons_Cols_Predicate $predicate1, Commons_Cols_Predicate $predicate2) {
		
		parent::__construct();
		$this->iPredicate1 = $predicate1;
		$this->iPredicate2 = $predicate2;
	}
		
	
	public function __destruct() {
	}
	
	
	/**
	 * Evaluates the predicate returning true if both predicates return true.
	 *
	 * @param object $object
	 * @return bool true if both predicates return true.
	 */
	public function evaluate($object) {
		return
			($this->iPredicate1->evaluate($object)
			&& $this->iPredicate2->evaluate($object));
	}
	
	
	/**
	 * Gets predicates.
	 *
	 * @return array an array of two predicates.
	 */
	public function getPredicates() {
		return array($this->iPredicate1, $this->iPredicate2);
	}	

}

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * c-hanging-comment-ender-p: nil
 * End:
 */
?>