<?php
/* vim: set tabstop=4 shiftwidth=4: */

/*
 * Object (the root class of all classes)
 * (based on java.lang.Object)
 *
 *
 * PHP version 5
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   PHP
 * @package    Commons
 * @author     Yomei Komiya
 * @copyright  2007,2008 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    SVN: $Id: Object.php 122 2008-01-10 13:53:42Z whitestar $
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      File available since Release 0.8.0
 */

//namespace Commons::Lang;

require_once 'Commons/Lang/System.php';
require_once 'Commons/Lang/NoSuchFieldException.php';
require_once 'Commons/Lang/NoSuchMethodException.php';
/*
use Commons::Lang::System;
*/

/**
 * Object
 *
 *
 * @category   PHP
 * @package    Commons.Lang
 * @author     Yomei Komiya
 * @copyright  2007,2008 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    Release: 1.0.1
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      Class available since Release 0.8.0
 */
class Commons_Lang_Object {
//class Object {

	/**
	 * Container of properties.
	 *
	 * @var array
	 * @since 0.9.0
	 */
	private $_properties = array();
	
	
	/**
	 * Constructor
	 */
	public function Commons_Lang_Object() {
		// do nothing.
	}
	
	
	/**
	 * Destructor
	 */
	public function __destruct() {
		// do nothing.
	}
	
	
	/**
	 * Equality test.
	 * Default implementatio is object identity test.
	 *
	 * @param object $obj other object
	 * @return bool true if this object and the other object are the same instance.
	 */
	public function equals($obj) {
		return $this === $obj;
	}
	
	
	/**
	 * Returns object ID hash code.
	 * This return value is available on PHP 5.2.0 or later.
	 *
	 * @return string object hash code
	 */
	public function hashCode() {
		return Commons_Lang_System::identityHashCode($this);
	}
	
	
	/**
	 * Gets the property
	 *
	 * @param string $name the property name
	 * @return mixed value.
	 * @since 0.9.0
	 */
	protected function getProperty($name) {
		return isset($this->_properties[$name])
			? $this->_properties[$name]
			: null;
	}
	
	
	/**
	 * Sets the property
	 *
	 * @param string $name
	 * @param mixed $value
	 * @since 0.9.0
	 */
	protected function setProperty($name, $value) {
		$this->_properties[$name] = $value;
	}
	
	
	/**
	 * Gets all properties
	 *
	 * @return array
	 * @since 0.9.0
	 */
	protected function getProperties() {
		return $this->_properties;
	}


	/**
	 * Sets properties.
	 *
	 * @param array $properties
	 * @since 0.9.0
	 */
	protected function setProperties($properties) {
		$this->_properties = $properties;
	}
	
	
	/**
	 * Property getter definition utility.
	 *
	 * @param array $propNames
	 * @param name $name actual property name. 
	 * @return mixed value.
	 * @throws Commons_Lang_NoSuchFieldException
	 * @since 0.9.0
	 */
	protected function getter($propNames, $name) {
		if (in_array($name, $propNames, true)) {
			return isset($this->_properties[$name])
				? $this->_properties[$name]
				: null;
		}
		else {
			throw new Commons_Lang_NoSuchFieldException($name);
		}
	}
	
	
	/**
	 * Property setter definition utility.
	 *
	 * @param array $propNames
	 * @param name $name actual property name .
	 * @param mixed $value actual property value.
	 * @throws Commons_Lang_NoSuchFieldException
	 * @since 0.9.0
	 */
	protected function setter($propNames, $name, $value) {
		if (in_array($name, $propNames, true)) {
			$this->_properties[$name] = $value;
		}
		else {
			throw new Commons_Lang_NoSuchFieldException($name);
		}
	}
	
	
	/**
	 * Mix in modules. This method is used for the implementation of '__call' method. 
	 *
	 * @param array $modules mix-in modules.
	 * @param string $methodName method name.
	 * @param array $params parameters.
	 * @return mixed the return value of callback method.
	 * @throws Commons_Lang_NoSuchMethodException
	 * @since 0.9.0
	 */
	protected function mixin($modules, $methodName, $params) {
		foreach ($modules as $module) {
			if (method_exists($module, $methodName)) {
				return call_user_func_array(array($module, $methodName), $params);
			}
		}
		throw new Commons_Lang_NoSuchMethodException($methodName);
	}
	
	
	/**
	 * Gets the string representations of this object.
	 *
	 * @return string human recognized string representation
	 */
	public function __toString() {
		return get_class($this).'@'.$this->hashCode();
	}

}

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * c-hanging-comment-ender-p: nil
 * End:
 */
?>