<?php
/* vim: set tabstop=4 shiftwidth=4: */

/*
 * String
 *
 *
 * PHP version 5
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   PHP
 * @package    Commons
 * @author     Yomei Komiya
 * @copyright  2008 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    SVN: $Id: String.php 88 2008-01-03 13:44:29Z whitestar $
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      File available since Release 0.8.0
 */

//namespace Commons::Lang;

require_once 'Commons/IO/Serializable.php';
require_once 'Commons/Lang/Comparable.php';
require_once 'Commons/Lang/Object.php';
require_once 'Commons/Lang/StringIndexOutOfBoundsException.php';
require_once 'Commons/Lang/StringUtils.php';
/*
use Commons::IO::Serializable;
use Commons::Lang::Object;
use Commons::Lang::StringIndexOutOfBoundsException.php;
use Commons::Lang::StringUtils;
*/


/**
 * String
 * (EXPERIMENTAL, nonsense class?)
 *
 *
 * @category   PHP
 * @package    Commons.Lang
 * @author     Yomei Komiya
 * @copyright  2008 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    Release: 1.0.1
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      Class available since Release 0.8.0
 */
final class Commons_Lang_String extends Commons_Lang_Object
	implements Commons_IO_Serializable, Commons_Lang_Comparable {

	/**
	 * PHP embeded string value
	 *
	 * @var string
	 */
	private $_value;
	
	private $_count;
	
	private $_offset;
	
	
	/**
	 * Constructor
	 *
	 * @param string|Commons_Lang_String $str
	 */
	public function Commons_Lang_String($str = null) {
		if (is_null($str)) {
			$this->_value = '';
			$this->_offset = 0;
			$this->_count = 0;			
		}
		elseif ($str instanceof Commons_Lang_String) {
			$this->_value = $str->_value;
			$this->_offset = $str->_offset;
			$this->_count = $str->_count;
		}
		else {
			$this->_value = $str;
			$this->_offset = 0;
			$this->_count = Commons_Lang_StringUtils::strlen($str);
		}
	}
	
	
	public function __destruct() {
	}
	
	
	public function charAt($index) {
		if ($index < 0 || $index >= $this->_count) {
			throw new Commons_Lang_StringIndexOutOfBoundsException($index);
		}
		
		return Commons_Lang_StringUtils::charAt($this->_value, $this->_offset + $index);
	}
	
	
	public function equals($obj) {
		if (! ($obj instanceof Commons_Lang_String)) {
			return false;
		}
		
		$str = $obj;
		if ($this->_count !== $str->_count) {
			return false;
		}
		if ($this->_value === $str->_value && $this->_offset === $str->_offset) {
			return true;
		}
		$i = $this->_count;
		$x = $this->_offset;
		$y = $str->_offset;
		while (--$i >= 0) {
			if (Commons_Lang_StringUtils::charAt($this->_value, $x++)
				!== Commons_Lang_StringUtils::charAt($str->_value, $y++)) {
				return false;
			}
		}
	}

	
	public function compareTo($anotherString) {
		$i = Math.min($this->_count, $anotherString->_count);
		$x = $this->_offset;
		$y = $anotherString->_offset;
		while (--$i >= 0) {
			$result = ord(Commons_Lang_StringUtils::charAt($this->_value, $x++))
				- ord(Commons_Lang_StringUtils::charAt($str->_value, $y++));
			if ($result !== 0)
				return $result;
		}
		return $this->_count - $anotherString->_count;
	}
	
}

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * c-hanging-comment-ender-p: nil
 * End:
 */
?>