<?php
/* vim: set tabstop=4 shiftwidth=4: */

/*
 * System
 *
 *
 * PHP version 5
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   PHP
 * @package    Commons
 * @author     Yomei Komiya
 * @copyright  2007 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    SVN: $Id: System.php 170 2008-01-27 03:34:40Z whitestar $
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      File available since Release 0.8.0
 */

//namespace Commons::Lang;

require_once 'Commons/Lang/Object.php';

/**
 * System
 *
 *
 * @category   PHP
 * @package    Commons.Lang
 * @author     Yomei Komiya
 * @copyright  2007 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    Release: 1.0.1
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      Class available since Release 0.8.0
 */
final class Commons_Lang_System extends Commons_Lang_Object {

	/**
	 * Constructor
	 */
	private function Commons_Lang_System() {
	}
	
	
	/**
	 * Returns the object ID hash code
	 *
	 * @param object $object
	 * @return string The object's hash code
	 */
	public static function identityHashCode($object) {
		// PHP5 >= 5.2.0
		if (function_exists('spl_object_hash')) {
			return spl_object_hash($object);
		}
		else {
			return '<object hash: N/A>';
		}
	}

}

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * c-hanging-comment-ender-p: nil
 * End:
 */
?>