<?php
/* vim: set tabstop=4 shiftwidth=4: */

/*
 * Log Interface
 *
 *
 * PHP version 5
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   PHP
 * @package    Commons
 * @author     Yomei Komiya
 * @copyright  2008 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    SVN: $Id: Log.php 193 2008-02-03 06:38:35Z whitestar $
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      File available since Release 0.9.0
 */

//namespace Commons::Logging;

/**
 * Log
 *
 *
 * @category   PHP
 * @package    Commons.Logging
 * @author     Yomei Komiya
 * @copyright  2008 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    Release: 1.0.1
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      Class available since Release 0.9.0
 */
interface Commons_Logging_Log {

	/**
	 * Tests whether debug log is enabled or not.
	 * 
	 * @return bool
	 */
	public function isDebugEnabled();
	
	/**
	 * Tests whether error log is enabled or not.
	 * 
	 * @return bool
	 */
	public function isErrorEnabled();
	
	/**
	 * Tests whether fatal log is enabled or not.
	 * 
	 * @return bool
	 */
	public function isFatalEnabled();
	
	/**
	 * Tests whether info log is enabled or not.
	 * 
	 * @return bool
	 */
	public function isInfoEnabled();
	
	/**
	 * Tests whether trace log is enabled or not.
	 * 
	 * @return bool
	 */
	public function isTraceEnabled();
	
	/**
	 * Tests whether warn log is enabled or not.
	 * 
	 * @return bool
	 */
	public function isWarnEnabled();
	
	/**
	 * Logs a message with trace level.
	 *
	 * @param mixed $message string castable message.
	 * @param Exception $e
	 */
	public function trace($message, $e = null);
	
	/**
	 * Logs a message with debug level.
	 *
	 * @param mixed $message string castable message.
	 * @param Exception $e
	 */
	public function debug($message, $e = null);
	
	/**
	 * Logs a message with info level.
	 *
	 * @param mixed $message string castable message.
	 * @param Exception $e
	 */
	public function info($message, $e = null);
	
	/**
	 * Logs a message with warn level.
	 *
	 * @param mixed $message string castable message.
	 * @param Exception $e
	 */
	public function warn($message, $e = null);
	
	/**
	 * Logs a message with error level.
	 *
	 * @param mixed $message string castable message.
	 * @param Exception $e
	 */
	public function error($message, $e = null);
	
	/**
	 * Logs a message with fatal level.
	 *
	 * @param mixed $message string castable message.
	 * @param Exception $e
	 */
	public function fatal($message, $e = null);
	
	/**
	 * Logs a message with trace level.
	 *
	 * @param mixed $message string castable message.
	 * @param Exception $e
	 */
	public function shutdown();
	
}

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * c-hanging-comment-ender-p: nil
 * End:
 */
?>