<?php
/* vim: set tabstop=4 shiftwidth=4: */

/*
 * Smarty Engine Component
 *
 *
 * PHP version 5
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   PHP
 * @package    Commons.S2Container
 * @author     Yomei Komiya
 * @copyright  2008 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    SVN: $Id: SmartyEngine.php 268 2008-03-24 15:01:00Z whitestar $
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      File available since Release 1.0.1
 */

//namespace Commons::S2Container;

// for non-PEAR-package Smarty (e.g. the original Smarty, phing's built-in Smarty)
if (!class_exists('Smarty', false)) {
	require 'Smarty/Smarty.class.php';
}

/**
 * SmartyEngine
 *
 *
 * @category   PHP
 * @package    Commons.S2Container
 * @author     Yomei Komiya
 * @copyright  2008 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    Release: 1.0.1
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      Class available since Release 1.0.1
 */
class Commons_S2Container_SmartyEngine extends Smarty {

	public function Commons_S2Container_SmartyEngine() {
		parent::__construct();
	}
	
	
	public function __destruct() {
	}
	
	
	/**
	 * Gets the template directory path.
	 *
	 * @return string path string.
	 */
	public function getTemplateDir() {
		return $this->template_dir; 
	}

	
	/**
	 * Sets the template directory path.
	 *
	 * @param string $dir path string.
	 */
	public function setTemplateDir($dir = 'templates') {
		$this->template_dir = $dir; 
	}
	

	/**
	 * Gets the compiled file directory path.
	 *
	 * @return string path string.
	 */
	public function getCompileDir() {
		return $this->compile_dir; 
	}

	
	/**
	 * Sets the compiled file directory path.
	 *
	 * @param string $dir path string.
	 */
	public function setCompileDir($dir = 'templates_c') {
		$this->compile_dir = $dir; 
	}

	
	/**
	 * Gets the configuration directory path.
	 *
	 * @return string path string.
	 */
	public function getConfigDir() {
		return $this->config_dir; 
	}

	
	/**
	 * Sets the configuration directory path.
	 *
	 * @param string $dir path string.
	 */
	public function setConfigDir($dir = 'configs') {
		$this->config_dir = $dir; 
	}
	
	
	/**
	 * Gets the cache directory path.
	 *
	 * @return string path string.
	 */
	public function getCacheDir() {
		return $this->cache_dir; 
	}

	
	/**
	 * Sets the cache directory path.
	 *
	 * @param string $dir path string.
	 */
	public function setCacheDir($dir = 'cache') {
		$this->cache_dir = $dir; 
	}

	
	/**
	 * Whether the caching is on or not.
	 *
	 * @return int
     * <ul>
     *   <li>0 = no caching</li>
     *   <li>1 = use class cache_lifetime value</li>
     *   <li>2 = use cache_lifetime in cache file</li>
     * </ul>
	 */
	public function isCaching() {
		return $this->caching; 
	}

	
	/**
	 * Sets the caching.
	 *
	 * @param int $caching
     * <ul>
     *   <li>0 = no caching</li>
     *   <li>1 = use class cache_lifetime value</li>
     *   <li>2 = use cache_lifetime in cache file</li>
     * </ul>
	 */
	public function setCaching($caching = 0) {
		$this->caching = $caching; 
	}
	
	
	/**
	 * Gets plugins directories
	 *
	 * @return array directory paths.
	 */
	public function getPluginsDirs() {
		return $this->plugins_dir;
	}
	
	
	/**
	 * Adds plugins directory
	 *
	 * @param string $dir path string.
	 */
	public function addPluginsDir($dir) {
		$this->plugins_dir[] = $dir;
	}

	
	/**
	 * Returns whether the debugging is on or not.
	 *
	 * @return bool
	 */
	public function isDebugging() {
		return $this->debugging;
	}
	
	
	/**
	 * Sets the debugging option.
	 *
	 * @param bool $debugging
	 */
	public function setDebugging($debugging) {
		$this->debugging = $debugging;
	}
	
	
	public function getErrorReporting() {
		return $this->error_reporting;
	}
	
	
	public function setErrorReporting($errorReporting = null) {
		$this->error_reporting = $errorReporting;
	}
	
	
	/**
	 * Gets the debug template.
	 *
	 * @return string
	 */
	public function getDebugTpl() {
		return $this->debug_tpl;
	}
	
	
	/**
	 * Sets the debug template.
	 *
	 * @param string $template template file name.
	 */
	public function setDebugTpl($template = '') {
		$this->debug_tpl = $template;
	}
	
	
	/**
	 * Gets the debugging control method.
	 *
	 * @return string 
	 */
	public function getDebuggingCtrl() {
		return $this->debugging_ctrl;
	}
	
	
	/**
	 * Sets the debugging control.
	 *
	 * @param string $ctrl control method. 
     * <ul>
     *   <li>NONE => no debugging control allowed</li>
     *   <li>URL => enable debugging when SM ARTY_DEBUG is found in the URL.</li>
     * </ul>
     * http://www.example.com/index.php?SMARTY_DEBUG
	 */
	public function setDebuggingCtrl($ctrl = 'NONE') {
		$this->debugging_ctrl = $ctrl;
	}
	
	
	/**
	 * Returns whether to check for recompiling or not.
	 *
	 * @return bool
	 */
	public function isCompileCheck() {
		return $this->compile_check;
	}
	
	
	/**
	 * Sets the recompiling check.
	 *
	 * @param bool $check
	 */
	public function setCompileCheck($check = true) {
		$this->compile_check = $check;
	}

	
	/**
	 * Returns whether to compile templates every time or not.
	 *
	 * @return bool
	 */
	public function isForceCompile() {
		return $this->force_compile;
	}
	
	
	/**
	 * Sets the every-time compiling.
	 *
	 * @param bool $compile
	 */
	public function setForceCompile($compile = false) {
		$this->force_compile = $compile;
	}
	
}

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * c-hanging-comment-ender-p: nil
 * End:
 */
?>
