<?php
/* vim: set tabstop=4 shiftwidth=4: */

/*
 * PHPUnit Utilities
 * 
 *
 * PHP version 5
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   PHP
 * @package    Commons
 * @author     Yomei Komiya
 * @copyright  2007,2008 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    SVN: $Id: PHPUnitUtils.php 156 2008-01-20 13:03:34Z whitestar $
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      File available since Release 0.8.0
 */

//namespace Commons::Test;

require_once 'Commons/Lang/IllegalArgumentException.php';
require_once 'Commons/Test/TestUtils.php';

/**
 * PHPUnitUtils
 *
 *
 * @category   PHP
 * @package    Commons.Test
 * @author     Yomei Komiya
 * @copyright  2007,2008 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    Release: 1.0.1
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      Class available since Release 0.8.0
 */
class Commons_Test_PHPUnitUtils {
	
	private static $_instance = null;
	
	
	public static function getInstance() {
		if (is_null(self::$_instance)) {
			self::$_instance = new self();
		}
		
		return self::$_instance;
	}
	
	
	/**
	 * Runs the test suite's main method
	 * if its method is able to be defined by 'PHPUnit_MAIN_METHOD'. 
	 *
	 * @param string $mainMethodName
	 */
	public static function run($mainMethodName) {
		self::defineMainMethod($mainMethodName);
		self::executeMainMethod($mainMethodName);
	}
	
	
	/**
	 * Defines test suite's main method.
	 *
	 * @param string $mainMethodName
	 */
	public static function defineMainMethod($mainMethodName) {
		if (!defined('PHPUnit_MAIN_METHOD')) {
			define('PHPUnit_MAIN_METHOD', $mainMethodName);
		}
	}
	
	
	/**
	 * Executes test suite's main method.
	 *
	 * @param string $mainMethodName
	 */
	public static function executeMainMethod($mainMethodName) {
		if (PHPUnit_MAIN_METHOD === $mainMethodName) {
			eval(PHPUnit_MAIN_METHOD . '();');
		}
	}
	
	
	/**
	 * Tests whether runkit is available or not.
	 *
	 * @return bool true if runkit is available.
	 * @since 0.9.0
	 */
	public static function isRunkitEnabled() {
		return Commons_Test_TestUtils::isRunkitEnabled();
	}
	
	
	/**
	 * Invokes an invisible method.
	 *
	 * @param object $obj target object.
	 * @param string $methodName target private or protected method name
	 * @param array $params parameters
	 * @return mixed return value of the target method's invocation.
	 * @throws Commons_Lang_IllegalArgumentException
	 * @since 0.9.0
	 */
	public static function invokeInvisibleMethod($obj, $methodName, $params) {
		return Commons_Test_TestUtils::invokeInvisibleMethod($obj, $methodName, $params);
	}
	
}

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * c-hanging-comment-ender-p: nil
 * End:
 */
?>