<?php
/* vim: set tabstop=4 shiftwidth=4: */

/*
 * Comparable Comparator
 * (based on org.apache.commons.collections.comparators.ComparableComparator)
 * 
 *
 * PHP version 5
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   PHP
 * @package    Commons
 * @author     Yomei Komiya
 * @copyright  2007 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    SVN: $Id: ComparableComparator.php 95 2008-01-04 08:52:52Z whitestar $
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      File available since Release 0.8.0
 */

//namespace Commons::Cols::Comps;

require_once 'Commons/Lang/Object.php';
require_once 'Commons/Lang/ClassCastException.php';
require_once 'Commons/Lang/Comparable.php';
require_once 'Commons/IO/Serializable.php';
require_once 'Commons/Util/Comparator.php';
/*
use Commons::Lang::Object;
use Commons::Lang::ClassCastException;
use Commons::Lang::Comparable;
use Commons::IO::Serializable;
use Commons::Util::Comparator;
*/

/**
 * ComparableComparator
 *
 *
 * @category   PHP
 * @package    Commons.Cols.Comps
 * @author     Yomei Komiya
 * @copyright  2007 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    Release: 1.0.2
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      Class available since Release 0.8.0
 */
class Commons_Cols_Comps_ComparableComparator
	extends Commons_Lang_Object
	implements Commons_Util_Comparator, Commons_IO_Serializable { 
//class ComparableComparator extends Object implements Comparator, Serializable {
	
	/**
	 * Singleton instance
	 *
	 * @var Commons_Cols_Comps_ComparableComparator
	 */
	private static $_instance = null;
	
	
	/**
	 * Constructer
	 */
	private function Commons_Cols_Comps_ComparableComparator() {
		// do nothing.
	}
	
	
	public function __clone() {
		trigger_error('Clone is not allowed.', E_USER_ERROR);
	}
	
	
	/**
	 * Gets singleton instance
	 *
	 * @return Commons_Cols_Comps_ComparableComparator
	 */
	public static function getInstance() {
		if (is_null(self::$_instance)) {
			self::$_instance = new self();
		}
		
		return self::$_instance;
	}
	
	
	/**
	 * Compare two objects
	 *
	 * @param object $o1 the left hand side object
	 * @param object $o2 the right hand side object
	 * @return int comparison
	 * @throws Commons_Lang_ClassCastExcption if the one object is not comparable to the other. 
	 */
	public function compare($o1, $o2) {
		if (is_null($o1) || is_null($o2)) {
			throw new Commons_Lang_ClassCastException(
					'There were nulls in the arguments for this method: '
					. 'compare(' . $o1 . ', ' . $o2 . ')'
				);
		}
		
		if ($o1 instanceof Commons_Lang_Comparable) {
			if ($o2 instanceof Commons_Lang_Comparable) {
				$result1 = $o1->compareTo($o2);
				$result2 = $o2->compareTo($o1);

				// enforce comparable contract
				if ($result1 === 0 && $result2 === 0) {
					return 0;
				}
				elseif ($result1 < 0 && $result2 > 0) {
					return $result1;
				}
				elseif ($result1 > 0 && $result2 < 0) {
					return $result1;
				}
				else {
					// results inconsistent
					throw new Commons_Lang_ClassCastException('$o1 not comparable to $o2');
				}
			}
			else {
				// $o2 wasn't comparable
				throw new Commons_Lang_ClassCastException(
						'The first argument of this method was not a Comparable: '
						. get_class($o2)
					);
			}
		}
		elseif ($o2 instanceof Commons_Lang_Comparable) {
			// $o1 wasn't comparable
			throw new Commons_Lang_ClassCastException(
					'The second argument of this method was not a Comparable: '
					. get_class($o1)
				);
		}
		else {
			// neither were comparable
			throw new Commons_Lang_ClassCastException(
					'Both arguments of this method were not Comparables: '
					. get_class($o1) . ' and ' . get_class($o2)
				);
		}
	}
		
}

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * c-hanging-comment-ender-p: nil
 * End:
 */
?>