<?php
/* vim: set tabstop=4 shiftwidth=4: */

/*
 * Instance of Predicate
 * (based on org.apache.commons.collections.functors.InstanceOfPredicate)
 *
 *
 * PHP version 5
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   PHP
 * @package    Commons
 * @author     Yomei Komiya
 * @copyright  2008 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    SVN: $Id: InstanceOfPredicate.php 278 2008-03-30 12:58:12Z whitestar $
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      File available since Release 1.0.1
 */

//namespace Commons::Cols::Functors;

require_once 'Commons/Lang/Object.php';
require_once 'Commons/Cols/Predicate.php';
require_once 'Commons/IO/Serializable.php';
/*
use Commons::Lang::Object;
use Commons::Cols::Predicate;
use Commons::IO::Serializable;
*/

/**
 * InstanceOfPredicate
 *
 *
 * @category   PHP
 * @package    Commons.Cols.Functors
 * @author     Yomei Komiya
 * @copyright  2008 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    Release: 1.0.2
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      Class available since Release 1.0.1
 */
final class Commons_Cols_Functors_InstanceOfPredicate
	extends Commons_Lang_Object
	implements Commons_Cols_Predicate, Commons_IO_Serializable {

	/**
	 * The type to compare to
	 *
	 * @var ReflectionClass
	 */
	private $iType = null;
	
	
	/**
	 * Factory method to create the InstanceOf predicate.
	 *
	 * @param ReflectionClass $type
	 * @return Commons_Cols_Predicate
	 */
	public static function getInstance(ReflectionClass $type) {
		if (is_null($type)) {
			throw new IllegalArgumentException(
				'The type to check instanceof must not be null');
		}
		
		return new self($type);
	}
	
	
	/**
	 * Constructor
	 *
	 * @param ReflectionClass $type
	 */
	public function Commons_Cols_Functors_InstanceOfPredicate(ReflectionClass $type) {
		parent::__construct();
		$this->iType = $type;
	}
	
	
	public function __destruct() {
	}
	
	
	/**
	 * Evaluates the predicate.
	 *
	 * @param object $object
	 * @return bool
	 */
	public function evaluate($object) {
		return ($this->iType->isInstance($object));
	}

	
	/**
	 * Gets the type.
	 *
	 * @return ReflectionClass
	 */
	public function getType() {
		return $this->iType;
	}
	
}

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * c-hanging-comment-ender-p: nil
 * End:
 */
?>