<?php
/* vim: set tabstop=4 shiftwidth=4: */

/*
 * Class Loader
 *
 *
 * PHP version 5
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   PHP
 * @package    Commons
 * @author     Yomei Komiya
 * @copyright  2007 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    SVN: $Id: ClassLoader.php 269 2008-03-27 14:26:58Z whitestar $
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      File available since Release 0.8.0
 */

//namespace Commons::Lang;

require_once 'Commons/Lang/Object.php';
require_once 'Commons/Lang/ClassNotFoundException.php';
require_once 'Commons/Lang/SystemUtils.php';
/*
use Commons::Lang::Object;
use Commons::Lang::ClassNotFoundException;
use Commons::Lang::SystemUtils;
*/

/**
 * Common ClassLoader
 *
 *
 * @category   PHP
 * @package    Commons.Lang
 * @author     Yomei Komiya
 * @copyright  2007 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    Release: 1.0.2
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      Class available since Release 0.8.0
 */
abstract class Commons_Lang_ClassLoader extends Commons_Lang_Object {
//class ClassLoader extends Object {
	
	/**
	 * Loads the class definition file
	 * 
	 * @param string $className
	 * @return mixed The return value of include_once.
	 * @throws Commons_Lang_ClassNotFoundException
	 */
	public static function load($className) {
		$ret = include_once str_replace('_', '/', $className) . '.php';
		if ($ret === false) {
			throw new Commons_Lang_ClassNotFoundException($className . ' not found.');
		}
		else {
			return $ret;
		}
	}
	
	
	/**
	 * Gets PEAR home full path
	 * 
	 * @return mixed PEAR home full path or null if no PEAR is installed.
	 * @since 1.0.0
	 */
	public static function getPEARHome() {
		$path = self::getResource('PEAR.php');
		if (!is_null($path)) {
			return dirname($path);
		}
		else {
			return null;
		}
	}
	
	
	/**
	 * Gets resource full path.
	 * 
	 * @param string $name resource name (path)
	 * @return mixed resource full path or null if no resource exists.
	 */
	public static function getResource($name) {
		if (is_null($name) || $name === '') {
			return null;
		}
		
		$fileSeparator = Commons_Lang_SystemUtils::getFileSeparator();
		$name = str_replace('/', $fileSeparator, $name);
		$pathSeparator = Commons_Lang_SystemUtils::getPathSeparator();
		$includePaths = explode($pathSeparator, get_include_path());
		foreach ($includePaths as $includePath) {
			$includePath = realpath($includePath);
			$fullPath = $includePath . $fileSeparator . $name;
			if (file_exists($fullPath)) {
				return $fullPath;
			}
		}
		return null;
	}
	
	
	public function __toString() {
		return parent::__toString();
	}

}

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * c-hanging-comment-ender-p: nil
 * End:
 */
?>