<?php
/* vim: set tabstop=4 shiftwidth=4: */

/*
 * Standard Error
 *
 *
 * PHP version 5
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   PHP
 * @package    Commons
 * @author     Yomei Komiya
 * @copyright  2008 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    SVN: $Id: StdErr.php 171 2008-01-27 03:57:32Z whitestar $
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      File available since Release 0.9.0
 */

//namespace Commons::Lang;

require_once 'Commons/Lang/Object.php';
require_once 'Commons/Lang/SystemUtils.php';
/*
use Commons::Lang::Object;
use Commons::Lang::SystemUtils;
*/

/**
 * StdErr
 *
 *
 * @category   PHP
 * @package    Commons.Lang
 * @author     Yomei Komiya
 * @copyright  2008 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    Release: 1.0.2
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      Class available since Release 0.9.0
 */
final class Commons_Lang_StdErr extends Commons_Lang_Object {

	/**
	 * Standard Error Stream
	 *
	 * @var stream
	 */
	private static $err = false;
	
	
	private function Commons_Lang_StdErr() {
		parent::__construct();
	}
	
	
	public function __destruct() {
	}

	
	public static function init() {
		if (self::$err === false) {
			self::$err = fopen('php://stderr', 'a');
		}
	}
	
	
	public static function printr($message) {
		self::init();
		fwrite(self::$err, (string)$message);
	}
	
	
	public static function println($message) {
		self::printr((string)$message . Commons_Lang_SystemUtils::getLineSeparator());
	}
	
	
	public static function flush() {
		if (self::$err !== false) {
			fflush(self::$err);
		}
	}
	
	
	public static function close() {
		// do nothing.
	}
	
	
	public static function getPrintStream() {
		return fopen('php://stderr', 'a');
	}
	
}

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * c-hanging-comment-ender-p: nil
 * End:
 */
?>