<?php
/* vim: set tabstop=4 shiftwidth=4: */

/*
 * No Operation Logger
 *
 *
 * PHP version 5
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   PHP
 * @package    Commons
 * @author     Yomei Komiya
 * @copyright  2008 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    SVN: $Id: NoOpLog.php 193 2008-02-03 06:38:35Z whitestar $
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      File available since Release 0.9.0
 */

//namespace Commons::Logging::Impl;

require_once 'Commons/Lang/Object.php';
require_once 'Commons/IO/Serializable.php';
require_once 'Commons/Logging/Log.php';
/*
use Commons::Lang::Object;
use Commons::IO::Serializable;
use Commons::Logging::Log;
*/

/**
 * NoOpLog
 *
 *
 * @category   PHP
 * @package    Commons.Logging.Impl
 * @author     Yomei Komiya
 * @copyright  2008 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    Release: 1.0.2
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      Class available since Release 0.9.0
 */
class Commons_Logging_Impl_NoOpLog extends Commons_Lang_Object
	implements Commons_Logging_Log, Commons_IO_Serializable {


	public function Commons_Logging_Impl_NoOpLog($name = null) {
		// do nothing.
	}
	
	
	public function __destruct() {
		// do nothing.
	}

	
	public function trace($message, $e = null) {
		// do nothing.
	}
	
	
	public function debug($message, $e = null) {
		// do nothing.
	}
	
	
	public function info($message, $e = null) {
		// do nothing.
	}
	
	
	public function warn($message, $e = null) {
		// do nothing.
	}
	
	
	public function error($message, $e = null) {
		// do nothing.
	}
	
	
	public function fatal($message, $e = null) {
		// do nothing.
	}
	
	
	public function isTraceEnabled() {
		return false;
	}
	
	
	public function isDebugEnabled() {
		return false;
	}

	
	public function isInfoEnabled() {
		return false;
	}
	
	
	public function isWarnEnabled() {
		return false;
	}
	
	
	public function isErrorEnabled() {
		return false;
	}
	
	
	public function isFatalEnabled() {
		return false;
	}

	
	public function shutdown() {
		// do nothing.
	}
	
}

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * c-hanging-comment-ender-p: nil
 * End:
 */
?>