<?php
/* vim: set tabstop=4 shiftwidth=4: */

/*
 * PEAR Log Composite Logger
 *
 *
 * PHP version 5
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   PHP
 * @package    Commons
 * @author     Yomei Komiya
 * @copyright  2008 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    SVN: $Id: PEARLogCompositeLogger.php 158 2008-01-21 14:02:57Z whitestar $
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      File available since Release 0.9.0
 */

//namespace Commons::Logging::Impl;

require_once 'Log.php';
require_once 'Log/composite.php';
/*
use Log;
use Log::composite;
*/

/**
 * PEARLogCompositeLogger
 * 
 * This composite logger controls all the childs log output
 * unlike the original Log_composite.
 *
 * @category   PHP
 * @package    Commons.Logging.Impl
 * @author     Yomei Komiya
 * @copyright  2008 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    Release: 1.0.2
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      Class available since Release 0.9.0
 */
class Commons_Logging_Impl_PEARLogCompositeLogger extends Log_composite {
	
	/**
	 * Composite loggers, identity-based singleton.
	 *
	 * @var array
	 */
	private static $_instances = array();
	

	/**
	 * Private Constructor
	 *
	 * @param string $ident
	 * @param array $conf
	 * @param int $level
	 */
	private function Commons_Logging_Impl_PEARLogCompositeLogger(
		$ident, $conf = array(), $level = PEAR_LOG_DEBUG) {

		parent::__construct('', $ident, $conf, $level);
		
		$this->_id = md5(microtime());
		$this->_ident = $ident;
		// set priority level mask.
		$this->_mask = Log::UPTO($level);
	}
	
	
	public function __destruct() {
	}
	
	
	/**
	 * Gets composite logger.
	 *
	 * @param string $ident
	 * @param array $conf
	 * @param int $level
	 */
	public static function getInstance($ident, $conf = array(), $level = PEAR_LOG_DEBUG) {
		if (!isset(self::$_instances[$ident])) {
			self::$_instances[$ident]
				= new Commons_Logging_Impl_PEARLogCompositeLogger($ident, $conf, $level);
		}
		
		return self::$_instances[$ident];
	}
	
	
	public function log($message, $priority = null) {
		// check the priority.
		if ($this->_isMasked($priority)) {
			// call childs' log method. 
			return parent::log($message, $priority);
		}
		else {
			return false;
		}
	}

}

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * c-hanging-comment-ender-p: nil
 * End:
 */
?>