<?php
/* vim: set tabstop=4 shiftwidth=4: */

/*
 * Log Factory
 *
 *
 * PHP version 5
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   PHP
 * @package    Commons
 * @author     Yomei Komiya
 * @copyright  2008 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    SVN: $Id: LogFactory.php 301 2008-06-28 11:40:53Z whitestar $
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      File available since Release 0.9.0
 */

//namespace Commons::Logging;

require_once 'Commons/Lang/Object.php';
require_once 'Commons/Lang/ClassLoader.php';
require_once 'Commons/Logging/Log.php';
require_once 'Commons/Logging/LogConfigurationException.php';
require_once 'Commons/Util/Properties.php';
/*
use Commons::Lang::Object;
use Commons::Lang::ClassLoader;
use Commons::Logging::Log;
use Commons::Logging::LogConfigurationException;
use Commons::Util::Properties;
*/

/**
 * LogFactory
 *
 *
 * @category   PHP
 * @package    Commons.Logging
 * @author     Yomei Komiya
 * @copyright  2008 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    Release: 1.0.2
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      Class available since Release 0.9.0
 */
abstract class Commons_Logging_LogFactory extends Commons_Lang_Object {
	
	/**
	 * Commons_Logging_LogFactory property name.
	 */
	const FACTORY_PROPERTY = 'commons.logging.LogFactory';
	
	/**
	 * Default implementation class name of Commons_Logging_LogFactory.
	 */
	const FACTORY_DEFAULT = 'Commons_Logging_Impl_LogFactoryImpl';
	
	/**
	 * Default properties file (relative path on include_path)
	 */
	const FACTORY_PROPERTIES = 'commons-logging.properties';
	
	
	/**
	 * Constructor
	 */
	protected function Commons_Logging_LogFactory() {
		// do nothing.
	}
	
	
	public function __destruct() {
	}
	
	// Subclass implementation methods.
	public abstract function getAttribute($name);
	
	public abstract function getAttributeNames();
	
	public abstract function getInstance($name);
	
	public abstract function release();
	
	public abstract function removeAttribute($name);
	
	public abstract function setAttribute($name, $value);
	
	
	/**
	 * Cached factories.
	 *
	 * @var array
	 */
	protected static $factories = array();
	
	
	/**
	 * Gets Commons_Logging_LogFactory instance.
	 *
	 * @return Commons_Logging_LogFactory
	 * @throws Commons_Logging_LogConfigurationException if the implementation class is not
	 *         available or cannot be instantiated.
	 */
	public static function getFactory() {
		$factory = null;
		
		$factory = self::getCachedFactory();
		if (!is_null($factory)) {
			return $factory;
		}
				
		$props = null;
		$stream = @fopen(self::FACTORY_PROPERTIES, 'r', true);
		if ($stream !== false) {
			$props = new Commons_Util_Properties();
			$props->load($stream);
			fclose($stream);
		}
		
		// 1st, try the system property
		$factoryClass = ini_get(self::FACTORY_PROPERTY);
		if ($factoryClass !== '') {
			$factory = self::newFactory($factoryClass);
		}
		
		// 2nd try a properties file.
		if (is_null($factory) && !is_null($props)) {
			$factoryClass = $props->getProperty(self::FACTORY_PROPERTY);
			if (!is_null($factoryClass)) {
				$factory = self::newFactory($factoryClass);
			}
		}

		// 3rd, try the fallback implementation class
		if (is_null($factory)) {
			$factory = self::newFactory(self::FACTORY_DEFAULT);
		}		
		
		// cache the factory
		if (!is_null($factory)) {
			self::cacheFactory($factory);
			
			if(!is_null($props)) {
				$names = $props->propertyNames();
				foreach ($names as $name) {
					$factory->setAttribute($name, $props->getProperty($name));
				}
			}
		}
		
		return $factory;
	}
	
	
	public static function getLog($name) {
		return self::getFactory()->getInstance($name);
	}
	
	
	/**
	 * Obtains cached factory.
	 *
	 * @return Commons_Logging_LogFactory factory or null;
	 */
	private static function getCachedFactory() {
		if (isset(self::$factories['defaultKey'])) {
			return self::$factories['defaultKey'];
		}
		else {
			return null;
		}
	}
	
	
	/**
	 * Caches log factory instance.
	 *
	 * @param Commons_Logging_LogFactory $factory factory instance.
	 */
	private static function cacheFactory($factory) {
		if (!is_null($factory)) {
			self::$factories['defaultKey'] = $factory;
		}
	}
	
	
	/**
	 * Creates and returns new Commons_Logging_LogFactory instance.
	 *
	 * @param string $factoryClass class name.
	 * @return Commons_Logging_LogFactory factory instance.
	 * @throws Commons_Logging_LogConfigurationException
	 */
	protected static function newFactory($factoryClass) {
		try {
			Commons_Lang_ClassLoader::load($factoryClass);
			$logFactoryClass = new ReflectionClass($factoryClass);
			return $logFactoryClass->newInstance();
		}
		catch (Commons_Lang_ClassNotFoundException $cnfe) {
			throw new Commons_Logging_LogConfigurationException($cnfe->getMessage());
		}
		catch (Exception $e) {
			throw new Commons_Logging_LogConfigurationException($e->getMessage());
		}
	}
	
}

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * c-hanging-comment-ender-p: nil
 * End:
 */
?>