<?php
/* vim: set tabstop=4 shiftwidth=4: */

/*
 * Build Number Phing Task
 *
 *
 * PHP version 5
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   PHP
 * @package    Commons
 * @author     Yomei Komiya
 * @copyright  2008 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    SVN: $Id: BuildNumberTask.php 296 2008-04-17 13:07:20Z whitestar $
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      File available since Release 1.0.2
 */

//namespace Commons::Phing::Tasks::Ext;

require_once 'phing/BuildException.php';
require_once 'phing/Task.php';
require_once 'phing/Project.php';
require_once 'phing/system/io/PhingFile.php';

require_once 'Commons/Util/Properties.php';
/*
use phing::BuildException;
use phing::Task;
use phing::Project;
use phing::system::io::PhingFile;
use Commons::Util::Properties;
*/

/**
 * BuildNumberTask
 *
 *
 * @category   PHP
 * @package    Commons.Phing.Tasks.Ext
 * @author     Yomei Komiya
 * @copyright  2008 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    Release: 1.0.2
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      Class available since Release 1.0.2
 */
class BuildNumberTask extends Task {

	const DEFAULT_PROPERTY_NAME = 'build.number';
	
	/** file name */
	private $file = self::DEFAULT_PROPERTY_NAME;
	
	
	/**
	 * increment build number.
	 *
	 * @throws BuildException if file is somehow invalid, or creation failed.
	 */
	public function main() {
		$buildNumber = 0;
		$filePath = null;
		
		if (is_null($this->file)) {
			$this->file = self::DEFAULT_PROPERTY_NAME;
		}
		$filePath = $this->file->getAbsolutePath();
		
		if ($this->file->isDirectory()) {
			throw new BuildException(
				'Unable to create file as a directory already exists with that name: '
				. $filePath);
		}
		if ($this->file->exists()) {
			$buildNumber = $this->getBuildNumber($this->loadProperties());
			$buildNumber++;
			$this->writeProperties($buildNumber);
		}
		else {
			$buildNumber = 0;
			$result = $this->file->createNewFile(true, 0755);
			if ($result) {
				$this->writeProperties($buildNumber);
			}
			else {
				$msg = 'File ' . $filePath
					. ' creation was not successful for an unknown reason';
				throw new BuildException($msg, $this->location);
			}
		}
		
		$this->getProject()->setNewProperty(self::DEFAULT_PROPERTY_NAME, (string)$buildNumber);
		$this->log('Build number: ' . $buildNumber . ' (in ' . $filePath . ')');
	}


	private function getBuildNumber(Commons_Util_Properties $properties) {
		$buildNumber = trim($properties->getProperty(self::DEFAULT_PROPERTY_NAME, '0'));
		if (is_numeric($buildNumber)) {
			return (int)$buildNumber;
		}
		else {
			$message = $this->file->getAbsolutePath()
				. ' contains a non integer build number: ' . $buildNumber;
				
			throw new BuildException($message, $this->location);
		}
	}
	
	
	private function loadProperties() {
		$inStream = fopen($this->file->getAbsolutePath(), 'r');
		$props = new Commons_Util_Properties();
		$props->load($inStream);
		if ($inStream) {
			fclose($inStream);
		}
		
		return $props;
	}
	
	
	private function writeProperties($buildNumber) {
		$header =
			"#Build Number for PHING. Do not edit!\n"
			. '#' . date('r') . "\n";
		
		$fp = fopen($this->file->getAbsolutePath(), 'w');
		fwrite($fp,
			$header
			. self::DEFAULT_PROPERTY_NAME . '=' . $buildNumber . "\n");
		fclose($fp);
	}
	
	
	/** the directory to create; required. */
	public function setFile(PhingFile $file) {
		$this->file = $file;
	}

}

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * c-hanging-comment-ender-p: nil
 * End:
 */
?>