<?php
/* vim: set tabstop=4 shiftwidth=4: */

/*
 * Extended S2Container Factory
 *
 *
 * PHP version 5
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   PHP
 * @package    Commons.S2Container
 * @author     Yomei Komiya
 * @copyright  2008 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    SVN: $Id: SmartyEngine.php 268 2008-03-24 15:01:00Z whitestar $
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      File available since Release 1.0.2
 */

//namespace Commons::S2Container;

require_once 'S2Container/S2Container.php';
require_once 'S2ContainerSplAutoLoad.php';

require_once 'Commons/Lang/ClassLoader.php';

/**
 * ExtendedS2ContainerFactory
 *
 *
 * @category   PHP
 * @package    Commons.S2Container
 * @author     Yomei Komiya
 * @copyright  2008 the original author or authors.
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 * @version    Release: 1.0.2
 * @link       http://phpcommons.sourceforge.jp/
 * @see        
 * @since      Class available since Release 1.0.2
 */
class Commons_S2Container_ExtendedS2ContainerFactory {

	/**
	 * Creates S2Container object from dicon's full path.
	 * 
	 * @param string $diconFullPath dicon file's full path.
	 * @return S2Container object.
	 */
	public static function createFromDicon($diconFullPath) {
		return S2ContainerFactory::create($diconFullPath);
	}
	
	
	/**
	 * Creates S2Container object from dicon's resource name (path).
	 *
	 * @param string $diconResourceName dicon resource name (path) on include_path.
	 * @return S2Container object.
	 */
	public static function createFromDiconOnIncludePath($diconResourceName) {
		$diconFullPath = Commons_Lang_ClassLoader::getResource($diconResourceName);
		
		return self::createFromDicon($diconFullPath);
	}
	
	
	/**
	 * Includes a child S2Container from dicon's full path.
	 *
	 * @param S2Container $parent parent container object.
	 * @param string $diconFullPath dicon file's full path.
	 * @return S2Container child container object.
	 */
	public static function includeChildFromDicon(
		S2Container $parent, $diconFullPath) {
		return S2ContainerFactory::includeChild($parent, $diconFullPath);
		
	}

	
	/**
	 * Includes a child S2Container from dicon's resource name (path).
	 *
	 * @param S2Container $parent parent container object.
	 * @param string $diconResourceName dicon resource name (path) on include_path.
	 * @return S2Container child container object.
	 */
	public static function includeChildFromDiconOnIncludePath(
		S2Container $parent, $diconResourceName) {
		$diconFullPath = Commons_Lang_ClassLoader::getResource($diconResourceName);
		
		return self::includeChildFromDicon($parent, $diconFullPath);
	}
	
}

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * c-hanging-comment-ender-p: nil
 * End:
 */
?>
