<?php
// phpoot, PHP Object Orient style Template engine
//
// Copyright (C) Haruki Setoyama <haruki@planewave.org>
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
include_once 'phpoot.buffer.php';
include_once 'phpoot.parser.core.php';
/**
* compiler of phpoot
*
* @author Haruki Setoyama  <haruki@planewave.org>
* @version $Id: phpoot.compiler.php,v 1.3 2002/12/23 01:09:00 haruki Exp $
* @package phpoot
**/
/**
* phpoot_compiler
*
* @access public
**/
class phpoot_compiler extends phpoot_tokenize {

    var $error;

    /**
    * compile a template
    * @param string $template_file
    * @param string $compiled_file
    * @return bool
    * @access public
    **/
    function compile($template_file, $compiled_file){
        if(! $fp_r = fopen($template_file,"rb"))
            return false;
        $template_text = fread($fp_r,filesize($template_file));
        fclose($fp_r);

        $scaned = $this->_scan_template($template_text);
        $parsed = $this->_parse($scaned);

        $compiled =  "<?php\n".
                    'class phpoot_c_'.str_replace('.','_',basename($template_file)).
                    " extends phpoot_compiled {\n";

        for($i=0; $i<count($parsed); $i++){
            $compiled .= 'function _compiled_'.$i."(\$val, \$loop=array(), \$param='') {\n".
                        $parsed[$i].
                        "\nreturn \$out;\n".
                        "}\n\n";
        }
        $compiled .= "}\n?>\n"; // <?

        if(! $fp_w = @fopen($compiled_file,"w"))
            return false;
        fwrite($fp_w, $compiled);
        ftruncate($fp_w, ftell($fp_w));
        fclose($fp_w);

        return true;
    }

/////////////////////////////
///// private functions /////
/////////////////////////////

    /**
    * scan a stings of a template
    * @access private
    * @param string $str    string of the template.
    * @return array
    */
    function _scan_template($str){
        $str = str_replace(array("\r\n","\r"),array("\n","\n"),$str);

        $tokenized = $this->_remove_comment($this->_tokenize_template($str));

        $ret = array();
        $p_ret = -1;
        $f_tag = true;
        for($i=0; $i<count($tokenized); $i++){
            switch($tokenized[$i]['type']){
            case 'tag':
                preg_match('/\[\s*(.*)\s*\]/s',$tokenized[$i]['value'],$match);
                $param = $match[1];
                $p_ret++;

                if(preg_match('/^([\w\/]+)(?:\s+(.*))?$/', $param, $match)){
                    $ret[$p_ret]['type'] = 'tag';
                    $ret[$p_ret]['subtype'] = $match[1];
                    $ret[$p_ret]['parm'] = trim($match[2]);
                }
                elseif(preg_match('/^('.REGEX_PHPOOT_VARIABLE_NOHEAD.')$/s', $param, $match)){
                    $ret[$p_ret]['type'] = 'tag';
                    $ret[$p_ret]['subtype'] = 'val';
                    $ret[$p_ret]['parm'] = '$function'.$match[1];
                }
                elseif(preg_match('/^('.REGEX_PHPOOT_VARIABLE.')$/s', $param, $match)){
                    $ret[$p_ret]['type'] = 'tag';
                    $ret[$p_ret]['subtype'] = 'val';
                    $ret[$p_ret]['parm'] = $match[1];
                }
                elseif(preg_match('/^#\s+(.*)$/', $param, $match)){
                    $ret[$p_ret]['type'] = 'tag';
                    $ret[$p_ret]['subtype'] = 'comment';
                    $ret[$p_ret]['parm'] = $match[1];
                }
                else{
                    $ret[$p_ret]['type'] = 'tag';
                    $ret[$p_ret]['subtype'] = 'invalid';
                }
                $ret[$p_ret]['orig']=$tokenized[$i]['value'];
                $f_tag = true;
                break;

            case 'val':
                if(preg_match('/^\{\s*('.REGEX_PHPOOT_VARIABLE_NOHEAD.')\s*\}$/s',$tokenized[$i]['value'],$match)){
                    $p_ret++;
                    $ret[$p_ret]['type'] = 'val';
                    $ret[$p_ret]['subtype'] = 'val';
                    $ret[$p_ret]['parm'] = '$function'.$match[1];
                    $f_tag = true;
                }
                elseif(preg_match('/^\{\s*('.REGEX_PHPOOT_VARIABLE.')\s*\}$/s',$tokenized[$i]['value'],$match)){
                    $p_ret++;
                    $ret[$p_ret]['type'] = 'val';
                    $ret[$p_ret]['subtype'] = 'val';
                    $ret[$p_ret]['parm'] = $match[1];
                    $f_tag = true;
                }else{
                    if(false != $f_tag){
                        $p_ret++;
                        $ret[$p_ret]['type']='tpl';
                        $ret[$p_ret]['parm']='';
                        $f_tag = false;
                    }
                    $ret[$p_ret]['parm'] .= $tokenized[$i]['value'];
                }
                break;

            default:
                if(false != $f_tag){
                    $p_ret++;
                    $ret[$p_ret]['type']='tpl';
                    $ret[$p_ret]['parm']='';
                    $f_tag = false;
                }
                $ret[$p_ret]['parm'] .= $tokenized[$i]['value'];
                break;
            }
        }
        return $ret;
    }

    function _remove_comment($tokenized){
        $ret = array();
        for($i=0 ; $i<count($tokenized) ; $i++){
            if($tokenized[$i]['type'] == 'open-comment'
                    && $tokenized[$i+1]['type'] == 'tag'){
                continue;
            }
            if($tokenized[$i]['type'] == 'close-comment'
                    && $tokenized[$i-1]['type'] == 'tag'){
                continue;
            }
            $ret[] = $tokenized[$i];
        }
        return $ret;
    }

    function _tokenize_template($str){
        $quote = REGEX_DOUBLE_QUOTED.'|'.REGEX_SINGLE_QUOTED;
        $tokens[] = array('\[(?:[^"\'\]]|'.$quote.')+\]','tag');
        $tokens[] = array('\{(?:[^"\'\}]|'.$quote.')+\}','val');
        $tokens[] = array('[\040\t]*<!\-\-[\040\t]*','open-comment');
        $tokens[] = array('[\040\t]*\-\->[\040\t]*\n?','close-comment');
        $tokens[] = array('\s*<?[^\[\{<]*\n+','other1');
        $tokens[] = array('\s*<?[^\[\{<\n]+','other2');
        return $this->_tokenize($str, $tokens);
    }

    /**
    * Parse HTML template.
    * @access private
    * @param arra $parts  scand array of the template.
    * @return string
    */
    function _parse($parts){

        $buffer = new phpoot_buffer;
        $manager = new phpoot_parser_variable_manager($buffer);

        $parser[] = new phpoot_parser_tpl($buffer, $manager);
        $parser[] = new phpoot_parser_val($buffer, $manager);
        $parser[] = new phpoot_parser_each($buffer, $manager);
        $parser[] = new phpoot_parser_if($buffer, $manager);
        $parser[] = new phpoot_parser_loop($buffer, $manager);
        $parser[] = new phpoot_parser_alt($buffer, $manager);

        $parser[] = new phpoot_parser_other($buffer, $manager);    // this sould be last.

        foreach($parts as $part) {

            for($i=0; $i<count($parser); $i++){
                $temp = $parser[$i]->parse($part);
                if(false != $temp){
                    break;
                }
            }
        }

        return $buffer->getAll();
    }

}

/**
* phpoot_tokenize
*
* @access private
**/
class phpoot_tokenize {

    /**
    * tokenize a stirng
    * @param stirng $str
    * @param array $tokens
    * @return array
    * @access private
    **/
    function _tokenize($str, $tokens=array()){
        array_push($tokens, array('.','etc'));
        $ret = array();
        while(strlen($str) > 0){
            foreach($tokens as $token){
                if(preg_match('/^('.$token[0].')(.*)$/s',$str,$match)){
                    if(strlen($match[1]) == 0){
                        echo 'invalid regex!  ';
                        echo $token[0];
                        exit();
                    }
                    array_push($ret, array('type' => $token[1],
                                            'value' => $match[1]));
                    $str = $match[2];
                    break;
                }
            }
        }
        return $ret;
    }
}

/**
* defines for phpoot_tokenize
**/
define('REGEX_DOUBLE_QUOTED', '"(?:[^"]|\\\\")*"');
define('REGEX_SINGLE_QUOTED', '\'(?:[^\']|\\\\\')*\'');
define('REGEX_NUMBER', '[\+\-]?[0-9]+(?:\.[0-9]+)?');
define('REGEX_WORD','[a-zA-Z\x7f-\xff][a-zA-Z0-9_\x7f-\xff]*');
/**
* defines for phpoot_tokenize: variables of phpoot template
**/
define('REGEX_PHPOOT_VARIABLE_HEAD', '(?:(?:\$|#)'.REGEX_WORD.')');
define('REGEX_PHPOOT_VARIABLE_HEAD_ARRAY', '(?:\$'.REGEX_WORD.')');
define('REGEX_PHPOOT_VARIABLE_HEAD_LOOP', '(?:#'.REGEX_WORD.')');
define('REGEX_PHPOOT_VARIABLE_BODY', '(?:(?:\.|\/|%)'.REGEX_WORD.')');
define('REGEX_PHPOOT_VARIABLE_TAIL', '(?:'.'(?:(?:\/|%)'.REGEX_WORD.')'.'|'.'(?:(?:\.'.REGEX_WORD.')(?:\(.*\))?)'.')?');

define('REGEX_PHPOOT_VARIABLE_FRONT', REGEX_PHPOOT_VARIABLE_HEAD. REGEX_PHPOOT_VARIABLE_BODY.'*');
define('REGEX_PHPOOT_VARIABLE_METHOD', '(?:\.'.REGEX_WORD.')');
define('REGEX_PHPOOT_VARIABLE_PROPERTY', '(?:%'.REGEX_WORD.')');
define('REGEX_PHPOOT_VARIABLE_ARRAY', '(?:\/'.REGEX_WORD.')|'.REGEX_PHPOOT_VARIABLE_HEAD_ARRAY);
define('REGEX_PHPOOT_VARIABLE_LOOP', REGEX_PHPOOT_VARIABLE_HEAD_LOOP);
define('REGEX_PHPOOT_VARIABLE', REGEX_PHPOOT_VARIABLE_HEAD. REGEX_PHPOOT_VARIABLE_BODY.'*'. REGEX_PHPOOT_VARIABLE_TAIL);
define('REGEX_PHPOOT_VARIABLE_NOHEAD', REGEX_PHPOOT_VARIABLE_BODY.'*'. REGEX_PHPOOT_VARIABLE_TAIL);

?>