/*
 * Decompiled with CFR 0.152.
 */
package jdd.bdd;

import jdd.bdd.CacheEntry;
import jdd.bdd.NodeTable;
import jdd.util.JDDConsole;
import jdd.util.Test;
import jdd.util.math.Digits;
import jdd.util.math.HashFunctions;

public final class Cache {
    private CacheEntry[] entries;
    private int cache_bits;
    private int cache_size;
    private int cache_mask;
    private long num_access;
    private long last_access;
    private int num_clears;
    private int num_partial_clears;
    private int members;
    private int num_grows;
    private int possible_bins_count;

    public Cache(int n, int n2) {
        Test.check(n2 >= 1, "Cache members must be greater than 0");
        Test.check(n2 <= 3, "Cache members must be less than 4");
        this.cache_bits = n < 32 ? 5 : Digits.closest_log2(n);
        this.cache_size = 1 << this.cache_bits;
        this.cache_mask = this.cache_size - 1;
        this.members = n2;
        this.num_grows = 0;
        this.num_access = 0L;
        this.last_access = 0L;
        this.possible_bins_count = 0;
        this.num_partial_clears = 0;
        this.num_clears = 0;
        this.entries = new CacheEntry[this.cache_size];
        for (int i = 0; i < this.cache_size; ++i) {
            this.entries[i] = new CacheEntry();
        }
    }

    public int getSize() {
        return this.cache_size;
    }

    public void invalidate_cache(NodeTable nodeTable) {
        this.invalidate_cache(nodeTable, this.cache_size);
    }

    public void invalidate_cache(NodeTable nodeTable, int n) {
        if (this.possible_bins_count == 0) {
            return;
        }
        ++this.num_partial_clears;
        int n2 = 0;
        if (this.members == 1) {
            for (int i = 0; i < n; ++i) {
                if (this.entries[i].invalid()) continue;
                if (!nodeTable.isValid(this.entries[i].op1) || nodeTable.isValid(this.entries[i].ret)) {
                    this.entries[i].clear();
                    continue;
                }
                ++n2;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                if (this.entries[i].invalid()) continue;
                if (!(nodeTable.isValid(this.entries[i].op1) && nodeTable.isValid(this.entries[i].op2) && nodeTable.isValid(this.entries[i].ret))) {
                    this.entries[i].clear();
                    continue;
                }
                ++n2;
            }
        }
        if (n2 == 0) {
            this.possible_bins_count = 0;
        }
    }

    public void free_or_grow(NodeTable nodeTable) {
        if (this.num_grows < 3 && this.computeLoadFactor() > 95.0) {
            this.grow_and_invalidate_cache(nodeTable);
            return;
        }
        this.invalidate_cache(nodeTable, this.cache_size);
    }

    private void grow_and_invalidate_cache(NodeTable nodeTable) {
        int n;
        ++this.cache_bits;
        int n2 = 1 << this.cache_bits;
        this.cache_mask = n2 - 1;
        ++this.num_grows;
        CacheEntry[] cacheEntryArray = new CacheEntry[n2];
        for (n = 0; n < this.cache_size; ++n) {
            cacheEntryArray[n] = this.entries[n];
        }
        this.invalidate_cache(nodeTable, this.cache_size);
        for (n = this.cache_size; n < n2; ++n) {
            cacheEntryArray[n] = new CacheEntry();
        }
        this.cache_size = n2;
        this.entries = cacheEntryArray;
    }

    public void invalidate_cache() {
        if (this.possible_bins_count == 0) {
            return;
        }
        ++this.num_clears;
        for (int i = 0; i < this.cache_size; ++i) {
            this.entries[i].clear();
        }
        this.possible_bins_count = 0;
    }

    public void free_or_grow() {
        if (this.num_grows < 3 && this.computeLoadFactor() > 95.0) {
            this.grow_and_invalidate_cache();
            return;
        }
        this.invalidate_cache();
    }

    private void grow_and_invalidate_cache() {
        int n;
        ++this.cache_bits;
        int n2 = 1 << this.cache_bits;
        this.cache_mask = n2 - 1;
        ++this.num_grows;
        CacheEntry[] cacheEntryArray = new CacheEntry[n2];
        for (n = 0; n < this.cache_size; ++n) {
            cacheEntryArray[n] = this.entries[n];
            cacheEntryArray[n].clear();
        }
        for (n = this.cache_size; n < n2; ++n) {
            cacheEntryArray[n] = new CacheEntry();
        }
        this.cache_size = n2;
        this.entries = cacheEntryArray;
    }

    private static final int pair(int n, int n2) {
        return (n + n2) * (n + n2 + 1) / 2 + n;
    }

    private final int hash1(int n) {
        return n & this.cache_mask;
    }

    private final int hash2(int n, int n2) {
        return HashFunctions.hash_prime(n, n2) & this.cache_mask;
    }

    private final int hash3(int n, int n2, int n3) {
        return HashFunctions.hash_prime(n, n2, n3) & this.cache_mask;
    }

    public CacheEntry access3(int n, int n2, int n3) {
        ++this.num_access;
        ++this.possible_bins_count;
        return this.entries[this.hash3(n, n2, n3)];
    }

    public CacheEntry access2(int n, int n2) {
        ++this.num_access;
        ++this.possible_bins_count;
        return this.entries[this.hash2(n, n2)];
    }

    public CacheEntry access1(int n) {
        ++this.num_access;
        ++this.possible_bins_count;
        return this.entries[n & this.cache_mask];
    }

    private void insert3(byte by, int n, int n2, int n3) {
        CacheEntry cacheEntry = this.access3(by, n, n2);
        cacheEntry.type = by;
        cacheEntry.op1 = n;
        cacheEntry.op2 = n2;
        cacheEntry.ret = n3;
    }

    private void insert2(byte by, int n, int n2) {
        CacheEntry cacheEntry = this.access2(by, n);
        cacheEntry.type = by;
        cacheEntry.op1 = n;
        cacheEntry.ret = n2;
    }

    private void insert1(int n, int n2) {
        CacheEntry cacheEntry = this.access1(n);
        cacheEntry.op1 = n;
        cacheEntry.ret = n2;
    }

    private int lookup3(byte by, int n, int n2) {
        CacheEntry cacheEntry = this.access3(by, n, n2);
        return cacheEntry.op1 == n && cacheEntry.op2 == n2 && cacheEntry.type == by ? cacheEntry.ret : -1;
    }

    private int lookup2(byte by, int n) {
        CacheEntry cacheEntry = this.access2(by, n);
        return cacheEntry.op1 == n && cacheEntry.type == by ? cacheEntry.ret : -1;
    }

    private int lookup1(int n) {
        CacheEntry cacheEntry = this.access1(n);
        return cacheEntry.op1 == n ? cacheEntry.ret : -1;
    }

    public double computeLoadFactor() {
        int n = 0;
        for (int i = 0; i < this.cache_size; ++i) {
            if (this.entries[i].invalid()) continue;
            ++n;
        }
        return (double)(n * 10000 / this.cache_size) / 100.0;
    }

    public double computeHitRate() {
        long l = 0L;
        for (int i = 0; i < this.cache_size; ++i) {
            l += (long)this.entries[i].found;
        }
        return (double)((int)(l * 10000L / this.num_access)) / 100.0;
    }

    public void showStats(String string) {
        if (this.num_access != 0L) {
            JDDConsole.out.print(string + "-cache ");
            JDDConsole.out.print("ld=" + this.computeLoadFactor() + "% ");
            JDDConsole.out.print("sz=");
            Digits.printNumber(this.cache_size);
            JDDConsole.out.print("accs=");
            Digits.printNumber(this.num_access);
            JDDConsole.out.print("clrs=" + this.num_clears + "/" + this.num_partial_clears + " ");
            JDDConsole.out.print("hitr=" + this.computeHitRate() + "% ");
            if (this.num_grows > 0) {
                JDDConsole.out.print("grws=" + this.num_grows + " ");
            }
            this.showDeviation();
            JDDConsole.out.println();
        }
    }

    private void showDeviation() {
        double d = 0.0;
        double d2 = 0.0;
        int n = 0;
        int n2 = Integer.MAX_VALUE;
        int n3 = 0;
        for (int i = 0; i < this.cache_size; ++i) {
            int n4 = this.entries[i].found;
            if (n4 > 0) {
                ++n3;
            }
            d += (double)n4;
            d2 += (double)(n4 * n4);
            n = Math.max(this.entries[i].overwrite, n);
            n2 = Math.min(this.entries[i].overwrite, n2);
        }
        double d3 = Math.sqrt((d2 /= (double)this.cache_size) - (d /= (double)this.cache_size) * d);
        double d4 = Math.sqrt((1.0 - 1.0 / (double)this.cache_size) * (double)this.num_access / (double)this.cache_size);
        JDDConsole.out.print("use/exp=" + 100 * n3 / this.cache_size + "/" + (int)(100.0 * (1.0 - Math.pow(Math.E, -d))) + "%");
    }

    public void check_cache(int[] nArray) {
        for (int i = 0; i < this.cache_size; ++i) {
            if (this.entries[i].invalid() || nArray[this.entries[i].ret] >= 0) continue;
            JDDConsole.out.println("Invalied cache entry at position " + i);
            JDDConsole.out.println("" + i + " --> " + this.entries[i].op1 + "/" + this.entries[i].op2 + "/" + this.entries[i].ret + "  " + this.entries[i].type);
            System.exit(20);
        }
    }

    void show_cache() {
        block5: for (int i = 0; i < this.cache_size; ++i) {
            if (this.entries[i].invalid()) continue;
            switch (this.members) {
                case 1: {
                    JDDConsole.out.println("" + i + " --> " + this.entries[i].op1 + "/" + this.entries[i].ret);
                    continue block5;
                }
                case 2: {
                    JDDConsole.out.println("" + i + " --> " + this.entries[i].op1 + "/" + this.entries[i].ret + "  " + this.entries[i].type);
                    continue block5;
                }
                case 3: {
                    JDDConsole.out.println("" + i + " --> " + this.entries[i].op1 + "/" + this.entries[i].op2 + "/" + this.entries[i].ret + "  " + this.entries[i].type);
                }
            }
        }
    }

    public static void internal_test() {
        Test.start("Cache");
        Cache cache = new Cache(200, 3);
        cache.insert3((byte)2, 1, 2, 3);
        Test.check(cache.lookup3((byte)2, 1, 2) == 3, "lookup 3");
        cache.insert3((byte)2, 1, 2, 5);
        Test.check(cache.lookup3((byte)2, 1, 2) == 5, "lookup overwritten with 5");
        Test.check(cache.lookup3((byte)1, 1, 2) == -1, "non-existing entry 1");
        Test.check(cache.lookup3((byte)2, 2, 2) == -1, "non-existing entry 2");
        Test.check(cache.lookup3((byte)2, 2, 1) == -1, "non-existing entry 3");
        cache = new Cache(200, 2);
        cache.insert2((byte)2, 1, 3);
        Test.check(cache.lookup2((byte)2, 1) == 3, "lookup 3");
        cache.insert2((byte)2, 1, 5);
        Test.check(cache.lookup2((byte)2, 1) == 5, "lookup overwritten with 5");
        Test.check(cache.lookup2((byte)1, 1) == -1, "non-existing entry 1");
        Test.check(cache.lookup2((byte)2, 2) == -1, "non-existing entry 2");
        cache = new Cache(200, 1);
        cache.insert1(1, 3);
        Test.check(cache.lookup1(1) == 3, "lookup 3");
        cache.insert1(1, 5);
        Test.check(cache.lookup1(1) == 5, "lookup overwritten with 5");
        Test.check(cache.lookup1(2) == -1, "non-existing entry 1");
        Test.check(cache.lookup1(3) == -1, "non-existing entry 2");
        Test.end();
    }
}

