#!/usr/local/bin/ruby
#
#-----------------------------------------------------------
# Author:   Dice
# License:  NYSL 0.9982 (http://www.kmonos.net/nysl/)
# URL:      http://scl.littlestar.jp/pinkyblog/
#-----------------------------------------------------------

begin

	$SAFE = 1
	require './blog'
	
	#---------------------------------------------------------
	# Please rewrite "true" if your server is xrea with ad. 
	$XREA_AD_SWITCH = false
	#---------------------------------------------------------


	if $XREA_AD_SWITCH then
		real_path_info_range = (ENV['PATH_INFO'].length / 2)
		ENV['PATH_INFO'] = ENV['PATH_INFO'].slice(0, real_path_info_range)
		ENV['SCRIPT_NAME'] = ENV['SCRIPT_NAME'].slice(0, ENV['SCRIPT_NAME'].length - real_path_info_range)
	end


	app = Rack::Builder.new{
		run BlogCaller.new
	}
	

	Rack::Handler::CGI.run(app)

	
rescue Exception

	$stdout.binmode
	
	res = ''
	lf = "\r\n"
	
	__FILE__.untaint
	nph = (File.basename(__FILE__) =~ /^nph\-/ ? true : false)
	
	if nph then
		res << "HTTP/1.1 500 Internal Server Error" << lf
	end
	res << "Content-Type: text/plain" << lf
	res << lf
	
	res << "nph = #{nph.inspect}" << lf
	res << lf
	res << "#{$!} (#{$!.class})" << lf
	res << $@.map{|x| "  #{x}"}.join(lf) << lf
	res << "ruby #{RUBY_VERSION} (#{RUBY_RELEASE_DATE}) [#{RUBY_PLATFORM}]" << lf
	if defined?(PinkyBlog::CORE_VERSION) then
		res << "Pinky:blog #{PinkyBlog::CORE_VERSION}" << lf
	else
		res << "Pinky:blog (system version is unidentified)" << lf
	end
	
	res << lf
	
	begin
		open('pinkyblog_error.log', 'w'){|f|
			f.write(res)
		}
	rescue StandardError
	end
	
	$stdout.write(res)
end

