#include "config.h"
#include "pipes/pipes.h"
#include <stdio.h>

void version()
{
    printf("pipes version %s\n", getenv("PIPES_VERSION"));
}

int main(int argc, char** argv)
{
    CHECKML_BEGIN(FALSE);

    setenv("PIPES_VERSION", "1.0.0", 1);
    setenv("PIPES_DATAROOTDIR", DATAROOTDIR, 1);

    srandom((unsigned)time(NULL));

    char* optc = NULL;
    int i;
    for(i=0; i<argc; i++) {
        if(strcmp(argv[i], "-c") == 0 && i+1 < argc) {
            optc = argv[i+1];
            break;
        }
        else if(strcmp(argv[i], "--version") == 0) {
            version();
            exit(0);
        }
    }

    if(optc) {
        pipes_opt_c(optc, argv, argc);
    }
    else if(argc >= 2) {
        pipes_load_file(argv[1], argv, argc);
    }
    else {
        setenv("PIPES_RUNNING_AS_INTRACTIVE_MODE", "1", 1);
        pipes_readline_interface(argv, argc);
    }

    CHECKML_END();

    return 0;
}
