#ifndef PIPES_BLOCK_H
#define PIPES_BLOCK_H

#ifdef MDEBUG
sObject* block_new_debug_from_malloc(const char* fname, int line, const char* func_name);
#define BLOCK_NEW_MALLOC() block_new_debug_from_malloc(__FILE__, __LINE__, __FUNCTION__)
#else
sObject* block_new_from_malloc();
#define BLOCK_NEW_MALLOC() block_new_from_malloc()
#endif

sObject* block_new_from_gc(BOOL user_object);
#define BLOCK_NEW_GC(o) block_new_from_gc(o)

sObject* block_new_from_stack();
#define BLOCK_NEW_STACK() block_new_from_stack()

sObject* block_clone_gc(sObject* source, int type, BOOL user_object);
sObject* block_clone_stack(sObject* source, int type);
int block_gc_children_mark(sObject* self);

void block_delete_stack(sObject* self);
void block_delete_gc(sObject* self);
void block_delete_malloc(sObject* self);

sCommand* sCommand_new(sStatment* statment);
void sStatment_delete(sStatment* self);
sStatment* sStatment_new(sObject* block, int sline, char* sname);
void sCommand_delete(sCommand* self);

void sCommand_add_arg_to_command(sCommand* self, MANAGED char* buf, int env);
BOOL sCommand_add_message(sCommand* self, MANAGED char* message);
void sCommand_add_env_block(sCommand* self, sObject* block, enum eLineField lf);
void sCommand_add_env(sCommand* self, MANAGED char* name, MANAGED char* key);

sObject* fun_clone_from_stack_block_gc(sObject* block, BOOL user_object, sObject* parent);
sObject* fun_clone_from_stack_block_stack(sObject* block, sObject* parent);

sObject* make_stack_fun_from_stack_block(sObject* self);

sObject* class_clone_from_stack_block_gc(sObject* block, BOOL user_object, sObject* parent);
sObject* class_clone_from_stack_block_stack(sObject* block, sObject* parent);

#endif

