/* 
 * terminal controlmanagement library
 */

#ifndef PIPES_CURSES_H
#define PIPES_CURSES_H

#include <stdarg.h>
#include <sys/ioctl.h>
#include <sys/types.h>

///////////////////////////////////////////////////////////////////////
// variables
///////////////////////////////////////////////////////////////////////
enum eTerminalKanjiCode { kTKEucjp, kTKSjis, kTKUtf8 };
extern enum eTerminalKanjiCode gTerminalKanjiCode;

extern int gKeyEscapeWait;   // espace key wait time

///////////////////////////////////////////////////////////////////////
// macros
///////////////////////////////////////////////////////////////////////
#define kCAReverse 0x1          // character attributes or colors
#define kCABold 0x2
#define kCAUnderline 0x4
#define kCABlack 0x8
#define kCARed 0x10
#define kCAGreen 0x20
#define kCAYellow 0x40
#define kCABlue 0x80
#define kCAMagenta 0x100
#define kCACyan 0x200
#define kCAWhite 0x400
#define kCABackBlack 0x800
#define kCABackRed 0x1000
#define kCABackGreen 0x2000
#define kCABackYellow 0x4000
#define kCABackBlue 0x8000
#define kCABackMagenta 0x10000
#define kCABackCyan 0x20000
#define kCABackWhite 0x40000

/////////////////////////////////////////////////////////////////////
// functions
/////////////////////////////////////////////////////////////////////
void mcurses_init(enum eTerminalKanjiCode code);
void mcurses_final();

void minitscr();
void mendwin();

#define kKeyMapKeysMax 10
#define kKeyMetaFirst 128
void madd_keymap(int key, signed char keyes[kKeyMapKeysMax]);

void mclear();
void mclear_immediately();
void mclear_online(int y);

void mmove(int y, int x);
void mmove_immediately(int y, int x);
int mmvprintw(int y, int x, char* str, ...);
int mmvprintw_immediately(int y, int x, char* str, ...);
int mprintw_immediately(char* str, ...);
int mprintw(char* str, ...);

void mattron(int attrs);
void mattroff();

void mbox(int y, int x, int width, int height);
void mrefresh();

int mgetmaxx();
int mgetmaxy();

int mgetch(int* meta);
int mgetch_nonblock(int* meta);

int mkbuf_exist();

int mis_raw_mode();
void mreset_tty();
void msave_screen();
void mrestore_screen();
void mrestore_ttysettings();
void msave_ttysettings();

void mbackspace_immediately();
void mbackspace_head_of_line_immediately();
void mmove_line_home_immediately();
void mcursor_right_immediately(int n);
void mcursor_left_immediately(int n);

extern int gMCTtyFd;

#endif

