#include "config.h"
#include "pipes/pipes.h"
#include <string.h>
#include <strings.h>
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <errno.h>
#include <fcntl.h>
#include <libgen.h>
#include <dirent.h>
#include <readline/readline.h>
#include <readline/history.h>
#include <oniguruma.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <pwd.h>
#include <limits.h>

static sObject* gReadlineBlock;
static sObject* gCompletionArray;

static BOOL name_sort(void* left, void* right)
{
    char* lfname = left;
    char* rfname = right;

    if(strcmp(lfname, ".") == 0) return TRUE;
    if(strcmp(lfname, "..") == 0) {
        if(strcmp(rfname, ".") == 0) return FALSE;

        return TRUE;          
    }
    if(strcmp(rfname, ".") == 0) return FALSE;
    if(strcmp(rfname, "..") == 0) return FALSE;

    return strcasecmp(lfname, rfname) < 0;
}

static sObject* gUserCompletionNextout;
static sObject* gUserCompBlocks;
static sObject* gReadlineCurrentObject;

static char* message_completion(const char* text, int stat)
{
    static int index, wordlen;

    if(stat == 0) {
        sStatment* statment = SBLOCK(gReadlineBlock).mStatments + SBLOCK(gReadlineBlock).mStatmentsNum - 1;
        
        sCommand* command = statment->mCommands + statment->mCommandsNum-1;

        gCompletionArray = VECTOR_NEW_STACK(16);

        sObject* current = gReadlineCurrentObject;
        sObject* object;

        sObject* messages = STRING_NEW_STACK("");

        while(1) {
            object = hash_item(current, command->mMessages[0]);
            if(object || current == gRootObject) break;
            current = SUOBJECT((current)).mParent;
        }

        string_put(messages, command->mMessages[0]);
        string_push_back(messages, "->");

        if(object && TYPE(object) == T_UOBJECT) {
            int i;
            for(i=1; i<command->mMessagesNum; i++) {
                object = hash_item(object, command->mMessages[i]);
                if(object == NULL) break;
                string_push_back(messages, command->mMessages[i]);
                string_push_back(messages, "->");
            }

            if(object && TYPE(object) == T_UOBJECT) {
                hash_it* it = hash_loop_begin(object);
                while(it) {
                    char* key = hash_loop_key(it);
                    sObject* item = hash_loop_item(it);

                    sObject* candidate = STRING_NEW_STACK(string_c_str(messages));
                    string_push_back(candidate, key);
                    if(TYPE(item) == T_UOBJECT) {
                        string_push_back(candidate, "->");
                    }
                    vector_add(gCompletionArray, string_c_str(candidate));
                    it = hash_loop_next(it);
                }

                vector_sort(gCompletionArray, name_sort);
            }
        }

        wordlen = strlen(text);
        index = 0;
    }

    while(index < vector_size(gCompletionArray)) {
        char* candidate = vector_item(gCompletionArray, index);
        index++;

        if(!strncmp(text, candidate, wordlen)) {
            int len = strlen(candidate);
            if(len > 2 && candidate[len-2] == '-' && candidate[len-1] == '>') {
                rl_completion_append_character = 0;
            }
            else {
                rl_completion_append_character = ' ';
            }
            return strdup(candidate);
        }
    }

    return NULL;
}

static char* program_completion(const char* text, int stat)
{
    static int index, wordlen;

    if(stat == 0) {
        gCompletionArray = VECTOR_NEW_STACK(16);
        sObject* hash = HASH_NEW_STACK(16);

        sObject* current = gReadlineCurrentObject;
        while(1) {
            hash_it* it = hash_loop_begin(current);
            while(it) {
                char* key = hash_loop_key(it);
                sObject* object = hash_loop_item(it);

                if(hash_item(hash, key) == NULL) {
                    hash_put(hash, key, object);

                    sObject* candidate = STRING_NEW_STACK(hash_loop_key(it));
                    if(TYPE(object) == T_UOBJECT) {
                        string_push_back(candidate, "->");
                    }

                    vector_add(gCompletionArray, string_c_str(candidate));
                }

                it = hash_loop_next(it);
            }
            
            if(current == gRootObject) break;

            current = SUOBJECT(current).mParent;
        }
        vector_sort(gCompletionArray, name_sort);

        wordlen = strlen(text);
        index = 0;
    }

    while(index < vector_size(gCompletionArray)) {
        char* candidate = vector_item(gCompletionArray, index);
        index++;

        if(!strncmp(text, candidate, wordlen)) {
            int len = strlen(candidate);
            if(len > 2 && candidate[len-2] == '-' && candidate[len-1] == '>') {
                rl_completion_append_character = 0;
            }
            else {
                rl_completion_append_character = ' ';
            }
            return strdup(candidate);
        }
    }

    return NULL;
}

static char* user_completion(const char* text, int stat)
{
    static int index, wordlen;

    if(stat == 0) {
        gCompletionArray = VECTOR_NEW_STACK(16);

        int i;
        for(i=0; i<vector_size(SFD(gUserCompletionNextout).mLines); i++) {
            sObject* candidate = STRING_NEW_STACK(vector_item(SFD(gUserCompletionNextout).mLines, i));
            string_chomp(candidate);
            vector_add(gCompletionArray, string_c_str(candidate));
        }

        vector_sort(gCompletionArray, name_sort);

        wordlen = strlen(text);
        index = 0;
    }

    while(index < vector_size(gCompletionArray)) {
        char* candidate = vector_item(gCompletionArray, index);
        index++;

        if(!strncmp(text, candidate, wordlen)) {
            rl_completion_append_character = ' ';
            return strdup(candidate);
        }
    }

    return NULL;
}

/*
static char* tilda_completion(const char* text, int stat)
{
    static int index, wordlen;

    if(stat == 0) {
        gCompletionArray = VECTOR_NEW_STACK(16);

        sObject* str = STRING_NEW_STACK("~/");
        vector_add(gCompletionArray, 

        sObject* gEditingDir2 = STRING_NEW("");

        if(string_length(user) == 0) {
            char* home = getenv("HOME");
            if(home) {
                string_put(gEditingDir2, home);
            }
            else {
                struct passwd* pw = getpwuid(getuid());
                if(pw) {
                    string_put(gEditingDir2, pw->pw_dir);
                }
                else {
                    string_put(gEditingDir2, "~");
                }
            }
        }
        else {
            struct passwd* pw = getpwnam(string_c_str(user));
            if(pw) {
                string_put(gEditingDir2, pw->pw_dir);
            }
            else {
                string_put(gEditingDir2, "~");
                string_push_back(gEditingDir2, string_c_str(user));
            }
        }

        string_push_back(gEditingDir2, p);

        string_put(gEditingDir, string_c_str(gEditingDir2));

        string_delete(gEditingDir2);
        string_delete(user);

        vector_add(gCompletionArray, string_c_str(candidate));

        vector_sort(gCompletionArray, name_sort);

        wordlen = strlen(text);
        index = 0;
    }

    while(index < vector_size(gCompletionArray)) {
        char* candidate = vector_item(gCompletionArray, index);
        index++;

        if(!strncmp(text, candidate, wordlen)) {
            int len = strlen(candidate);
            if(len > 2 && candidate[len-2] == '-' && candidate[len-1] == '>') {
                rl_completion_append_character = 0;
            }
            else {
                rl_completion_append_character = ' ';
            }
            return strdup(candidate);
        }
    }

    return NULL;
}
*/

static char* env_completion(const char* text, int stat)
{
    static int index, wordlen;

    if(stat == 0) {
        gCompletionArray = VECTOR_NEW_STACK(16);
        sObject* hash = HASH_NEW_STACK(16);

        sObject* current = gReadlineCurrentObject;
        while(1) {
            hash_it* it = hash_loop_begin(current);
            while(it) {
                char* key = hash_loop_key(it);
                sObject* object = hash_loop_item(it);

                if(hash_item(hash, key) == NULL) {
                    if(TYPE(object) == T_STRING || TYPE(object) == T_VECTOR || TYPE(object) == T_HASH) {
                        hash_put(hash, key, object);

                        sObject* candidate = STRING_NEW_STACK("$");
                        string_push_back(candidate, hash_loop_key(it));

                        vector_add(gCompletionArray, string_c_str(candidate));
                    }
                }

                it = hash_loop_next(it);
            }
            
            if(current == gRootObject) break;

            current = SUOBJECT(current).mParent;
        }
        vector_sort(gCompletionArray, name_sort);

        wordlen = strlen(text);
        index = 0;
    }

    while(index < vector_size(gCompletionArray)) {
        char* candidate = vector_item(gCompletionArray, index);
        index++;

        if(!strncmp(text, candidate, wordlen)) {
            int len = strlen(candidate);
            if(len > 2 && candidate[len-2] == '-' && candidate[len-1] == '>') {
                rl_completion_append_character = 0;
            }
            else {
                rl_completion_append_character = ' ';
            }
            return strdup(candidate);
        }
    }

    return NULL;
}

char** readline_on_complete(const char* text, int start, int end)
{
    stack_start_stack();

    gReadlineBlock = BLOCK_NEW_STACK();

    sObject* cmdline = STRING_NEW_STACK("");
    string_push_back3(cmdline, rl_line_buffer, end);

    int sline = 1;
    gReadlineCurrentObject = gCurrentObject;
    BOOL result = parse(string_c_str(cmdline), "readline", &sline, gReadlineBlock, &gReadlineCurrentObject);

    /// in the block?
    if(!result && (SBLOCK(gReadlineBlock).mCompletionFlags & COMPLETION_FLAGS_BLOCK)) {
        while(1) {
            if(SBLOCK(gReadlineBlock).mStatmentsNum > 0) {
                sStatment* statment = SBLOCK(gReadlineBlock).mStatments + SBLOCK(gReadlineBlock).mStatmentsNum - 1;

                if(statment->mCommandsNum > 0) {
                    sCommand* command = statment->mCommands + statment->mCommandsNum-1;

                    int num = SBLOCK(gReadlineBlock).mCompletionFlags & 0xFF;

                    if(num > 0) {
                        if(SBLOCK(gReadlineBlock).mCompletionFlags & COMPLETION_FLAGS_ENV_BLOCK) {
                            sEnv* env = command->mEnvs + num -1;
                            gReadlineBlock = env->mBlock;
                        }
                        else {
                            gReadlineBlock = *(command->mBlocks + num -1);
                        }
                    }
                    else {
                        break;
                    }
                }
                else {
                    break;
                }
            }
            else {
                break;
            }
        }
    }

    if(SBLOCK(gReadlineBlock).mStatmentsNum == 0) {
        char** result = rl_completion_matches(text, program_completion);
        stack_end_stack();
        return result;
    }
    else if(SBLOCK(gReadlineBlock).mStatmentsNum > 0) {
        sStatment* statment = SBLOCK(gReadlineBlock).mStatments + SBLOCK(gReadlineBlock).mStatmentsNum - 1;

        if(statment->mCommandsNum == 0) {
            char** result = rl_completion_matches(text, program_completion);
            stack_end_stack();
            return result;
        }
        else {
            sCommand* command = statment->mCommands + statment->mCommandsNum-1;

            const int command_num = command->mArgsNum + (SBLOCK(gReadlineBlock).mCompletionFlags & COMPLETION_FLAGS_FILE_COMPLETION ? 1:0);

            sObject* ucomp_block;
            if(command->mArgsNum > 0) {
                ucomp_block = hash_item(gUserCompBlocks, command->mArgs[0]);
            }
            else {
                ucomp_block = NULL;
            }

            if(ucomp_block) {
                sObject* nextin = FD_NEW_STACK();
                if(!fd_write(nextin, string_c_str(cmdline))) {
                    stack_end_stack();
                    return NULL;
                }
                sObject* nextout = FD_NEW_STACK();

                sObject* fun = FUN_NEW_STACK(NULL);
                sObject* stackframe = UOBJECT_NEW_GC(8, gPipesObject, "_stackframe", FALSE);
                vector_add(gStackFrames, stackframe);
                //uobject_init(stackframe);
                SFUN(fun).mLocalObjects = stackframe;

                int rcode = 0;
                if(!run(ucomp_block, nextin, nextout, &rcode, gReadlineCurrentObject, fun)) {
                    vector_pop_back(gStackFrames);
                    stack_end_stack();
                    return NULL;
                }
                vector_pop_back(gStackFrames);

                fd_split(nextout, kLF);

                gUserCompletionNextout = nextout;
                char** result = rl_completion_matches(text, user_completion);
                stack_end_stack();
                return result;
            }
            else if(SBLOCK(gReadlineBlock).mCompletionFlags & (COMPLETION_FLAGS_ENV)) {
                char** result = rl_completion_matches(text, env_completion);
                stack_end_stack();
                return result;
            }
            else if(command_num < 2 || SBLOCK(gReadlineBlock).mCompletionFlags & (COMPLETION_FLAGS_NEXT_PIPE|COMPLETION_FLAGS_NEXT_STATMENT)) {
                if(command->mMessagesNum > 0 && !(SBLOCK(gReadlineBlock).mCompletionFlags & (COMPLETION_FLAGS_NEXT_PIPE|COMPLETION_FLAGS_NEXT_STATMENT))) {
                    char** result = rl_completion_matches(text, message_completion);
                    stack_end_stack();
                    return result;
                }
                else {
                    char** result = rl_completion_matches(text, program_completion);
                    stack_end_stack();
                    return result;
                }
            }
        }
    }

    stack_end_stack();
    return NULL;
}

static int skip_quoted(const char *s, int i, char q)
{
   while(s[i] && s[i]!=q) 
   {
      if(s[i]=='\\' && s[i+1]) i++;
      i++;
   }
   if(s[i]) i++;
   return i;
}

static int lftp_char_is_quoted(const char *string,int eindex)
{
  int i, pass_next;

  for (i = pass_next = 0; i <= eindex; i++)
    {
      if (pass_next)
        {
          pass_next = 0;
          if (i >= eindex)
            return 1;
          continue;
        }
      else if (string[i] == '"' || string[i] == '\'')
        {
          char quote = string[i];
          i = skip_quoted (string, ++i, quote);
          if (i > eindex)
            return 1;
          i--;  /* the skip functions increment past the closing quote. */
        }
      else if (string[i] == '\\')
        {
          pass_next = 1;
          continue;
        }
    }
  return (0);
}

BOOL cmd_completion(sObject* nextin, sObject* nextout, sRunInfo* runinfo)
{
    sCommand* command = runinfo->mCommand;

    if(command->mArgsNumRuntime >= 2 && command->mBlocksNum == 1) {
        sObject* block = command->mBlocks[0];

        int i;
        for(i=1; i<command->mArgsNumRuntime; i++) {
            char* cmd = command->mArgsRuntime[i];

            hash_put(gUserCompBlocks, cmd, block_clone_gc(block, T_BLOCK, FALSE));
        }

        runinfo->mRCode = 0;
    }

    return TRUE;
}

void pipes_readline_init(BOOL runtime_script)
{
    rl_attempted_completion_function = readline_on_complete;
    rl_completer_quote_characters = "\"'";
    rl_completer_word_break_characters = " \t\n\"'|!&;()=";
    rl_filename_quote_characters = " \\\t\n\"'|$*?[]{}&;#()";
    rl_completion_append_character= ' ';
    rl_char_is_quoted_p = (rl_linebuf_func_t*)lftp_char_is_quoted;

    gUserCompBlocks = HASH_NEW_GC(16, FALSE);
    hash_put(gPipesObject, "_ucomp_blocks", gUserCompBlocks);
}

void pipes_readline_final()
{
}
