/* -*- Mode: c; c-basic-offset: 8; Coding: utf-8-unix -*- ;; */
/* $Id: base64.c 2 2008-05-27 07:44:27Z mtaneda $	 */

/*
 * Copyright 2008 The piranha Project. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PIRANHA PROJECT ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE PIRANHA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the piranha Project.
 */

#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	"strtool.h"
#include	"base64.h"

#define	BASE64_TYPE_ENCODE	(0x01 << 0)
#define	BASE64_TYPE_DECODE	(0x01 << 1)

int             base64_get_dst_len(const int type, const char *src, const int src_len);
char           *base64_calloc(const int type, const int dst_len);
char            base64_encode_core(const char src);

int 
base64_encode(const char *src, const int src_len, char **dst)
{
	char           *tmp = NULL;
	int             n, m, dst_len = 0;

	if (strtool_isempty(src) || src_len < 0 || !dst)
	{
		goto ERROR;
	}
	dst_len = base64_get_dst_len(BASE64_TYPE_ENCODE, src, src_len);
	tmp = base64_calloc(BASE64_TYPE_ENCODE, dst_len);

	if (!tmp)
	{
		goto ERROR;
	}
	for (n = 0, m = 0; n < src_len && m < dst_len; n += 3, m += 4)
	{
		if (n + 2 < src_len)
		{
			tmp[m] = base64_encode_core((src[n] >> 2) & 0x3F);
			tmp[m + 1] = base64_encode_core((((src[n] << 4) & 0x30) + ((src[n + 1] >> 4) & 0x0F)) & 0x3F);
			tmp[m + 2] = base64_encode_core(((((src[n + 1]) << 2) & 0x3C) + ((src[n + 2] >> 6) & 0x03)) & 0x3F);
			tmp[m + 3] = base64_encode_core((src[n + 2] & 0x3F) & 0x3F);
		} else if (n + 1 < src_len)
		{
			tmp[m] = base64_encode_core((src[n] >> 2) & 0x3F);
			tmp[m + 1] = base64_encode_core((((src[n] << 4) & 0x30) + ((src[n + 1] >> 4) & 0x0F)) & 0x3F);
			tmp[m + 2] = base64_encode_core(((((src[n + 1]) << 2) & 0x3C) + ((src[n + 2] >> 6) & 0x03)) & 0x3F);
		} else
		{
			tmp[m] = base64_encode_core((src[n] >> 2) & 0x3F);
			tmp[m + 1] = base64_encode_core((((src[n] << 4) & 0x30) + ((src[n + 1] >> 4) & 0x0F)) & 0x3F);
		}
	}

	*dst = tmp;

	return (dst_len);
ERROR:
	free(tmp);
	*dst = NULL;
	return (0);
}

int 
base64_decode(const char *src, const int src_len, char **dst)
{
	char           *tmp = NULL;
	char            work[4];
	int             i, n, m, dst_len = 0;

	if (!src || src_len < 1 || !dst)
	{
		goto ERROR;
	}
	dst_len = base64_get_dst_len(BASE64_TYPE_DECODE, src, src_len);
	tmp = base64_calloc(BASE64_TYPE_DECODE, dst_len);

	if (!tmp)
	{
		goto ERROR;
	}
	for (n = 0, m = 0; n < src_len && m < dst_len; n += 4, m += 3)
	{
		for (i = 0; i < 4; i++)
		{
			if (src[n + i] == '+')
				work[i] = 0x2E;
			else if (src[n + i] == '/')
				work[i] = 0x2F;
			else if (src[n + i] == '=')
				work[i] = 0x00;
			else if (src[n + i] <= 0x39)
				work[i] = src[n + i] + 0x04;
			else if (src[n + i] <= 0x5A)
				work[i] = src[n + i] - 0x41;
			else if (src[n + i] <= 0x7A)
				work[i] = src[n + i] - 0x47;
		}

		tmp[m] = ((work[0] << 2) & 0xFC) ^ ((work[1] >> 4) & 0x03);
		if (src[n + 1] == '=')
		{
			break;
		}
		tmp[m + 1] = ((work[1] << 4) & 0xF0) ^ ((work[2] >> 2) & 0x0F);
		if (src[n + 2] == '=')
		{
			break;
		}
		tmp[m + 2] = ((work[2] << 6) & 0xC0) ^ (work[3] & 0x3F);
		if (src[n + 3] == '=')
		{
			break;
		}
	}

	*dst = tmp;

	return (dst_len);
ERROR:
	free(tmp);
	return (0);
}

int 
base64_get_dst_len(const int type, const char *src, const int src_len)
{
	int             n, dst_len;

	switch (type)
	{
	case BASE64_TYPE_ENCODE:
		dst_len = src_len / 3 * 4;
		if (src_len % 3)
		{
			dst_len += 4;
		}
		break;
	case BASE64_TYPE_DECODE:
		dst_len = src_len;
		for (n = src_len - 1; *(src + n) == '='; n--)
		{
			dst_len--;
		}
		dst_len = dst_len / 4 * 3;

		if (src[src_len - 2] != '=' && src[src_len - 1] == '=')
		{
			dst_len += 2;
		} else if (src[src_len - 3] != '=' && src[src_len - 2] == '=')
		{
			dst_len += 1;
		} else if (src[src_len - 4] != '=' && src[src_len - 3] == '=')
		{
			dst_len += 1;
		}
		break;
	default:
		goto ERROR;
	}

	return (dst_len);
ERROR:
	return (0);
}

char           *
base64_calloc(const int type, const int dst_len)
{
	char           *dst = NULL;

	if (!dst_len)
	{
		goto ERROR;
	}
	dst = (char *) calloc(dst_len + 1, sizeof(char));
	if (!dst)
	{
		goto ERROR;
	}
	if (type == BASE64_TYPE_ENCODE)
	{
		memset(dst, '=', dst_len);
	}
	return (dst);
ERROR:
	return (NULL);
}

char 
base64_encode_core(const char src)
{
	char            dst = '\0';

	if (src <= 25)
		dst = src + 0x41;
	else if (src <= 51)
		dst = src + 0x47;
	else if (src <= 61)
		dst = src - 4;
	else if (src == 62)
		dst = '+';
	else if (src == 63)
		dst = '/';

	return (dst);
}
