/* -*- Mode: c; c-basic-offset: 8; Coding: utf-8-unix -*- ;; */
/* $Id: heady.c 2 2008-05-27 07:44:27Z mtaneda $	 */

/*
 * Copyright 2008 The piranha Project. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PIRANHA PROJECT ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE PIRANHA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the piranha Project.
 */

#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	"pairlist.h"
#include	"strtool.h"
#include	"heady.h"

struct heady
{
	pairlist_t     *header;
	char           *body;
};

heady_t        *
heady_create(void)
{
	heady_t        *obj = NULL;

	obj = (heady_t *) calloc(1, sizeof(heady_t));
	if (!obj)
	{
		goto ERROR;
	}
	obj->header = pairlist_create();
	obj->body = NULL;

	if (!obj->header)
	{
		goto ERROR;
	}
	return (obj);
ERROR:
	heady_destroy(obj);
	return (NULL);
}

void 
heady_destroy(heady_t * obj)
{
	if (obj)
	{
		pairlist_destroy(obj->header);
		free(obj->body);
		free(obj);
	}
}

int 
heady_add_header(heady_t * obj, const char *name, const char *value)
{
	int             err;

	if (!obj)
	{
		goto ERROR;
	}
	err = pairlist_push(obj->header, name, value);
	if (!err)
	{
		goto ERROR;
	}
	return (0);
ERROR:
	return (1);
}

int 
heady_del_header_by_name(heady_t * obj, const char *name)
{
	int             err;

	if (!obj || strtool_isempty(name))
	{
		goto ERROR;
	}
	err = pairlist_del_by_name(obj->header, name);

	if (err)
	{
		goto ERROR;
	}
	return (0);
ERROR:
	return (1);
}

char           *
heady_refer_header_by_name(heady_t * obj, const char *name)
{
	if (!obj || strtool_isempty(name))
	{
		goto ERROR;
	}
	return (pairlist_refer_value_by_name(obj->header, name));
ERROR:
	return (NULL);
}

int 
heady_pop_header(heady_t * obj, char **name, char **value)
{
	if (!obj || !name | !value)
	{
		goto ERROR;
	}
	pairlist_pop(obj->header, name, value);

	return (0);
ERROR:
	*name = NULL;
	*value = NULL;
	return (1);
}

int 
heady_set_body(heady_t * obj, const char *body)
{
	if (!obj || obj->body || strtool_isempty(body))
	{
		goto ERROR;
	}
	obj->body = strdup(body);

	return (0);
ERROR:
	return (1);
}

char           *
heady_to_str(const heady_t * obj, const char *eol)
{
	char           *dst = NULL;
	char           *name, *value;
	int             n, len;

	if (!obj || strtool_isempty(eol))
	{
		goto ERROR;
	}
	if (obj->header)
	{
		len = pairlist_len(obj->header);

		for (n = 0; n < len; n++)
		{
			pairlist_refer(obj->header, n, &name, &value);

			strtool_cat(&dst, name);
			strtool_cat(&dst, ": ");
			strtool_cat(&dst, value);
			strtool_cat(&dst, eol);
		}

		strtool_cat(&dst, eol);
	}
	if (obj->body)
	{
		strtool_cat(&dst, obj->body);
	}
	return (dst);
ERROR:
	free(dst);
	return (NULL);
}
