/* -*- Mode: c; c-basic-offset: 8; Coding: utf-8-unix -*- ;; */
/* $Id: mime.h 2 2008-05-27 07:44:27Z mtaneda $	 */

/*
 * Copyright 2008 The piranha Project. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PIRANHA PROJECT ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE PIRANHA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the piranha Project.
 */

#ifndef	_inc_mime_h
#define	_inc_mime_h

#define	MIME_ENCODING_7BIT	(0x01 << 0)
#define	MIME_ENCODING_8BIT	(0x01 << 1)
#define	MIME_ENCODING_BINARY	(0x01 << 2)
#define	MIME_ENCODING_QUOTED	(0x01 << 3)
#define	MIME_ENCODING_BASE64	(0x01 << 4)

typedef struct mime mime_t;

extern mime_t  *mime_create(void);
extern void     mime_destroy(mime_t * obj);

extern int      mime_new_data(mime_t * obj);
extern int      mime_del_data(mime_t * obj, const int offset);

extern int      mime_set_type(mime_t * obj, const int offset, const char *type);
extern int      mime_set_encoding(mime_t * obj, const int offset, const int encoding);
extern int      mime_disposition(mime_t * obj, const int offset, const char *disposition);

extern int
                mime_pop_header(mime_t * obj, const int offset, char **name, char **value);
extern int
                mime_set_header(mime_t * obj, const int offset, const char *name, const char *value);

extern int      mime_set_body(mime_t * obj, const int offset, const char *body);

extern char    *mime_to_str(const mime_t * obj, const char *boundary, const char *eol);

extern int      mime_len(const mime_t * obj);

#endif
