/* -*- Mode: c; c-basic-offset: 8; Coding: utf-8-unix -*- ;; */
/* $Id: multilist.h 2 2008-05-27 07:44:27Z mtaneda $	 */

/*
 * Copyright 2008 The piranha Project. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PIRANHA PROJECT ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE PIRANHA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the piranha Project.
 */

#ifndef	_inc_multilist_h
#define	_inc_multilist_h

#include	"strlist.h"

typedef struct multilist multilist_t;

extern multilist_t *multilist_create(void);
extern int      multilist_destroy(multilist_t * obj);

extern int
                multilist_pop(multilist_t * obj, char **name, strlist_t ** value);
extern int
                multilist_push(multilist_t * obj, const char *name, const strlist_t * value);

extern int
                multilist_add(multilist_t * obj, const char *name, const strlist_t * value);
extern int
                multilist_get(const multilist_t * obj, const int offset, char **name, strlist_t ** value);
extern int
                multilist_refer(const multilist_t * obj, const int offset, char **name, strlist_t ** value);

extern int
                multilist_dequeue(multilist_t * obj, char **name, strlist_t ** value);
extern int
                multilist_queue(multilist_t * obj, const char *name, const strlist_t * value);

extern int
                multilist_add_value_by_name(multilist_t * obj, const char *name, const char *value);
extern strlist_t *
                multilist_get_value_by_name(const multilist_t * obj, const char *name);
extern strlist_t *
                multilist_refer_value_by_name(const multilist_t * obj, const char *name);

extern multilist_t *multilist_dup(const multilist_t * obj);
extern multilist_t *multilist_ndup(const multilist_t * obj, const int len);
extern int      multilist_len(const multilist_t * obj);

#endif
