/* -*- Mode: c; c-basic-offset: 8; Coding: utf-8-unix -*- ;; */
/* $Id: nettool.h 2 2008-05-27 07:44:27Z mtaneda $	 */

/*
 * Copyright 2008 The piranha Project. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PIRANHA PROJECT ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE PIRANHA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the piranha Project.
 */

#ifndef	_inc_nettool_h
#define	_inc_nettool_h

extern int      nettool_is_mac_addr(const char *str);
extern int      nettool_is_ipv4_addr(const char *str, const int ismask, const int isnet);
extern int      nettool_is_ipv4_addr_subnet(const char *str, const char *addr, const char *mask);
extern int      nettool_is_inside_range(const char *addr, const char *range_s, const char *range_e);
extern int      nettool_is_inside_range(const char *addr, const char *range_s, const char *range_e);
extern int      nettool_is_host_name(const char *str);
extern int      nettool_is_domain_name(const char *str);
extern int      nettool_is_mail_addr(const char *str);

extern char    *nettool_get_interface_addr(const char *interface);
extern char    *nettool_get_interface_mask(const char *interface);
extern char    *nettool_get_interface_gateway(const char *interface);
extern char    *nettool_get_hostname(void);

extern char    *
nettool_get_new_ipv4_addr(const char *old_addr,
			  const char *old_subnet, const char *old_mask,
			  const char *new_subnet, const char *new_mask);

extern char    *nettool_atoh(const char *src);
extern char    *nettool_htoa(const char *src);

#endif
