/* -*- Mode: c; c-basic-offset: 8; Coding: utf-8-unix -*- ;; */
/* $Id: route.c 2 2008-05-27 07:44:27Z mtaneda $	 */

/*
 * Copyright 2008 The piranha Project. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PIRANHA PROJECT ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE PIRANHA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the piranha Project.
 */

#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<sys/socket.h>
#include	<netinet/in.h>
#include	<arpa/inet.h>
#include	"strtool.h"
#include	"nettool.h"
#include	"strlist.h"
#include	"strlists.h"
#include	"route.h"

char           *
read_proc_fs(const char *path)
{
	FILE           *fp = NULL;
	char            buf[1024];
	char           *dst = NULL;

	if (strtool_isempty(path))
	{
		goto ERROR;
	}
	fp = fopen(path, "r");
	if (!fp)
	{
		goto ERROR;
	}
	while (1)
	{
		memset(buf, 0, sizeof(buf));
		if (!fgets(buf, sizeof(buf), fp))
		{
			break;
		}
		strtool_cat(&dst, buf);
	}

	fclose(fp);

	return (dst);
ERROR:
	if (fp)
	{
		fclose(fp);
	}
	free(dst);
	return (NULL);
}

strlists_t     *
route_get_table(void)
{
	strlists_t     *obj = NULL;
	char           *data = NULL;
	int             n;
	strlist_t      *lines, *line;

	data = read_proc_fs("/proc/net/route");
	if (!data)
	{
		goto ERROR;
	}
	for (n = 0; data[n]; n++)
	{
		if (data[n] == '\t')
		{
			data[n] = ' ';
		}
	}

	obj = strlists_create();
	if (!obj)
	{
		goto ERROR;
	}
	lines = strtool_split(data, "\n", 0);
	if (strlist_len(lines) < 2)
	{
		goto ERROR;
	}
	for (n = 0; n < strlist_len(lines); n++)
	{
		line = strtool_split(strlist_refer(lines, n), " ", 0);

		if (!strlist_len(line))
		{
			continue;
		}
		strlists_push(obj, line);

		strlist_destroy(line);
	}

	strlist_destroy(lines);

	if (!strlists_len(obj))
	{
		goto ERROR;
	}
	free(data);

	return (obj);
ERROR:
	free(data);
	strlists_destroy(obj);
	return (NULL);
}

char           *
route_get_gateway_by_addr(const char *addr)
{
	strlists_t     *data = NULL;
	strlist_t      *tmp;
	struct in_addr  ia;
	int             od, og, om;
	char           *subnet, *mask;
	char           *dst = NULL;
	int             n, len;

	if (strtool_isempty(addr) || !inet_aton(addr, &ia))
	{
		goto ERROR;
	}
	data = route_get_table();
	if (!data)
	{
		goto ERROR;
	}
	tmp = strlists_refer(data, 0);

	od = strlist_get_offset(tmp, "Destination");
	og = strlist_get_offset(tmp, "Gateway");
	om = strlist_get_offset(tmp, "Mask");

	if (od < 0 || og < 0 || om < 0)
	{
		goto ERROR;
	}
	len = strlists_len(data);

	for (n = 1; n < len; n++)
	{
		tmp = strlists_refer(data, n);

		subnet = nettool_htoa(strlist_refer(tmp, od));
		mask = nettool_htoa(strlist_refer(tmp, om));

		if (!subnet || !mask)
		{
			goto ERROR;
		}
		if (nettool_is_ipv4_addr_subnet(addr, subnet, mask) || strcmp(addr, subnet) == 0)
		{
			dst = nettool_htoa(strlist_refer(tmp, og));
			free(subnet);
			free(mask);
			break;
		}
		free(subnet);
		free(mask);
	}

	strlists_destroy(data);

	return (dst);
ERROR:
	free(dst);
	strlists_destroy(data);
	return (NULL);
}

int 
route_set_gateway(const char *gateway, const char *subnet, const char *mask)
{
	return (0);
}

int 
main(int argc, char *argv[])
{
	char           *gw = NULL;

	gw = route_get_gateway_by_addr("0.0.0.0");

	printf("%s\n", gw);

	free(gw);

	return (0);
}
